/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.AdjustHistory;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_YEAR", uniqueConstraints={@UniqueConstraint(columnNames={"code", "company", "typeSelect"})}, indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="company")})
public class Year
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_YEAR_SEQ")
    @SequenceGenerator(name="BASE_YEAR_SEQ", sequenceName="BASE_YEAR_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Code")
    @NotNull
    private String code;
    @Widget(title="From")
    @NotNull
    private LocalDate fromDate;
    @Widget(title="To")
    @NotNull
    private LocalDate toDate;
    @Widget(title="Periods list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="year", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Period> periodList;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Status", readonly=true, selection="base.year.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Period duration", selection="base.year.period.duration.select")
    private Integer periodDurationSelect = 0;
    @Widget(title="Type", selection="account.year.type.select")
    @NotNull
    private Integer typeSelect = 0;
    @Widget(title="Adjust History")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="fiscalYear", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AdjustHistory> adjustHistoryList;
    @Widget(title="Reported balance Date")
    private LocalDate reportedBalanceDate;
    @Widget(title="Closure date")
    private LocalDateTime closureDateTime;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Year() {
    }

    public Year(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public List<Period> getPeriodList() {
        return this.periodList;
    }

    public void setPeriodList(List<Period> periodList) {
        this.periodList = periodList;
    }

    public void addPeriodListItem(Period item) {
        if (this.getPeriodList() == null) {
            this.setPeriodList(new ArrayList<Period>());
        }
        this.getPeriodList().add(item);
        item.setYear(this);
    }

    public void removePeriodListItem(Period item) {
        if (this.getPeriodList() == null) {
            return;
        }
        this.getPeriodList().remove((Object)item);
    }

    public void clearPeriodList() {
        if (this.getPeriodList() != null) {
            this.getPeriodList().clear();
        }
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Integer getPeriodDurationSelect() {
        return this.periodDurationSelect == null ? 0 : this.periodDurationSelect;
    }

    public void setPeriodDurationSelect(Integer periodDurationSelect) {
        this.periodDurationSelect = periodDurationSelect;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public List<AdjustHistory> getAdjustHistoryList() {
        return this.adjustHistoryList;
    }

    public void setAdjustHistoryList(List<AdjustHistory> adjustHistoryList) {
        this.adjustHistoryList = adjustHistoryList;
    }

    public void addAdjustHistoryListItem(AdjustHistory item) {
        if (this.getAdjustHistoryList() == null) {
            this.setAdjustHistoryList(new ArrayList<AdjustHistory>());
        }
        this.getAdjustHistoryList().add(item);
        item.setFiscalYear(this);
    }

    public void removeAdjustHistoryListItem(AdjustHistory item) {
        if (this.getAdjustHistoryList() == null) {
            return;
        }
        this.getAdjustHistoryList().remove(item);
    }

    public void clearAdjustHistoryList() {
        if (this.getAdjustHistoryList() != null) {
            this.getAdjustHistoryList().clear();
        }
    }

    public LocalDate getReportedBalanceDate() {
        return this.reportedBalanceDate;
    }

    public void setReportedBalanceDate(LocalDate reportedBalanceDate) {
        this.reportedBalanceDate = reportedBalanceDate;
    }

    public LocalDateTime getClosureDateTime() {
        return this.closureDateTime;
    }

    public void setClosureDateTime(LocalDateTime closureDateTime) {
        this.closureDateTime = closureDateTime;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Year)) {
            return false;
        }
        Year other = (Year)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("statusSelect", (Object)this.getStatusSelect()).add("periodDurationSelect", (Object)this.getPeriodDurationSelect()).add("typeSelect", (Object)this.getTypeSelect()).add("reportedBalanceDate", (Object)this.getReportedBalanceDate()).add("closureDateTime", (Object)this.getClosureDateTime()).omitNullValues().toString();
    }
}

