/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businesssupport.db;

import com.axelor.apps.project.db.Project;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BUSINESSSUPPORT_PROJECT_VERSION", indexes={@Index(columnList="title"), @Index(columnList="project")})
public class ProjectVersion
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BUSINESSSUPPORT_PROJECT_VERSION_SEQ")
    @SequenceGenerator(name="BUSINESSSUPPORT_PROJECT_VERSION_SEQ", sequenceName="BUSINESSSUPPORT_PROJECT_VERSION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Title")
    @NameColumn
    private String title;
    @Widget(title="Project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="Status", selection="support.project.version.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Testing server date")
    private LocalDate testingServerDate;
    @Widget(title="Production server date")
    private LocalDate productionServerDate;
    @Widget(title="Content")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String content;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public LocalDate getTestingServerDate() {
        return this.testingServerDate;
    }

    public void setTestingServerDate(LocalDate testingServerDate) {
        this.testingServerDate = testingServerDate;
    }

    public LocalDate getProductionServerDate() {
        return this.productionServerDate;
    }

    public void setProductionServerDate(LocalDate productionServerDate) {
        this.productionServerDate = productionServerDate;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectVersion)) {
            return false;
        }
        ProjectVersion other = (ProjectVersion)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("title", (Object)this.getTitle()).add("statusSelect", (Object)this.getStatusSelect()).add("testingServerDate", (Object)this.getTestingServerDate()).add("productionServerDate", (Object)this.getProductionServerDate()).omitNullValues().toString();
    }
}

