/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.project.db.ProjectFolder;
import com.axelor.apps.project.db.TaskTemplate;
import com.axelor.apps.project.db.TeamTaskCategory;
import com.axelor.apps.project.db.Wiki;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PROJECT_PROJECT_TEMPLATE", indexes={@Index(columnList="name"), @Index(columnList="team"), @Index(columnList="assigned_to"), @Index(columnList="company"), @Index(columnList="fullName")})
public class ProjectTemplate
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROJECT_PROJECT_TEMPLATE_SEQ")
    @SequenceGenerator(name="PROJECT_PROJECT_TEMPLATE_SEQ", sequenceName="PROJECT_PROJECT_TEMPLATE_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    private String name;
    @Widget(multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Project Folders")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectFolder> projectFolderSet;
    @Widget(title="Assigned to")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User assignedTo;
    @Widget(title="Type of authorized categories")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<TeamTaskCategory> teamTaskCategorySet;
    private Boolean synchronize = Boolean.FALSE;
    @Widget(title="Wiki")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="projectTemplate", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Wiki> wikiList;
    @HashKey
    @Widget(title="Code")
    @Column(unique=true)
    private String code;
    @Widget(title="Membres")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<User> membersUserSet;
    @Widget(massUpdate=true)
    private Boolean imputable = Boolean.TRUE;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Type of authorized activities")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Product> productSet;
    @Widget(title="Name")
    @NameColumn
    private String fullName;
    @Widget(title="Exclude planning")
    private Boolean excludePlanning = Boolean.FALSE;
    @Widget(title="Business project")
    private Boolean isBusinessProject = Boolean.FALSE;
    @Widget(title="Task templates")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<TaskTemplate> taskTemplateSet;
    @Widget(title="Invoicing Expenses")
    private Boolean isInvoicingExpenses = Boolean.FALSE;
    @Widget(title="Invoicing Purchases")
    private Boolean isInvoicingPurchases = Boolean.FALSE;
    @Widget(title="Invoicing Type", selection="project.invoicing.type.select")
    private Integer invoicingTypeSelect = 0;
    @Widget(title="Invoicing comment")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String invoicingComment;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProjectTemplate() {
    }

    public ProjectTemplate(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Set<ProjectFolder> getProjectFolderSet() {
        return this.projectFolderSet;
    }

    public void setProjectFolderSet(Set<ProjectFolder> projectFolderSet) {
        this.projectFolderSet = projectFolderSet;
    }

    public void addProjectFolderSetItem(ProjectFolder item) {
        if (this.getProjectFolderSet() == null) {
            this.setProjectFolderSet(new HashSet<ProjectFolder>());
        }
        this.getProjectFolderSet().add(item);
    }

    public void removeProjectFolderSetItem(ProjectFolder item) {
        if (this.getProjectFolderSet() == null) {
            return;
        }
        this.getProjectFolderSet().remove(item);
    }

    public void clearProjectFolderSet() {
        if (this.getProjectFolderSet() != null) {
            this.getProjectFolderSet().clear();
        }
    }

    public User getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(User assignedTo) {
        this.assignedTo = assignedTo;
    }

    public Set<TeamTaskCategory> getTeamTaskCategorySet() {
        return this.teamTaskCategorySet;
    }

    public void setTeamTaskCategorySet(Set<TeamTaskCategory> teamTaskCategorySet) {
        this.teamTaskCategorySet = teamTaskCategorySet;
    }

    public void addTeamTaskCategorySetItem(TeamTaskCategory item) {
        if (this.getTeamTaskCategorySet() == null) {
            this.setTeamTaskCategorySet(new HashSet<TeamTaskCategory>());
        }
        this.getTeamTaskCategorySet().add(item);
    }

    public void removeTeamTaskCategorySetItem(TeamTaskCategory item) {
        if (this.getTeamTaskCategorySet() == null) {
            return;
        }
        this.getTeamTaskCategorySet().remove((Object)item);
    }

    public void clearTeamTaskCategorySet() {
        if (this.getTeamTaskCategorySet() != null) {
            this.getTeamTaskCategorySet().clear();
        }
    }

    public Boolean getSynchronize() {
        return this.synchronize == null ? Boolean.FALSE : this.synchronize;
    }

    public void setSynchronize(Boolean synchronize) {
        this.synchronize = synchronize;
    }

    public List<Wiki> getWikiList() {
        return this.wikiList;
    }

    public void setWikiList(List<Wiki> wikiList) {
        this.wikiList = wikiList;
    }

    public void addWikiListItem(Wiki item) {
        if (this.getWikiList() == null) {
            this.setWikiList(new ArrayList<Wiki>());
        }
        this.getWikiList().add(item);
        item.setProjectTemplate(this);
    }

    public void removeWikiListItem(Wiki item) {
        if (this.getWikiList() == null) {
            return;
        }
        this.getWikiList().remove(item);
    }

    public void clearWikiList() {
        if (this.getWikiList() != null) {
            this.getWikiList().clear();
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Set<User> getMembersUserSet() {
        return this.membersUserSet;
    }

    public void setMembersUserSet(Set<User> membersUserSet) {
        this.membersUserSet = membersUserSet;
    }

    public void addMembersUserSetItem(User item) {
        if (this.getMembersUserSet() == null) {
            this.setMembersUserSet(new HashSet<User>());
        }
        this.getMembersUserSet().add(item);
    }

    public void removeMembersUserSetItem(User item) {
        if (this.getMembersUserSet() == null) {
            return;
        }
        this.getMembersUserSet().remove((Object)item);
    }

    public void clearMembersUserSet() {
        if (this.getMembersUserSet() != null) {
            this.getMembersUserSet().clear();
        }
    }

    public Boolean getImputable() {
        return this.imputable == null ? Boolean.FALSE : this.imputable;
    }

    public void setImputable(Boolean imputable) {
        this.imputable = imputable;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Set<Product> getProductSet() {
        return this.productSet;
    }

    public void setProductSet(Set<Product> productSet) {
        this.productSet = productSet;
    }

    public void addProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            this.setProductSet(new HashSet<Product>());
        }
        this.getProductSet().add(item);
    }

    public void removeProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            return;
        }
        this.getProductSet().remove((Object)item);
    }

    public void clearProductSet() {
        if (this.getProductSet() != null) {
            this.getProductSet().clear();
        }
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Boolean getExcludePlanning() {
        return this.excludePlanning == null ? Boolean.FALSE : this.excludePlanning;
    }

    public void setExcludePlanning(Boolean excludePlanning) {
        this.excludePlanning = excludePlanning;
    }

    public Boolean getIsBusinessProject() {
        return this.isBusinessProject == null ? Boolean.FALSE : this.isBusinessProject;
    }

    public void setIsBusinessProject(Boolean isBusinessProject) {
        this.isBusinessProject = isBusinessProject;
    }

    public Set<TaskTemplate> getTaskTemplateSet() {
        return this.taskTemplateSet;
    }

    public void setTaskTemplateSet(Set<TaskTemplate> taskTemplateSet) {
        this.taskTemplateSet = taskTemplateSet;
    }

    public void addTaskTemplateSetItem(TaskTemplate item) {
        if (this.getTaskTemplateSet() == null) {
            this.setTaskTemplateSet(new HashSet<TaskTemplate>());
        }
        this.getTaskTemplateSet().add(item);
    }

    public void removeTaskTemplateSetItem(TaskTemplate item) {
        if (this.getTaskTemplateSet() == null) {
            return;
        }
        this.getTaskTemplateSet().remove((Object)item);
    }

    public void clearTaskTemplateSet() {
        if (this.getTaskTemplateSet() != null) {
            this.getTaskTemplateSet().clear();
        }
    }

    public Boolean getIsInvoicingExpenses() {
        return this.isInvoicingExpenses == null ? Boolean.FALSE : this.isInvoicingExpenses;
    }

    public void setIsInvoicingExpenses(Boolean isInvoicingExpenses) {
        this.isInvoicingExpenses = isInvoicingExpenses;
    }

    public Boolean getIsInvoicingPurchases() {
        return this.isInvoicingPurchases == null ? Boolean.FALSE : this.isInvoicingPurchases;
    }

    public void setIsInvoicingPurchases(Boolean isInvoicingPurchases) {
        this.isInvoicingPurchases = isInvoicingPurchases;
    }

    public Integer getInvoicingTypeSelect() {
        return this.invoicingTypeSelect == null ? 0 : this.invoicingTypeSelect;
    }

    public void setInvoicingTypeSelect(Integer invoicingTypeSelect) {
        this.invoicingTypeSelect = invoicingTypeSelect;
    }

    public String getInvoicingComment() {
        return this.invoicingComment;
    }

    public void setInvoicingComment(String invoicingComment) {
        this.invoicingComment = invoicingComment;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectTemplate)) {
            return false;
        }
        ProjectTemplate other = (ProjectTemplate)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(1584138899, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("synchronize", (Object)this.getSynchronize()).add("code", (Object)this.getCode()).add("imputable", (Object)this.getImputable()).add("fullName", (Object)this.getFullName()).add("excludePlanning", (Object)this.getExcludePlanning()).add("isBusinessProject", (Object)this.getIsBusinessProject()).add("isInvoicingExpenses", (Object)this.getIsInvoicingExpenses()).add("isInvoicingPurchases", (Object)this.getIsInvoicingPurchases()).add("invoicingTypeSelect", (Object)this.getInvoicingTypeSelect()).omitNullValues().toString();
    }
}

