/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.studio.db.ActionBuilder;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_ACTION_BUILDER_LINE", indexes={@Index(columnList="action_builder"), @Index(columnList="meta_json_field"), @Index(columnList="meta_field"), @Index(columnList="value_json"), @Index(columnList="value_field"), @Index(columnList="parent"), @Index(columnList="name")})
public class ActionBuilderLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_ACTION_BUILDER_LINE_SEQ")
    @SequenceGenerator(name="STUDIO_ACTION_BUILDER_LINE_SEQ", sequenceName="STUDIO_ACTION_BUILDER_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Action builder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ActionBuilder actionBuilder;
    @Widget(title="Target field")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaJsonField metaJsonField;
    @Widget(title="Target field")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField metaField;
    @Widget(title="Source field")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaJsonField valueJson;
    @Widget(title="Source field")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField valueField;
    @Widget(title="Value expr")
    private String value;
    @Widget(title="Condition")
    private String conditionText;
    @Widget(title="Filter")
    private String filter;
    @Widget(title="Validation type")
    private String validationTypeSelect;
    @Widget(title="Message")
    private String validationMsg;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parent", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ActionBuilderLine> subLines;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ActionBuilderLine parent;
    @Widget(title="Target field")
    private String name;
    @Widget(title="Dummy")
    private Boolean dummy = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ActionBuilderLine() {
    }

    public ActionBuilderLine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ActionBuilder getActionBuilder() {
        return this.actionBuilder;
    }

    public void setActionBuilder(ActionBuilder actionBuilder) {
        this.actionBuilder = actionBuilder;
    }

    public MetaJsonField getMetaJsonField() {
        return this.metaJsonField;
    }

    public void setMetaJsonField(MetaJsonField metaJsonField) {
        this.metaJsonField = metaJsonField;
    }

    public MetaField getMetaField() {
        return this.metaField;
    }

    public void setMetaField(MetaField metaField) {
        this.metaField = metaField;
    }

    public MetaJsonField getValueJson() {
        return this.valueJson;
    }

    public void setValueJson(MetaJsonField valueJson) {
        this.valueJson = valueJson;
    }

    public MetaField getValueField() {
        return this.valueField;
    }

    public void setValueField(MetaField valueField) {
        this.valueField = valueField;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getConditionText() {
        return this.conditionText;
    }

    public void setConditionText(String conditionText) {
        this.conditionText = conditionText;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getValidationTypeSelect() {
        return this.validationTypeSelect;
    }

    public void setValidationTypeSelect(String validationTypeSelect) {
        this.validationTypeSelect = validationTypeSelect;
    }

    public String getValidationMsg() {
        return this.validationMsg;
    }

    public void setValidationMsg(String validationMsg) {
        this.validationMsg = validationMsg;
    }

    public List<ActionBuilderLine> getSubLines() {
        return this.subLines;
    }

    public void setSubLines(List<ActionBuilderLine> subLines) {
        this.subLines = subLines;
    }

    public void addSubLine(ActionBuilderLine item) {
        if (this.getSubLines() == null) {
            this.setSubLines(new ArrayList<ActionBuilderLine>());
        }
        this.getSubLines().add(item);
        item.setParent(this);
    }

    public void removeSubLine(ActionBuilderLine item) {
        if (this.getSubLines() == null) {
            return;
        }
        this.getSubLines().remove((Object)item);
    }

    public void clearSubLines() {
        if (this.getSubLines() != null) {
            this.getSubLines().clear();
        }
    }

    public ActionBuilderLine getParent() {
        return this.parent;
    }

    public void setParent(ActionBuilderLine parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getDummy() {
        return this.dummy == null ? Boolean.FALSE : this.dummy;
    }

    public void setDummy(Boolean dummy) {
        this.dummy = dummy;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ActionBuilderLine)) {
            return false;
        }
        ActionBuilderLine other = (ActionBuilderLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("value", (Object)this.getValue()).add("conditionText", (Object)this.getConditionText()).add("filter", (Object)this.getFilter()).add("validationTypeSelect", (Object)this.getValidationTypeSelect()).add("validationMsg", (Object)this.getValidationMsg()).add("name", (Object)this.getName()).add("dummy", (Object)this.getDummy()).omitNullValues().toString();
    }
}

