/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.studio.db.ActionBuilder;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_ACTION_BUILDER_VIEW", indexes={@Index(columnList="action_builder")})
public class ActionBuilderView
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_ACTION_BUILDER_VIEW_SEQ")
    @SequenceGenerator(name="STUDIO_ACTION_BUILDER_VIEW_SEQ", sequenceName="STUDIO_ACTION_BUILDER_VIEW_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Type", selection="view.type.selection")
    @NotNull
    private String viewType;
    @Widget(title="Name")
    @NotNull
    private String viewName;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ActionBuilder actionBuilder;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="If")
    private String viewConditionToCheck;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getViewType() {
        return this.viewType;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public ActionBuilder getActionBuilder() {
        return this.actionBuilder;
    }

    public void setActionBuilder(ActionBuilder actionBuilder) {
        this.actionBuilder = actionBuilder;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getViewConditionToCheck() {
        return this.viewConditionToCheck;
    }

    public void setViewConditionToCheck(String viewConditionToCheck) {
        this.viewConditionToCheck = viewConditionToCheck;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ActionBuilderView)) {
            return false;
        }
        ActionBuilderView other = (ActionBuilderView)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("viewType", (Object)this.getViewType()).add("viewName", (Object)this.getViewName()).add("sequence", (Object)this.getSequence()).add("viewConditionToCheck", (Object)this.getViewConditionToCheck()).omitNullValues().toString();
    }
}

