/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.apps.base.db.App;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_APP_BUILDER", indexes={@Index(columnList="name"), @Index(columnList="image"), @Index(columnList="generated_app")})
public class AppBuilder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_APP_BUILDER_SEQ")
    @SequenceGenerator(name="STUDIO_APP_BUILDER_SEQ", sequenceName="STUDIO_APP_BUILDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name", translatable=true)
    @NotNull
    private String name;
    @HashKey
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="Description", translatable=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Depends on")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<App> dependsOnSet;
    @Widget(title="Image")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile image;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private App generatedApp;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public AppBuilder() {
    }

    public AppBuilder(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<App> getDependsOnSet() {
        return this.dependsOnSet;
    }

    public void setDependsOnSet(Set<App> dependsOnSet) {
        this.dependsOnSet = dependsOnSet;
    }

    public void addDependsOnSetItem(App item) {
        if (this.getDependsOnSet() == null) {
            this.setDependsOnSet(new HashSet<App>());
        }
        this.getDependsOnSet().add(item);
    }

    public void removeDependsOnSetItem(App item) {
        if (this.getDependsOnSet() == null) {
            return;
        }
        this.getDependsOnSet().remove(item);
    }

    public void clearDependsOnSet() {
        if (this.getDependsOnSet() != null) {
            this.getDependsOnSet().clear();
        }
    }

    public MetaFile getImage() {
        return this.image;
    }

    public void setImage(MetaFile image) {
        this.image = image;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public App getGeneratedApp() {
        return this.generatedApp;
    }

    public void setGeneratedApp(App generatedApp) {
        this.generatedApp = generatedApp;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AppBuilder)) {
            return false;
        }
        AppBuilder other = (AppBuilder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(-938053030, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("sequence", (Object)this.getSequence()).omitNullValues().toString();
    }
}

