/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaView;
import com.axelor.studio.db.AppBuilder;
import com.axelor.studio.db.DashboardBuilder;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_DASHLET_BUILDER", uniqueConstraints={@UniqueConstraint(columnNames={"name", "dashboard_builder"})}, indexes={@Index(columnList="name"), @Index(columnList="meta_view"), @Index(columnList="dashboard_builder"), @Index(columnList="action"), @Index(columnList="app_builder")})
public class DashletBuilder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_DASHLET_BUILDER_SEQ")
    @SequenceGenerator(name="STUDIO_DASHLET_BUILDER_SEQ", sequenceName="STUDIO_DASHLET_BUILDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="View")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaView metaView;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DashboardBuilder dashboardBuilder;
    @Widget(title="Action")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaAction action;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="Type", selection="view.type.selection")
    private String viewType;
    @Widget(title="Colspan")
    private Integer colspan = 0;
    @Widget(title="Pagination limit")
    private Integer paginationLimit = 0;
    @Widget(title="App builder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBuilder appBuilder;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public DashletBuilder() {
    }

    public DashletBuilder(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetaView getMetaView() {
        return this.metaView;
    }

    public void setMetaView(MetaView metaView) {
        this.metaView = metaView;
    }

    public DashboardBuilder getDashboardBuilder() {
        return this.dashboardBuilder;
    }

    public void setDashboardBuilder(DashboardBuilder dashboardBuilder) {
        this.dashboardBuilder = dashboardBuilder;
    }

    public MetaAction getAction() {
        return this.action;
    }

    public void setAction(MetaAction action) {
        this.action = action;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getViewType() {
        return this.viewType;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    public Integer getColspan() {
        return this.colspan == null ? 0 : this.colspan;
    }

    public void setColspan(Integer colspan) {
        this.colspan = colspan;
    }

    public Integer getPaginationLimit() {
        return this.paginationLimit == null ? 0 : this.paginationLimit;
    }

    public void setPaginationLimit(Integer paginationLimit) {
        this.paginationLimit = paginationLimit;
    }

    public AppBuilder getAppBuilder() {
        return this.appBuilder;
    }

    public void setAppBuilder(AppBuilder appBuilder) {
        this.appBuilder = appBuilder;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DashletBuilder)) {
            return false;
        }
        DashletBuilder other = (DashletBuilder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("sequence", (Object)this.getSequence()).add("viewType", (Object)this.getViewType()).add("colspan", (Object)this.getColspan()).add("paginationLimit", (Object)this.getPaginationLimit()).omitNullValues().toString();
    }
}

