/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.studio.db.ActionBuilder;
import com.axelor.studio.db.ChartBuilder;
import com.axelor.studio.db.Wkf;
import com.axelor.studio.db.WkfTransition;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_FILTER", indexes={@Index(columnList="chart_builder"), @Index(columnList="meta_field"), @Index(columnList="meta_json_field"), @Index(columnList="wkf_transition"), @Index(columnList="wkf"), @Index(columnList="action_builder")})
public class Filter
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_FILTER_SEQ")
    @SequenceGenerator(name="STUDIO_FILTER_SEQ", sequenceName="STUDIO_FILTER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Module")
    private String moduleName;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ChartBuilder chartBuilder;
    @Widget(title="Field")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField metaField;
    @Widget(title="Json Field")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaJsonField metaJsonField;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WkfTransition wkfTransition;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Wkf wkf;
    @Widget(title="Operator", selection="studio.filter.operator")
    @NotNull
    private String operator;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ActionBuilder actionBuilder;
    @Widget(title="Target field")
    private String targetField;
    @Widget(title="Target type")
    private String targetType;
    @Widget(title="Value")
    private String value;
    @Widget(title="Default Value")
    private String defaultValue;
    @Widget(title="Target title")
    private String targetTitle;
    @Widget(title="Is parameter")
    private Boolean isParameter = Boolean.FALSE;
    @Widget(title="Is json")
    private Boolean isJson = Boolean.FALSE;
    @Widget(title="Target json")
    private Boolean isTargetJson = Boolean.FALSE;
    @Widget(title="Logic operator", selection="studio.filter.logic.operator")
    private Integer logicOp = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public ChartBuilder getChartBuilder() {
        return this.chartBuilder;
    }

    public void setChartBuilder(ChartBuilder chartBuilder) {
        this.chartBuilder = chartBuilder;
    }

    public MetaField getMetaField() {
        return this.metaField;
    }

    public void setMetaField(MetaField metaField) {
        this.metaField = metaField;
    }

    public MetaJsonField getMetaJsonField() {
        return this.metaJsonField;
    }

    public void setMetaJsonField(MetaJsonField metaJsonField) {
        this.metaJsonField = metaJsonField;
    }

    public WkfTransition getWkfTransition() {
        return this.wkfTransition;
    }

    public void setWkfTransition(WkfTransition wkfTransition) {
        this.wkfTransition = wkfTransition;
    }

    public Wkf getWkf() {
        return this.wkf;
    }

    public void setWkf(Wkf wkf) {
        this.wkf = wkf;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public ActionBuilder getActionBuilder() {
        return this.actionBuilder;
    }

    public void setActionBuilder(ActionBuilder actionBuilder) {
        this.actionBuilder = actionBuilder;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public void setTargetField(String targetField) {
        this.targetField = targetField;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getTargetTitle() {
        return this.targetTitle;
    }

    public void setTargetTitle(String targetTitle) {
        this.targetTitle = targetTitle;
    }

    public Boolean getIsParameter() {
        return this.isParameter == null ? Boolean.FALSE : this.isParameter;
    }

    public void setIsParameter(Boolean isParameter) {
        this.isParameter = isParameter;
    }

    public Boolean getIsJson() {
        return this.isJson == null ? Boolean.FALSE : this.isJson;
    }

    public void setIsJson(Boolean isJson) {
        this.isJson = isJson;
    }

    public Boolean getIsTargetJson() {
        return this.isTargetJson == null ? Boolean.FALSE : this.isTargetJson;
    }

    public void setIsTargetJson(Boolean isTargetJson) {
        this.isTargetJson = isTargetJson;
    }

    public Integer getLogicOp() {
        return this.logicOp == null ? 0 : this.logicOp;
    }

    public void setLogicOp(Integer logicOp) {
        this.logicOp = logicOp;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("moduleName", (Object)this.getModuleName()).add("operator", (Object)this.getOperator()).add("targetField", (Object)this.getTargetField()).add("targetType", (Object)this.getTargetType()).add("value", (Object)this.getValue()).add("defaultValue", (Object)this.getDefaultValue()).add("targetTitle", (Object)this.getTargetTitle()).add("isParameter", (Object)this.getIsParameter()).add("isJson", (Object)this.getIsJson()).add("isTargetJson", (Object)this.getIsTargetJson()).add("logicOp", (Object)this.getLogicOp()).omitNullValues().toString();
    }
}

