/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Role;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaField;
import com.axelor.studio.db.Wkf;
import com.axelor.studio.db.WkfTransition;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_WKF_NODE", uniqueConstraints={@UniqueConstraint(columnNames={"wkf", "sequence"})}, indexes={@Index(columnList="name"), @Index(columnList="wkf"), @Index(columnList="meta_field")})
public class WkfNode
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_WKF_NODE_SEQ")
    @SequenceGenerator(name="STUDIO_WKF_NODE_SEQ", sequenceName="STUDIO_WKF_NODE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Title")
    @NotNull
    private String title;
    @Widget(title="xmlId")
    private String xmlId;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Wkf wkf;
    @Widget(title="Field for 'My menu'")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField metaField;
    @Widget(title="Incoming")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<WkfTransition> incoming;
    @Widget(title="Outgoing")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<WkfTransition> outgoing;
    @Widget(title="ReadOnly for")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roleSet;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="Node type", selection="studio.node.type.select")
    private Integer nodeType = 1;
    @Widget(title="Actions")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderBy(value="sequence")
    private Set<MetaAction> metaActionSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public WkfNode() {
    }

    public WkfNode(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    public Wkf getWkf() {
        return this.wkf;
    }

    public void setWkf(Wkf wkf) {
        this.wkf = wkf;
    }

    public MetaField getMetaField() {
        return this.metaField;
    }

    public void setMetaField(MetaField metaField) {
        this.metaField = metaField;
    }

    public Set<WkfTransition> getIncoming() {
        return this.incoming;
    }

    public void setIncoming(Set<WkfTransition> incoming) {
        this.incoming = incoming;
    }

    public void addIncoming(WkfTransition item) {
        if (this.getIncoming() == null) {
            this.setIncoming(new HashSet<WkfTransition>());
        }
        this.getIncoming().add(item);
    }

    public void removeIncoming(WkfTransition item) {
        if (this.getIncoming() == null) {
            return;
        }
        this.getIncoming().remove((Object)item);
    }

    public void clearIncoming() {
        if (this.getIncoming() != null) {
            this.getIncoming().clear();
        }
    }

    public Set<WkfTransition> getOutgoing() {
        return this.outgoing;
    }

    public void setOutgoing(Set<WkfTransition> outgoing) {
        this.outgoing = outgoing;
    }

    public void addOutgoing(WkfTransition item) {
        if (this.getOutgoing() == null) {
            this.setOutgoing(new HashSet<WkfTransition>());
        }
        this.getOutgoing().add(item);
    }

    public void removeOutgoing(WkfTransition item) {
        if (this.getOutgoing() == null) {
            return;
        }
        this.getOutgoing().remove((Object)item);
    }

    public void clearOutgoing() {
        if (this.getOutgoing() != null) {
            this.getOutgoing().clear();
        }
    }

    public Set<Role> getRoleSet() {
        return this.roleSet;
    }

    public void setRoleSet(Set<Role> roleSet) {
        this.roleSet = roleSet;
    }

    public void addRoleSetItem(Role item) {
        if (this.getRoleSet() == null) {
            this.setRoleSet(new HashSet<Role>());
        }
        this.getRoleSet().add(item);
    }

    public void removeRoleSetItem(Role item) {
        if (this.getRoleSet() == null) {
            return;
        }
        this.getRoleSet().remove(item);
    }

    public void clearRoleSet() {
        if (this.getRoleSet() != null) {
            this.getRoleSet().clear();
        }
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Integer getNodeType() {
        return this.nodeType == null ? 0 : this.nodeType;
    }

    public void setNodeType(Integer nodeType) {
        this.nodeType = nodeType;
    }

    public Set<MetaAction> getMetaActionSet() {
        return this.metaActionSet;
    }

    public void setMetaActionSet(Set<MetaAction> metaActionSet) {
        this.metaActionSet = metaActionSet;
    }

    public void addMetaActionSetItem(MetaAction item) {
        if (this.getMetaActionSet() == null) {
            this.setMetaActionSet(new HashSet<MetaAction>());
        }
        this.getMetaActionSet().add(item);
    }

    public void removeMetaActionSetItem(MetaAction item) {
        if (this.getMetaActionSet() == null) {
            return;
        }
        this.getMetaActionSet().remove((Object)item);
    }

    public void clearMetaActionSet() {
        if (this.getMetaActionSet() != null) {
            this.getMetaActionSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WkfNode)) {
            return false;
        }
        WkfNode other = (WkfNode)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("title", (Object)this.getTitle()).add("xmlId", (Object)this.getXmlId()).add("sequence", (Object)this.getSequence()).add("nodeType", (Object)this.getNodeType()).omitNullValues().toString();
    }
}

