/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.studio.db.WkfTracking;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_WKF_TRACKING_TOTAL", indexes={@Index(columnList="wkf_tracking")})
public class WkfTrackingTotal
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_WKF_TRACKING_TOTAL_SEQ")
    @SequenceGenerator(name="STUDIO_WKF_TRACKING_TOTAL_SEQ", sequenceName="STUDIO_WKF_TRACKING_TOTAL_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WkfTracking wkfTracking;
    @Widget(title="Status")
    @NotNull
    private String status;
    @Widget(title="Nb of passes")
    private Integer totalCount = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public WkfTracking getWkfTracking() {
        return this.wkfTracking;
    }

    public void setWkfTracking(WkfTracking wkfTracking) {
        this.wkfTracking = wkfTracking;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getTotalCount() {
        return this.totalCount == null ? 0 : this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WkfTrackingTotal)) {
            return false;
        }
        WkfTrackingTotal other = (WkfTrackingTotal)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("status", (Object)this.getStatus()).add("totalCount", (Object)this.getTotalCount()).omitNullValues().toString();
    }
}

