/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db.repo;

import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaMenu;
import com.axelor.studio.db.ActionBuilder;
import com.axelor.studio.db.MenuBuilder;
import com.axelor.studio.db.repo.ActionBuilderRepo;
import com.axelor.studio.db.repo.MenuBuilderRepository;
import com.axelor.studio.service.StudioMetaService;
import com.axelor.studio.service.builder.MenuBuilderService;
import com.google.inject.Inject;

public class MenuBuilderRepo
extends MenuBuilderRepository {
    @Inject
    private MenuBuilderService menuBuilderService;
    @Inject
    private ActionBuilderRepo actionBuilderRepo;
    @Inject
    private StudioMetaService metaService;

    public MenuBuilder save(MenuBuilder menuBuilder) {
        if (menuBuilder.getName() == null) {
            menuBuilder.setName("studio-menu-" + menuBuilder.getId());
        }
        if (menuBuilder.getActionBuilder() != null) {
            menuBuilder.getActionBuilder().setMenuAction(true);
        }
        menuBuilder = (MenuBuilder)((Object)super.save((Model)((Object)menuBuilder)));
        menuBuilder.setMetaMenu(this.menuBuilderService.build(menuBuilder));
        return menuBuilder;
    }

    public MenuBuilder copy(MenuBuilder menuBuilder, boolean deep) {
        ActionBuilder actionBuilder = menuBuilder.getActionBuilder();
        menuBuilder.setActionBuilder(null);
        menuBuilder = (MenuBuilder)((Object)super.copy((Model)((Object)menuBuilder), deep));
        if (actionBuilder != null) {
            menuBuilder.setActionBuilder((ActionBuilder)((Object)this.actionBuilderRepo.copy((Model)((Object)actionBuilder), deep)));
        }
        return menuBuilder;
    }

    public void remove(MenuBuilder menuBuilder) {
        MetaMenu metaMenu = menuBuilder.getMetaMenu();
        menuBuilder.setMetaMenu(null);
        this.metaService.removeMetaMenu(metaMenu);
        ActionBuilder actionBuilder = menuBuilder.getActionBuilder();
        menuBuilder.setActionBuilder(null);
        if (actionBuilder != null) {
            try {
                this.actionBuilderRepo.remove(actionBuilder);
            }
            catch (RuntimeException e) {
                TraceBackService.trace((Throwable)e);
                throw e;
            }
        }
        MetaStore.clear();
        super.remove((Model)((Object)menuBuilder));
    }
}

