/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.builder;

import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.db.repo.TemplateRepository;
import com.axelor.apps.message.service.MessageService;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.CallMethod;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaJsonModel;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaJsonModelRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionResponse;
import com.axelor.studio.db.ActionBuilder;
import com.axelor.studio.service.StudioMetaService;
import com.google.inject.Inject;
import java.io.IOException;
import javax.mail.MessagingException;

public class ActionEmailBuilderService {
    @Inject
    private MetaModelRepository metaModelRepo;
    @Inject
    private MetaJsonModelRepository metaJsonModelRepo;
    @Inject
    private StudioMetaService studioMetaService;
    @Inject
    private TemplateRepository templateRepo;
    @Inject
    private TemplateMessageService templateMessageService;
    @Inject
    private MessageService messageService;

    public MetaAction build(ActionBuilder builder) {
        String name = builder.getName();
        Model model = builder.getIsJson() != false ? this.metaJsonModelRepo.all().filter("self.name = ?", new Object[]{builder.getModel()}).fetchOne() : this.metaModelRepo.all().filter("self.fullName = ?", new Object[]{builder.getModel()}).fetchOne();
        int sendOption = builder.getEmailSendOptionSelect();
        Template template = builder.getEmailTemplate();
        String xml = "<action-method name=\"" + name + "\" id=\"studio-" + name + "\">\n\t<call class=\"com.axelor.studio.service.builder.ActionEmailBuilderService\" method=\"sendEmail(id, '" + (builder.getIsJson() != false ? ((MetaJsonModel)((Object)model)).getName() : ((MetaModel)model).getFullName()) + "', '" + (builder.getIsJson() != false ? ((MetaJsonModel)((Object)model)).getName() : ((MetaModel)model).getName()) + "', '" + template.getId() + "', '" + sendOption + "')\" if=\"id != null\"/>\n</action-method>";
        return this.studioMetaService.updateMetaAction(name, "action-method", xml, null);
    }

    @CallMethod
    public ActionResponse sendEmail(Long objectId, String model, String tag, Long templateId, int sendOption) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxelorException, IOException, MessagingException {
        Template template = (Template)this.templateRepo.find(templateId);
        Message message = this.templateMessageService.generateMessage(objectId, model, tag, template);
        ActionResponse response = new ActionResponse();
        if (sendOption == 0) {
            this.messageService.sendByEmail(message);
        } else {
            response.setView(ActionView.define((String)I18n.get((String)"Create message")).model(Message.class.getName()).add("form", "message-form").param("forceEdit", "true").context("_showRecord", (Object)message.getId().toString()).map());
        }
        return response;
    }
}

