/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.filter;

import com.axelor.meta.db.MetaJsonField;
import com.axelor.studio.db.Filter;
import com.axelor.studio.service.filter.FilterCommonService;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterGroovyService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private FilterCommonService filterCommonService;

    public String getGroovyFilters(List<Filter> conditions, String parentField) {
        String condition = null;
        if (conditions == null) {
            return null;
        }
        for (Filter filter : conditions) {
            String activeFilter = this.createGroovyFilter(filter, parentField);
            this.log.debug("Active filter: {}", (Object)filter);
            if (condition == null) {
                condition = "(" + activeFilter;
                continue;
            }
            if (filter.getLogicOp() > 0) {
                condition = condition + ") || (" + activeFilter;
                continue;
            }
            condition = condition + " && " + activeFilter;
        }
        if (condition == null) {
            return null;
        }
        return condition + ")";
    }

    private String createGroovyFilter(Filter filter, String parentField) {
        MetaJsonField metaJsonField = filter.getMetaJsonField();
        String field = parentField != null ? parentField + "." + metaJsonField.getName() : metaJsonField.getName();
        String targetField = parentField != null ? parentField + "." + filter.getTargetField() : filter.getTargetField();
        String value = this.processValue(filter);
        String operator = filter.getOperator();
        if (targetField != null) {
            targetField = targetField.replace(".", "?.");
            if (metaJsonField.getType().equals("many-to-one") || metaJsonField.getType().equals("json-many-to-one")) {
                field = targetField;
            } else if (metaJsonField.getType().equals("many-to-many") && !operator.contains("empty")) {
                targetField = targetField.replace(field + "?.", "it?.");
                String condition = this.getConditionExpr(operator, targetField, value);
                return field + ".findAll{it->" + condition + "}.size() > 0";
            }
        }
        return this.getConditionExpr(operator, field, value);
    }

    private String processValue(Filter filter) {
        String value = filter.getValue();
        if (value == null) {
            return value;
        }
        value = value.replace("$$", "_parent.");
        return this.filterCommonService.getTagValue(value, false);
    }

    private String getConditionExpr(String operator, String field, String value) {
        switch (operator) {
            case "=": {
                return field + " == " + value;
            }
            case "isNull": {
                return field + " == null";
            }
            case "notNull": {
                return field + " != null";
            }
            case "empty": {
                return field + ".empty";
            }
            case "notEmpty": {
                return "!" + field + ".empty";
            }
            case "isTrue": {
                return field;
            }
            case "isFalse": {
                return "!" + field;
            }
        }
        return field + " " + operator + " " + value;
    }
}

