/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.wkf;

import com.axelor.auth.db.Permission;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.repo.PermissionRepository;
import com.axelor.db.Model;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.MetaSelect;
import com.axelor.meta.db.MetaSelectItem;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.meta.db.repo.MetaSelectRepository;
import com.axelor.studio.db.WkfNode;
import com.axelor.studio.service.wkf.WkfService;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WkfNodeService {
    private WkfService wkfService;
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<String[]> nodeActions;
    @Inject
    private MetaModelRepository metaModelRepo;
    @Inject
    private PermissionRepository permissionRepo;
    @Inject
    private MetaSelectRepository metaSelectRepo;

    @Inject
    protected WkfNodeService(WkfService wkfService) {
        this.wkfService = wkfService;
    }

    protected List<String[]> process() {
        MetaJsonField statusField = this.wkfService.workflow.getStatusField();
        MetaSelect metaSelect = this.addMetaSelect(statusField);
        this.nodeActions = new ArrayList<String[]>();
        String defaultValue = this.processNodes(metaSelect, statusField);
        statusField.setDefaultValue(defaultValue);
        return this.nodeActions;
    }

    @Transactional
    public MetaSelect addMetaSelect(MetaJsonField statusField) {
        String selectName = this.wkfService.getSelectName();
        MetaSelect metaSelect = this.metaSelectRepo.findByName(selectName);
        if (metaSelect == null) {
            metaSelect = new MetaSelect(selectName);
            metaSelect.setIsCustom(true);
            metaSelect.setAppBuilder(this.wkfService.workflow.getAppBuilder());
            metaSelect = (MetaSelect)((Object)this.metaSelectRepo.save((Model)((Object)metaSelect)));
        }
        if (metaSelect.getItems() == null) {
            metaSelect.setItems(new ArrayList<MetaSelectItem>());
        }
        metaSelect.clearItems();
        return metaSelect;
    }

    private MetaSelect removeOldOptions(MetaSelect metaSelect, List<WkfNode> nodeList) {
        this.log.debug("Cleaning meta select: {}", (Object)metaSelect.getName());
        ArrayList<MetaSelectItem> itemsToRemove = new ArrayList<MetaSelectItem>();
        Iterator<MetaSelectItem> itemIter = metaSelect.getItems().iterator();
        while (itemIter.hasNext()) {
            MetaSelectItem item = itemIter.next();
            boolean found = false;
            for (WkfNode node : nodeList) {
                if (!item.getValue().equals(node.getSequence().toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            itemsToRemove.add(item);
            itemIter.remove();
        }
        return metaSelect;
    }

    private String processNodes(MetaSelect metaSelect, MetaJsonField statusField) {
        List<WkfNode> nodeList = this.wkfService.workflow.getNodes();
        String defaultValue = null;
        this.removeOldOptions(metaSelect, nodeList);
        Collections.sort(nodeList, (node1, node2) -> node1.getSequence().compareTo(node2.getSequence()));
        for (WkfNode node : nodeList) {
            this.log.debug("Procesing node: {}", (Object)node.getName());
            String option = node.getSequence().toString();
            MetaSelectItem metaSelectItem = this.getMetaSelectItem(metaSelect, option);
            if (metaSelectItem == null) {
                metaSelectItem = new MetaSelectItem();
                metaSelectItem.setValue(option);
                metaSelect.addItem(metaSelectItem);
            }
            metaSelectItem.setTitle(node.getTitle());
            metaSelectItem.setOrder(node.getSequence());
            if (defaultValue == null) {
                defaultValue = metaSelectItem.getValue();
                this.log.debug("Default value set: {}", (Object)defaultValue);
            }
            ArrayList<String[]> actions = new ArrayList<String[]>();
            if (node.getMetaActionSet() != null) {
                Stream<MetaAction> actionStream = node.getMetaActionSet().stream().sorted(Comparator.comparing(MetaAction::getSequence));
                actionStream.forEach(metaAction -> actions.add(new String[]{metaAction.getName()}));
            }
            if (actions.isEmpty()) continue;
            String name = this.getActionName(node.getName());
            String value = node.getSequence().toString();
            if (statusField.getType().equals("string")) {
                value = "'" + value + "'";
            }
            String condition = statusField.getName() + " == " + value;
            if (!this.wkfService.workflow.getIsJson().booleanValue()) {
                condition = "$" + this.wkfService.workflow.getJsonField() + "." + condition;
            }
            this.nodeActions.add(new String[]{name, condition});
            this.wkfService.updateActionGroup(name, actions);
        }
        return defaultValue;
    }

    public String getActionName(String node) {
        String name = this.wkfService.inflector.simplify(node);
        name = name.toLowerCase().replace(" ", "-");
        name = "action-group-" + this.wkfService.wkfId + "-" + name;
        return name;
    }

    @Transactional
    public MetaModel saveModel(MetaModel metaModel) {
        return (MetaModel)this.metaModelRepo.save((Model)metaModel);
    }

    private MetaSelectItem getMetaSelectItem(MetaSelect metaSelect, String option) {
        for (MetaSelectItem selectItem : metaSelect.getItems()) {
            if (!selectItem.getValue().equals(option)) continue;
            return selectItem;
        }
        return null;
    }

    @Transactional
    public void clearOldPermissions(String name) {
        Permission permission = this.permissionRepo.findByName(name);
        if (permission != null) {
            List oldRoleList = this.wkfService.roleRepo.all().filter("self.permissions.id = ?1", new Object[]{permission.getId()}).fetch();
            for (Role role : oldRoleList) {
                role.removePermission(permission);
                this.wkfService.roleRepo.save((Model)role);
            }
        }
    }
}

