/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.wkf;

import com.axelor.auth.db.repo.RoleRepository;
import com.axelor.common.Inflector;
import com.axelor.db.Model;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaJsonModel;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.meta.db.MetaSelect;
import com.axelor.meta.db.repo.MetaJsonFieldRepository;
import com.axelor.meta.db.repo.MetaJsonModelRepository;
import com.axelor.meta.db.repo.MetaSelectRepository;
import com.axelor.meta.loader.XMLViews;
import com.axelor.meta.schema.actions.ActionGroup;
import com.axelor.meta.schema.actions.ActionMethod;
import com.axelor.studio.db.Wkf;
import com.axelor.studio.db.WkfNode;
import com.axelor.studio.db.repo.WkfRepository;
import com.axelor.studio.service.StudioMetaService;
import com.axelor.studio.service.filter.FilterGroovyService;
import com.axelor.studio.service.wkf.WkfNodeService;
import com.axelor.studio.service.wkf.WkfTransitionService;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WkfService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Wkf workflow = null;
    protected String wkfId = null;
    protected Inflector inflector;
    protected Integer wkfSequence = 0;
    protected String applyCondition = null;
    protected String trackingAction = null;
    @Inject
    protected RoleRepository roleRepo;
    @Inject
    private WkfNodeService nodeService;
    @Inject
    private WkfTransitionService transitionService;
    @Inject
    private StudioMetaService metaService;
    @Inject
    private MetaJsonFieldRepository jsonFieldRepo;
    @Inject
    private MetaJsonModelRepository jsonModelRepo;
    @Inject
    private MetaSelectRepository metaSelectRepo;
    @Inject
    private FilterGroovyService filterGroovyService;
    @Inject
    private WkfRepository wkfRepository;

    public String process(Wkf wkf) {
        try {
            this.initService(wkf);
            this.createTrackingAction();
            this.setWkfSequence();
            this.setView();
            List<String[]> actions = this.nodeService.process();
            actions.addAll(this.transitionService.process());
            actions.add(new String[]{"save"});
            actions.add(new String[]{this.trackingAction});
            this.updateActionGroup("action-group-" + this.wkfId, actions);
            MetaStore.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
        return null;
    }

    private void initService(Wkf wkf) {
        this.workflow = wkf;
        this.inflector = Inflector.getInstance();
        this.wkfId = "wkf" + wkf.getId().toString();
        this.trackingAction = "action-method-wkf-track-" + this.wkfId;
    }

    private void setView() {
        MetaJsonField status = this.workflow.getStatusField();
        this.applyCondition = this.filterGroovyService.getGroovyFilters(this.workflow.getConditions(), this.workflow.getJsonField());
        MetaJsonField panel = this.getJsonField(this.wkfId + "Panel", "panel");
        panel.setSequence(this.wkfSequence - 49);
        panel.setVisibleInGrid(false);
        panel.setIsWkf(true);
        panel.setWidgetAttrs("{\"colSpan\": \"12\"}");
        this.saveJsonField(panel);
        status.setSequence(this.wkfSequence - 48);
        status.setSelection(this.getSelectName());
        status.setWidget(null);
        status.setIsWkf(true);
        status.setReadonly(true);
        status.setShowIf(this.applyCondition);
        status.setWidgetAttrs("{\"colSpan\": \"10\"}");
        if (this.workflow.getDisplayTypeSelect() == 0) {
            status.setWidget("NavSelect");
        }
        this.saveJsonField(this.workflow.getStatusField());
        MetaJsonField trackFlow = this.getJsonField(this.wkfId + "TrackFlow", "button");
        trackFlow.setSequence(this.wkfSequence - 47);
        trackFlow.setTitle("Track flow");
        trackFlow.setWidgetAttrs("{\"colSpan\": \"2\"}");
        trackFlow.setOnClick("action-wkf-open-wkf-tracking");
        trackFlow.setIsWkf(true);
        trackFlow.setVisibleInGrid(false);
        trackFlow.setHidden(this.workflow.getIsTrackFlow() == false);
        this.saveJsonField(trackFlow);
        MetaJsonField wkfEnd = this.getJsonField(this.wkfId + "Separator", "separator");
        wkfEnd.setSequence(this.wkfSequence);
        wkfEnd.setVisibleInGrid(false);
        wkfEnd.setIsWkf(true);
        wkfEnd.setWidgetAttrs("{\"colSpan\": \"12\"}");
        this.saveJsonField(panel);
    }

    @Transactional
    public void clearOldStatusField() {
        MetaJsonField field = null;
        field = this.workflow.getIsJson() != false ? (MetaJsonField)((Object)this.jsonFieldRepo.all().filter("self.isWkf = true and self.jsonModel.name = :workflowModel and self.type in ('string','integer')").bind("workflowModel", (Object)this.workflow.getModel()).fetchOne()) : (MetaJsonField)((Object)this.jsonFieldRepo.all().filter("self.isWkf = true and self.model = :workflowModel and self.modelField = :workflowJsonField and self.type in ('string','integer')").bind("workflowModel", (Object)this.workflow.getModel()).bind("workflowJsonField", (Object)this.workflow.getJsonField()).fetchOne());
        if (field != null) {
            if (field.getSelection() != null) {
                this.log.debug("Cleaning old status field: {}", (Object)field);
                MetaSelect oldSelect = this.metaSelectRepo.findByName(field.getSelection());
                if (oldSelect != null) {
                    this.log.debug("Removing old wkf selection: {}", (Object)oldSelect);
                    this.metaSelectRepo.remove((Model)((Object)oldSelect));
                }
            }
            field.setIsWkf(false);
            field.setSelection(null);
            field.setSequence(0);
            field.setReadonly(false);
            this.jsonFieldRepo.save((Model)((Object)field));
        }
    }

    public String getSelectName() {
        if (this.workflow != null) {
            MetaJsonField wkfField = this.workflow.getStatusField();
            String selectName = "wkf." + this.inflector.dasherize(this.workflow.getName()).replace("_", ".");
            selectName = selectName + "." + this.inflector.dasherize(wkfField.getName()).replace("_", ".") + ".select";
            return selectName;
        }
        return null;
    }

    protected ActionGroup updateActionGroup(String name, List<String[]> actions) {
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.setName(name);
        ArrayList<ActionGroup.ActionItem> actionItems = new ArrayList<ActionGroup.ActionItem>();
        for (String[] action : actions) {
            ActionGroup.ActionItem actionItem = new ActionGroup.ActionItem();
            actionItem.setName(action[0]);
            if (action.length > 1) {
                actionItem.setCondition(action[1]);
            }
            actionItems.add(actionItem);
        }
        actionGroup.setActions(actionItems);
        String xml = XMLViews.toXml((Object)actionGroup, (boolean)true);
        this.metaService.updateMetaAction(name, "action-group", xml, null);
        return actionGroup;
    }

    public MetaJsonField getJsonField(String name, String type) {
        MetaJsonField field = null;
        if (this.workflow.getIsJson().booleanValue()) {
            field = (MetaJsonField)((Object)this.jsonFieldRepo.all().filter("self.isWkf = true and self.jsonModel.name = ?1 and self.name = ?2 and self.type = ?3", new Object[]{this.workflow.getModel(), name, type}).fetchOne());
            if (field == null) {
                field = new MetaJsonField();
                field.setModel(MetaJsonRecord.class.getName());
                field.setModelField("attrs");
                field.setJsonModel(this.jsonModelRepo.findByName(this.workflow.getModel()));
            }
        } else {
            field = (MetaJsonField)((Object)this.jsonFieldRepo.all().filter("self.isWkf = true and self.model = :workflowModel and self.modelField = :workflowJsonField and self.name = :name and self.type = :type").bind("workflowModel", (Object)this.workflow.getModel()).bind("workflowJsonField", (Object)this.workflow.getJsonField()).bind("name", (Object)name).bind("type", (Object)type).fetchOne());
            this.log.debug("Searching json field with model: {}, field: {}, name: {}, type: {}", new Object[]{this.workflow.getModel(), this.workflow.getJsonField(), name, type});
            if (field == null) {
                field = new MetaJsonField();
                field.setModel(this.workflow.getModel());
                field.setModelField(this.workflow.getJsonField());
                field.setName(name);
            }
        }
        field.setType(type);
        field.setName(name);
        field.setIsWkf(true);
        field.setShowIf(this.applyCondition);
        return this.saveJsonField(field);
    }

    @Transactional
    public MetaJsonField saveJsonField(MetaJsonField jsonField) {
        return (MetaJsonField)((Object)this.jsonFieldRepo.save((Model)((Object)jsonField)));
    }

    @Transactional
    public void clearWkf(Wkf wkf) {
        this.initService(wkf);
        String actions = "action-" + this.wkfId + ",action-group" + this.wkfId;
        actions = this.clearFields(wkf, actions);
        StringBuilder builder = new StringBuilder(actions);
        for (WkfNode node : wkf.getNodes()) {
            if (node.getMetaActionSet().isEmpty()) continue;
            builder.append("," + this.nodeService.getActionName(node.getName()));
        }
        builder.append(this.trackingAction);
        actions = builder.toString();
        this.metaService.removeMetaActions(actions);
        String select = this.getSelectName();
        MetaSelect metaSelect = this.metaSelectRepo.findByName(select);
        if (metaSelect != null) {
            this.metaSelectRepo.remove((Model)((Object)metaSelect));
        }
        MetaJsonField status = wkf.getStatusField();
        status.setWidget(null);
        status.setSelection(null);
        status.setWidgetAttrs(null);
        this.saveJsonField(status);
    }

    private String clearFields(Wkf wkf, String actions) {
        List<MetaJsonField> fields = this.getFields(wkf);
        StringBuilder builder = new StringBuilder(actions);
        for (MetaJsonField field : fields) {
            if (!field.getIsWkf().booleanValue() || field.equals((Object)wkf.getStatusField())) continue;
            if (field.getOnClick() != null) {
                builder.append("," + field.getOnClick());
            }
            this.jsonFieldRepo.remove((Model)((Object)field));
        }
        return builder.toString();
    }

    private List<MetaJsonField> getFields(Wkf wkf) {
        String query = "self.isWkf = true and self.name LIKE '" + this.wkfId + "%' and ";
        List fields = wkf.getIsJson() != false ? this.jsonFieldRepo.all().filter(query + "self.jsonModel.name = ?1", new Object[]{wkf.getModel()}).fetch() : this.jsonFieldRepo.all().filter(query + "self.model = ?1 and self.modelField = ?2", new Object[]{wkf.getModel(), wkf.getJsonField()}).fetch();
        return fields;
    }

    @Transactional
    public String clearOldButtons(List<String> skipList) {
        this.log.debug("Cleaning old buttons. Skip list: {}", skipList);
        if (skipList.isEmpty()) {
            return null;
        }
        skipList.add(this.wkfId + "TrackFlow");
        ArrayList<String> actions = new ArrayList<String>();
        List fields = null;
        fields = this.workflow.getIsJson() != false ? this.jsonFieldRepo.all().filter("self.type = 'button' and self.jsonModel.name = ?1 and self.isWkf = true and self.name not in (?2) and self.name LIKE ?3", new Object[]{this.workflow.getModel(), skipList, this.wkfId + "%"}).fetch() : this.jsonFieldRepo.all().filter("self.type = 'button' and self.model = ?1 and self.modelField = ?2 and self.name not in (?3) and self.name LIKE ?4", new Object[]{this.workflow.getModel(), this.workflow.getJsonField(), skipList, this.wkfId + "%"}).fetch();
        this.log.debug("Total Buttons to remove: {}", (Object)fields.size());
        Iterator buttons = fields.iterator();
        MetaJsonModel jsonModel = this.jsonModelRepo.findByName(this.workflow.getModel());
        while (buttons.hasNext()) {
            MetaJsonField button = (MetaJsonField)((Object)buttons.next());
            String onClick = button.getOnClick();
            this.log.debug("Removing button : {}, onClick: {}", (Object)button.getName(), (Object)onClick);
            if (onClick != null) {
                for (String action : onClick.split(",")) {
                    if (action.equals("action-group" + this.wkfId)) continue;
                    actions.add(action);
                }
            }
            buttons.remove();
            jsonModel.getFields().remove((Object)button);
            this.jsonFieldRepo.remove((Model)((Object)button));
        }
        return Joiner.on((String)",").join(actions);
    }

    public void clearNodes(Collection<WkfNode> nodes) {
        ArrayList<String> actions = new ArrayList<String>();
        for (WkfNode node : nodes) {
            if (this.workflow == null) {
                this.workflow = node.getWkf();
                this.inflector = Inflector.getInstance();
            }
            if (node.getMetaActionSet().isEmpty()) continue;
            actions.add(this.nodeService.getActionName(node.getName()));
        }
        this.metaService.removeMetaActions(Joiner.on((String)",").join(actions));
    }

    @Transactional
    public void createTrackingAction() {
        ActionMethod actionMethod = new ActionMethod();
        actionMethod.setName(this.trackingAction);
        ActionMethod.Call call = new ActionMethod.Call();
        call.setMethod("track(" + this.workflow.getId() + ",__self__)");
        call.setController("com.axelor.studio.service.wkf.WkfTrackingService");
        actionMethod.setCall(call);
        String xml = XMLViews.toXml((Object)actionMethod, (boolean)true);
        this.metaService.updateMetaAction(this.trackingAction, "action-method", xml, null);
    }

    @Transactional
    public void setWkfSequence() {
        Wkf wkf = (Wkf)((Object)this.wkfRepository.all().filter("self.model = ?1", new Object[]{this.workflow.getModel()}).order("wkfSequence").fetchOne());
        if (wkf.getId() != this.workflow.getId() && this.workflow.getWkfSequence() == 0) {
            this.workflow.setWkfSequence(wkf.getWkfSequence() - 50);
            this.wkfRepository.save((Model)((Object)this.workflow));
        } else if (this.workflow.getWkfSequence() == 0) {
            this.workflow.setWkfSequence(-1);
            this.wkfRepository.save((Model)((Object)this.workflow));
        }
        this.wkfSequence = this.workflow.getWkfSequence();
    }
}

