/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.wkf;

import com.axelor.auth.db.Role;
import com.axelor.db.Model;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaPermission;
import com.axelor.meta.db.MetaPermissionRule;
import com.axelor.meta.db.repo.MetaPermissionRepository;
import com.axelor.meta.loader.XMLViews;
import com.axelor.meta.schema.actions.ActionAttrs;
import com.axelor.meta.schema.actions.ActionValidate;
import com.axelor.studio.db.Filter;
import com.axelor.studio.db.WkfTransition;
import com.axelor.studio.service.StudioMetaService;
import com.axelor.studio.service.filter.FilterGroovyService;
import com.axelor.studio.service.wkf.WkfService;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WkfTransitionService {
    private WkfService wkfService;
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<String> wkfButtonNames;
    @Inject
    private MetaPermissionRepository metaPermissionRepo;
    @Inject
    private FilterGroovyService filterGroovyService;
    @Inject
    private StudioMetaService metaService;

    @Inject
    protected WkfTransitionService(WkfService wkfService) {
        this.wkfService = wkfService;
    }

    protected List<String[]> process() {
        this.log.debug("Processing transitions");
        ArrayList<String[]> actions = new ArrayList<String[]>();
        String action = "action-" + this.wkfService.wkfId;
        this.wkfButtonNames = new ArrayList<String>();
        List<ActionAttrs.Attribute> fields = this.proccessTransitions();
        if (!fields.isEmpty()) {
            String xml = this.getActionXML(action, fields);
            this.metaService.updateMetaAction(action, "action-attrs", xml, null);
            actions.add(new String[]{action});
        } else {
            this.metaService.removeMetaActions(action);
        }
        String actionsToRemove = this.wkfService.clearOldButtons(this.wkfButtonNames);
        this.metaService.removeMetaActions(actionsToRemove);
        return actions;
    }

    private List<ActionAttrs.Attribute> proccessTransitions() {
        ArrayList<ActionAttrs.Attribute> fields = new ArrayList<ActionAttrs.Attribute>();
        Integer buttonSeq = this.wkfService.wkfSequence - 46;
        for (WkfTransition transition : this.wkfService.workflow.getTransitions()) {
            MetaJsonField status = this.wkfService.workflow.getStatusField();
            String condition = status.getName() + " == " + this.getTyped(transition.getSource().getSequence(), status);
            this.log.debug("Processing transition : {}, isButton: {}", (Object)transition.getName(), (Object)transition.getIsButton());
            String filters = this.getFilters(transition.getConditions());
            if (filters != null) {
                condition = condition + " && (" + filters + ")";
            }
            if (this.wkfService.applyCondition != null) {
                condition = condition + " && " + this.wkfService.applyCondition;
            }
            if (transition.getIsButton().booleanValue()) {
                Integer n = buttonSeq;
                Integer n2 = buttonSeq = Integer.valueOf(buttonSeq + 1);
                this.addButton(transition, condition, buttonSeq);
                continue;
            }
            this.log.debug("Conditions : {}", transition.getConditions());
            ActionAttrs.Attribute attrs = new ActionAttrs.Attribute();
            attrs.setName("value");
            attrs.setFieldName(status.getName());
            attrs.setCondition(condition);
            attrs.setExpression("eval:" + this.getTyped(transition.getTarget().getSequence(), status));
            fields.add(attrs);
        }
        return fields;
    }

    private String getFilters(List<Filter> filterList) {
        String jsonField;
        String string = jsonField = this.wkfService.workflow.getIsJson() != false ? null : "$" + this.wkfService.workflow.getJsonField();
        if (jsonField != null && jsonField.equals("$attrs")) {
            jsonField = null;
        }
        String filters = this.filterGroovyService.getGroovyFilters(filterList, jsonField);
        this.log.debug("Filters : {}", (Object)filters);
        return filters;
    }

    private String getTyped(Integer value, MetaJsonField status) {
        String typeName = status.getType();
        if (typeName.equals("integer")) {
            return value.toString();
        }
        return "'" + value + "'";
    }

    private void addButton(WkfTransition transition, String condition, Integer sequence) {
        String title = transition.getButtonTitle();
        String name = this.wkfService.wkfId + "Transition" + transition.getId();
        if (name.equals("save") || name.equals("cancel") || name.equals("back")) {
            name = "wkf" + name;
        }
        this.wkfButtonNames.add(name);
        MetaJsonField button = this.wkfService.getJsonField(name, "button");
        button.setTitle(title);
        button.setShowIf(condition);
        button.setSequence(sequence);
        button.setVisibleInGrid(false);
        button.setIsWkf(true);
        button.setWidgetAttrs("{\"colSpan\": \"" + transition.getColSpan() + "\"}");
        button.setOnClick(this.addButtonActions(transition, name));
        if (transition.getRoleSet() != null) {
            HashSet<Role> buttonRoles = new HashSet<Role>();
            buttonRoles.addAll(transition.getRoleSet());
            button.setRoles(buttonRoles);
        }
        this.log.debug("Adding button : {}", (Object)button.getName());
        this.wkfService.saveJsonField(button);
    }

    private String addButtonActions(WkfTransition transition, String buttonName) {
        String actionName = buttonName.toLowerCase().replace(" ", "-");
        actionName = "action-" + this.wkfService.wkfId + "-" + actionName;
        ArrayList<String> actions = new ArrayList<String>();
        String xml = "";
        Integer alterType = transition.getAlertTypeSelect();
        String alertMsg = transition.getAlertMsg();
        if (alterType > 0 && alertMsg != null) {
            String type = "alert";
            if (alterType == 2) {
                type = "info";
            }
            String alertAction = actionName + "-alert";
            xml = this.getActionValidateXML(alertAction, type, alertMsg, transition.getConditions());
            this.metaService.updateMetaAction(alertAction, "action-validate", xml, null);
            actions.add(alertAction);
        }
        ArrayList<ActionAttrs.Attribute> attrs = new ArrayList<ActionAttrs.Attribute>();
        ActionAttrs.Attribute attr = new ActionAttrs.Attribute();
        MetaJsonField wkfField = this.wkfService.workflow.getStatusField();
        attr.setName("value");
        attr.setFieldName(wkfField.getName());
        attr.setExpression("eval:" + this.getTyped(transition.getTarget().getSequence(), wkfField));
        attrs.add(attr);
        actions.add(actionName);
        xml = this.getActionXML(actionName, attrs);
        this.metaService.updateMetaAction(actionName, "action-record", xml, null);
        String successMsg = transition.getSuccessMsg();
        if (successMsg != null) {
            String sucessAction = actionName + "-success";
            xml = this.getActionValidateXML(sucessAction, "notify", successMsg, null);
            this.metaService.updateMetaAction(sucessAction, "action-validate", xml, null);
            actions.add(sucessAction);
        }
        actions.add("save");
        actions.add("action-group-" + this.wkfService.wkfId);
        return Joiner.on((String)",").join(actions);
    }

    private String getActionXML(String name, List<ActionAttrs.Attribute> attrs) {
        this.log.debug("Creating action attrs: {}", (Object)name);
        ActionAttrs action = new ActionAttrs();
        action.setName(name);
        action.setAttributes(attrs);
        return XMLViews.toXml((Object)action, (boolean)true);
    }

    private String getActionValidateXML(String name, String type, String message, List<Filter> conditions) {
        ActionValidate actionValidate = new ActionValidate();
        actionValidate.setName(name);
        ArrayList<Object> validators = new ArrayList<Object>();
        String condition = this.getFilters(conditions);
        switch (type) {
            case "notify": {
                ActionValidate.Notify notify = new ActionValidate.Notify();
                notify.setMessage(message);
                notify.setCondition(condition);
                validators.add(notify);
                break;
            }
            case "info": {
                ActionValidate.Info info = new ActionValidate.Info();
                info.setMessage(message);
                info.setCondition(condition);
                validators.add(info);
                break;
            }
            default: {
                ActionValidate.Alert alert = new ActionValidate.Alert();
                alert.setMessage(message);
                alert.setCondition(condition);
                validators.add(alert);
            }
        }
        actionValidate.setValidators(validators);
        return XMLViews.toXml((Object)actionValidate, (boolean)true);
    }

    @Transactional
    public void addButtonPermissions(String name, String buttonName, Set<Role> roles) {
        if (roles == null || roles.isEmpty()) {
            return;
        }
        MetaPermission permission = this.metaPermissionRepo.findByName(name);
        if (permission == null) {
            permission = new MetaPermission(name);
            permission.setObject(this.wkfService.workflow.getModel());
            MetaPermissionRule rule = new MetaPermissionRule();
            rule.setCanRead(Boolean.valueOf(false));
            rule.setField(buttonName);
            permission.addRule(rule);
            permission = (MetaPermission)this.metaPermissionRepo.save((Model)permission);
        }
        for (Role role : roles) {
            role.addMetaPermission(permission);
            this.wkfService.roleRepo.save((Model)role);
        }
    }

    @Transactional
    public void clearOldMetaPermissions(String name) {
        MetaPermission permission = this.metaPermissionRepo.findByName(name);
        if (permission != null) {
            List oldRoleList = this.wkfService.roleRepo.all().filter("self.metaPermissions.id = ?1", new Object[]{permission.getId()}).fetch();
            for (Role role : oldRoleList) {
                role.removeMetaPermission(permission);
                this.wkfService.roleRepo.save((Model)role);
            }
        }
    }
}

