/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.web;

import com.axelor.common.Inflector;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.studio.db.Filter;
import com.axelor.studio.service.filter.FilterSqlService;
import java.util.Map;

public class FilterController {
    public void updateTargetField(ActionRequest request, ActionResponse response) {
        Filter filter = (Filter)((Object)request.getContext().asType(Filter.class));
        MetaField metaField = filter.getMetaField();
        MetaJsonField metaJson = filter.getMetaJsonField();
        Boolean isJson = filter.getIsJson() != null ? filter.getIsJson() : false;
        if (!isJson.booleanValue() && metaField != null) {
            String type = metaField.getRelationship() != null ? metaField.getRelationship() : metaField.getTypeName();
            response.setValue("targetType", (Object)type);
            response.setValue("targetField", (Object)metaField.getName());
            response.setValue("targetTitle", (Object)(metaField.getLabel() != null && !metaField.getLabel().isEmpty() ? metaField.getLabel() : metaField.getName()));
        } else if (isJson.booleanValue() && metaJson != null) {
            response.setValue("targetType", (Object)Inflector.getInstance().camelize(metaJson.getType()));
            response.setValue("targetField", (Object)metaJson.getName());
        } else {
            response.setValue("targetField", null);
            response.setValue("targetType", null);
        }
        response.setValue("operator", null);
    }

    public void updateTargetType(ActionRequest request, ActionResponse response) throws AxelorException {
        Filter filter = (Filter)((Object)request.getContext().asType(Filter.class));
        FilterSqlService filterSqlService = (FilterSqlService)Beans.get(FilterSqlService.class);
        if (filter.getTargetField() == null) {
            return;
        }
        StringBuilder parent = new StringBuilder("self");
        String targetType = filterSqlService.getTargetType(filterSqlService.getTargetField(parent, filter, null, false));
        response.setValue("targetType", (Object)targetType);
        response.setValue("filterOperator", null);
    }

    public void updateTargetMetaField(ActionRequest request, ActionResponse response) {
        Filter filter = (Filter)((Object)request.getContext().asType(Filter.class));
        if (request.getContext().get((Object)"targetMetaField") != null) {
            Integer id = (Integer)((Map)request.getContext().get((Object)"targetMetaField")).get("id");
            MetaField targetMetaField = (MetaField)((MetaFieldRepository)Beans.get(MetaFieldRepository.class)).find(Long.valueOf(id.intValue()));
            String targetTitle = targetMetaField.getLabel() != null && !targetMetaField.getLabel().isEmpty() ? targetMetaField.getLabel() : targetMetaField.getName();
            response.setValue("targetField", (Object)(filter.getTargetField() + "." + targetMetaField.getName()));
            response.setValue("targetTitle", (Object)(filter.getTargetTitle() + "." + targetTitle));
            response.setValue("targetType", (Object)(targetMetaField.getRelationship() != null ? targetMetaField.getRelationship() : targetMetaField.getTypeName()));
            if (targetMetaField.getRelationship() != null) {
                response.setValue("metaTargetFieldDomain", (Object)targetMetaField.getTypeName());
                response.setValue("targetMetaField", null);
            }
        }
        response.setValue("operator", null);
    }

    public void clearSelection(ActionRequest request, ActionResponse response) {
        Filter filter = (Filter)((Object)request.getContext().asType(Filter.class));
        if (filter.getMetaField() != null) {
            response.setValue("targetField", (Object)filter.getMetaField().getName());
            response.setValue("targetTitle", (Object)(filter.getMetaField().getLabel() != null && !filter.getMetaField().getLabel().isEmpty() ? filter.getMetaField().getLabel() : filter.getMetaField().getName()));
            response.setValue("targetType", (Object)filter.getMetaField().getRelationship());
        }
        response.setValue("metaTargetFieldDomain", null);
        response.setValue("targetMetaField", null);
        response.setValue("operator", null);
    }
}

