/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.web;

import com.axelor.common.Inflector;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.meta.schema.views.Selection;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.studio.db.Wkf;
import com.axelor.studio.db.WkfNode;
import com.axelor.studio.db.WkfTransition;
import com.axelor.studio.db.repo.WkfNodeRepository;
import com.axelor.studio.db.repo.WkfRepository;
import com.axelor.studio.db.repo.WkfTransitionRepository;
import com.axelor.studio.service.wkf.WkfDesignerService;
import com.axelor.studio.service.wkf.WkfService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WkfController {
    public void processXml(ActionRequest request, ActionResponse response) {
        try {
            Wkf workflow = (Wkf)((Object)request.getContext().asType(Wkf.class));
            workflow = (Wkf)((Object)((WkfRepository)((Object)Beans.get(WkfRepository.class))).find(workflow.getId()));
            ((WkfDesignerService)Beans.get(WkfDesignerService.class)).processXml(workflow);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void processWkf(ActionRequest request, ActionResponse response) {
        try {
            Wkf workflow = (Wkf)((Object)request.getContext().asType(Wkf.class));
            workflow = (Wkf)((Object)((WkfRepository)((Object)Beans.get(WkfRepository.class))).find(workflow.getId()));
            ((WkfService)Beans.get(WkfService.class)).process(workflow);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void onNodeEdit(ActionRequest request, ActionResponse response) {
        try {
            WkfNodeRepository repo = (WkfNodeRepository)((Object)Beans.get(WkfNodeRepository.class));
            WkfNode node = (WkfNode)((Object)request.getContext().asType(WkfNode.class));
            if (node.getWkf().getId() != null) {
                WkfNode found = (WkfNode)((Object)repo.all().filter("self.wkf.id = ? and self.xmlId = ?", new Object[]{node.getWkf().getId(), node.getXmlId()}).fetchOne());
                if (found != null) {
                    Map view = ActionView.define((String)I18n.get((String)"Edit Node")).add("form", "wkf-node-form").model(WkfNode.class.getName()).context("_showRecord", (Object)found.getId()).param("popup", "true").param("show-toolbar", "false").param("forceEdit", "true").map();
                    response.setView(view);
                } else {
                    response.setFlash(I18n.get((String)"Workflow is not saved"));
                }
            } else {
                response.setFlash(I18n.get((String)"Workflow is not saved"));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void onTransitionEdit(ActionRequest request, ActionResponse response) {
        try {
            WkfTransitionRepository repo = (WkfTransitionRepository)((Object)Beans.get(WkfTransitionRepository.class));
            WkfTransition transition = (WkfTransition)((Object)request.getContext().asType(WkfTransition.class));
            WkfTransition found = (WkfTransition)((Object)repo.all().filter("self.xmlId = ?", new Object[]{transition.getXmlId()}).fetchOne());
            if (found != null) {
                Map view = ActionView.define((String)I18n.get((String)"Edit Transition")).add("form", "wkf-transition-form").model(WkfTransition.class.getName()).context("_showRecord", (Object)found.getId()).param("popup", "true").param("show-toolbar", "false").param("forceEdit", "true").map();
                response.setView(view);
            } else {
                response.setFlash(I18n.get((String)"Workflow is not saved"));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setDefaultNodes(ActionRequest request, ActionResponse response) {
        Wkf wkf = (Wkf)((Object)request.getContext().asType(Wkf.class));
        MetaJsonField wkfField = wkf.getStatusField();
        if (wkfField != null) {
            Optional<Pair<String, String>> nodesOpt = this.getDefaultNodes(wkfField);
            nodesOpt.ifPresent(nodes -> {
                String bpmnXml = " <?xml version=\"1.0\" encoding=\"UTF-8\"?> <definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" xmlns:x=\"http://axelor.com\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" targetNamespace=\"http://bpmn.io/schema/bpmn\" id=\"Definitions_1\"> <process id=\"Process_1\" name=\"" + wkf.getName() + "\" x:id=\"" + wkf.getId() + "\" isExecutable=\"false\"> " + (String)nodes.getLeft() + "</process><bpmndi:BPMNDiagram id=\"BPMNDiagram_1\"><bpmndi:BPMNPlane id=\"BPMNPlane_1\" bpmnElement=\"Process_1\">" + (String)nodes.getRight() + "</bpmndi:BPMNPlane></bpmndi:BPMNDiagram></definitions>";
                response.setValue("$bpmnDefault", (Object)bpmnXml);
            });
        }
    }

    private Optional<Pair<String, String>> getDefaultNodes(MetaJsonField statusField) {
        List<Selection.Option> select = this.getSelect(statusField);
        if (!CollectionUtils.isEmpty(select)) {
            StringBuilder elements = new StringBuilder();
            StringBuilder designs = new StringBuilder();
            int count = 1;
            int x = 100;
            for (Selection.Option option : select) {
                int y;
                String element = null;
                int width = 100;
                int height = 80;
                if (count == 1) {
                    width = 36;
                    height = 36;
                    y = 125;
                    element = "startEvent";
                } else if (count == select.size()) {
                    width = 36;
                    height = 36;
                    x += 150;
                    y = 125;
                    element = "endEvent";
                } else {
                    y = 100;
                    x += 150;
                    element = "task";
                }
                String elementId = Inflector.getInstance().camelize(element, false) + "_" + count;
                element = "<" + element + " id=\"" + elementId + "\" name=\"" + option.getTitle() + "\" />";
                elements.append(element);
                String design = "<bpmndi:BPMNShape id=\"_BPMNShape_" + elementId + "\" bpmnElement=\"" + elementId + "\" ><dc:Bounds x=\"" + x + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" /></bpmndi:BPMNShape>";
                designs.append(design);
                ++count;
            }
            if (elements.length() > 0) {
                return Optional.of(Pair.of((Object)elements.toString(), (Object)designs.toString()));
            }
        }
        return Optional.empty();
    }

    private List<Selection.Option> getSelect(MetaJsonField wkfField) {
        if (wkfField == null) {
            return Collections.emptyList();
        }
        if (wkfField.getSelection() != null) {
            return MetaStore.getSelectionList((String)wkfField.getSelection());
        }
        return Collections.emptyList();
    }
}

