/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.db;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BUSINESSPROJECT_PROJECT_INVOICING_ASSISTANT_BATCH", indexes={@Index(columnList="company")})
public class ProjectInvoicingAssistantBatch
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BUSINESSPROJECT_PROJECT_INVOICING_ASSISTANT_BATCH_SEQ")
    @SequenceGenerator(name="BUSINESSPROJECT_PROJECT_INVOICING_ASSISTANT_BATCH_SEQ", sequenceName="BUSINESSPROJECT_PROJECT_INVOICING_ASSISTANT_BATCH_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Code")
    @NameColumn
    @Column(unique=true)
    private String code;
    @Widget(title="Action", selection="project.invoicing.assistant.batch.action.select")
    @NotNull
    private Integer actionSelect = 0;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Consolidate the phases", selection="project.invoicing.assistant.batch.consolidate.phase.select")
    private Integer consolidatePhaseSelect = 0;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Batches")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="projectInvoicingAssistantBatch", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Batch> batchList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProjectInvoicingAssistantBatch() {
    }

    public ProjectInvoicingAssistantBatch(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getActionSelect() {
        return this.actionSelect == null ? 0 : this.actionSelect;
    }

    public void setActionSelect(Integer actionSelect) {
        this.actionSelect = actionSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getConsolidatePhaseSelect() {
        return this.consolidatePhaseSelect == null ? 0 : this.consolidatePhaseSelect;
    }

    public void setConsolidatePhaseSelect(Integer consolidatePhaseSelect) {
        this.consolidatePhaseSelect = consolidatePhaseSelect;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Batch> getBatchList() {
        return this.batchList;
    }

    public void setBatchList(List<Batch> batchList) {
        this.batchList = batchList;
    }

    public void addBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            this.setBatchList(new ArrayList<Batch>());
        }
        this.getBatchList().add(item);
        item.setProjectInvoicingAssistantBatch(this);
    }

    public void removeBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            return;
        }
        this.getBatchList().remove((Object)item);
    }

    public void clearBatchList() {
        if (this.getBatchList() != null) {
            this.getBatchList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectInvoicingAssistantBatch)) {
            return false;
        }
        ProjectInvoicingAssistantBatch other = (ProjectInvoicingAssistantBatch)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(1507516173, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("actionSelect", (Object)this.getActionSelect()).add("consolidatePhaseSelect", (Object)this.getConsolidatePhaseSelect()).omitNullValues().toString();
    }
}

