/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.service.AccountManagementAccountService;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.apps.hr.db.repo.ExpenseRepository;
import com.axelor.apps.hr.service.config.AccountConfigHRService;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.expense.ExpenseServiceImpl;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;

public class ExpenseServiceProjectImpl
extends ExpenseServiceImpl {
    @Inject
    public ExpenseServiceProjectImpl(MoveService moveService, ExpenseRepository expenseRepository, MoveLineService moveLineService, AccountManagementAccountService accountManagementAccountService, AppAccountService appAccountService, AccountConfigHRService accountConfigService, AccountingSituationService accountingSituationService, AnalyticMoveLineService analyticMoveLineService, HRConfigService hrConfigService, TemplateMessageService templateMessageService, PaymentModeService paymentModeService) {
        super(moveService, expenseRepository, moveLineService, accountManagementAccountService, appAccountService, accountConfigService, accountingSituationService, analyticMoveLineService, hrConfigService, templateMessageService, paymentModeService);
    }

    public List<InvoiceLine> createInvoiceLines(Invoice invoice, List<ExpenseLine> expenseLineList, int priority) throws AxelorException {
        if (!((AppAccountService)Beans.get(AppAccountService.class)).isApp("business-project")) {
            return super.createInvoiceLines(invoice, expenseLineList, priority);
        }
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        int count = 0;
        for (ExpenseLine expenseLine : expenseLineList) {
            invoiceLineList.addAll(this.createInvoiceLine(invoice, expenseLine, priority * 100 + count));
            ++count;
            ((InvoiceLine)((Object)invoiceLineList.get(invoiceLineList.size() - 1))).setProject(expenseLine.getProject());
        }
        return invoiceLineList;
    }
}

