/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.InvoiceLineRepository;
import com.axelor.apps.account.service.AccountManagementAccountService;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.PriceListService;
import com.axelor.apps.businessproject.service.InvoiceLineProjectService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.purchase.service.PurchaseProductService;
import com.axelor.apps.supplychain.service.InvoiceLineSupplychainService;
import com.axelor.db.Model;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.List;

public class InvoiceLineProjectServiceImpl
extends InvoiceLineSupplychainService
implements InvoiceLineProjectService {
    @Inject
    private InvoiceLineRepository invoiceLineRepo;

    @Inject
    public InvoiceLineProjectServiceImpl(CurrencyService currencyService, PriceListService priceListService, AppAccountService appAccountService, AnalyticMoveLineService analyticMoveLineService, AccountManagementAccountService accountManagementAccountService, PurchaseProductService purchaseProductService) {
        super(currencyService, priceListService, appAccountService, analyticMoveLineService, accountManagementAccountService, purchaseProductService);
    }

    @Override
    @Transactional
    public void setProject(List<Long> invoiceLineIds, Project project) {
        if (invoiceLineIds != null) {
            List invoiceLineList = this.invoiceLineRepo.all().filter("self.id in ?1", new Object[]{invoiceLineIds}).fetch();
            for (InvoiceLine line : invoiceLineList) {
                line.setProject(project);
                this.invoiceLineRepo.save((Model)((Object)line));
            }
        }
    }

    public List<AnalyticMoveLine> createAnalyticDistributionWithTemplate(InvoiceLine invoiceLine) {
        List analyticMoveLineList = super.createAnalyticDistributionWithTemplate(invoiceLine);
        if (invoiceLine.getProject() != null && analyticMoveLineList != null) {
            analyticMoveLineList.forEach(analyticLine -> analyticLine.setProject(invoiceLine.getProject()));
        }
        return analyticMoveLineList;
    }
}

