/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.account.service.invoice.print.InvoicePrintServiceImpl;
import com.axelor.apps.account.util.InvoiceLineComparator;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.businessproject.db.InvoicingProject;
import com.axelor.apps.businessproject.db.repo.InvoicingProjectRepository;
import com.axelor.apps.businessproject.service.PurchaseOrderInvoiceProjectServiceImpl;
import com.axelor.apps.businessproject.service.TeamTaskBusinessProjectService;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.db.repo.ExpenseLineRepository;
import com.axelor.apps.hr.db.repo.TimesheetLineRepository;
import com.axelor.apps.hr.service.expense.ExpenseService;
import com.axelor.apps.hr.service.timesheet.TimesheetService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderLineRepository;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceLineGeneratorSupplyChain;
import com.axelor.apps.tool.file.PdfTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class InvoicingProjectService {
    @Inject
    protected TimesheetService timesheetService;
    @Inject
    protected ExpenseService expenseService;
    @Inject
    protected PartnerService partnerService;
    @Inject
    protected TeamTaskBusinessProjectService teamTaskBusinessProjectService;
    @Inject
    protected InvoicingProjectRepository invoicingProjectRepo;
    protected int MAX_LEVEL_OF_PROJECT = 10;
    protected int sequence = 0;
    protected static final String DATE_FORMAT_YYYYMMDDHHMM = "YYYYMMddHHmm";

    @Transactional(rollbackOn={Exception.class})
    public Invoice generateInvoice(InvoicingProject invoicingProject) throws AxelorException {
        Company company;
        final Project project = invoicingProject.getProject();
        Partner customer = project.getClientPartner();
        Partner customerContact = project.getContactPartner();
        if (invoicingProject.getSaleOrderLineSet().isEmpty() && invoicingProject.getPurchaseOrderLineSet().isEmpty() && invoicingProject.getLogTimesSet().isEmpty() && invoicingProject.getExpenseLineSet().isEmpty() && invoicingProject.getProjectSet().isEmpty() && invoicingProject.getTeamTaskSet().isEmpty()) {
            throw new AxelorException((Model)((Object)invoicingProject), 4, I18n.get((String)"You haven't select any element to invoice"));
        }
        if (invoicingProject.getProject() == null) {
            throw new AxelorException((Model)((Object)invoicingProject), 4, I18n.get((String)"You must select a project/task"));
        }
        if (invoicingProject.getProject().getClientPartner() == null) {
            throw new AxelorException((Model)((Object)invoicingProject), 4, I18n.get((String)"There is no customer for this project/task"));
        }
        if (customerContact == null && customer.getContactPartnerSet().size() == 1) {
            customerContact = customer.getContactPartnerSet().iterator().next();
        }
        if ((company = this.getRootCompany(project)) == null) {
            throw new AxelorException((Model)((Object)invoicingProject), 4, I18n.get((String)"You haven't select a company on the main project"));
        }
        InvoiceGenerator invoiceGenerator = new InvoiceGenerator(3, company, customer.getPaymentCondition(), customer.getInPaymentMode(), this.partnerService.getInvoicingAddress(customer), customer, customerContact, customer.getCurrency(), ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(customer, 1), null, null, null, null, null){

            public Invoice generate() throws AxelorException {
                Invoice invoice = super.createInvoiceHeader();
                invoice.setProject(project);
                invoice.setPriceList(project.getPriceList());
                return invoice;
            }
        };
        Invoice invoice = invoiceGenerator.generate();
        AccountConfigService accountConfigService = (AccountConfigService)Beans.get(AccountConfigService.class);
        AccountConfig accountConfig = accountConfigService.getAccountConfig(company);
        invoice.setDisplayTimesheetOnPrinting(accountConfig.getDisplayTimesheetOnPrinting());
        invoice.setDisplayExpenseOnPrinting(accountConfig.getDisplayExpenseOnPrinting());
        invoiceGenerator.populate(invoice, this.populate(invoice, invoicingProject));
        ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).save((Model)((Object)invoice));
        invoicingProject.setInvoice(invoice);
        invoicingProject.setStatusSelect(2);
        this.invoicingProjectRepo.save((Model)((Object)invoicingProject));
        return invoice;
    }

    public List<InvoiceLine> populate(Invoice invoice, InvoicingProject folder) throws AxelorException {
        ArrayList<SaleOrderLine> saleOrderLineList = new ArrayList<SaleOrderLine>(folder.getSaleOrderLineSet());
        ArrayList<PurchaseOrderLine> purchaseOrderLineList = new ArrayList<PurchaseOrderLine>(folder.getPurchaseOrderLineSet());
        ArrayList<TimesheetLine> timesheetLineList = new ArrayList<TimesheetLine>(folder.getLogTimesSet());
        ArrayList<ExpenseLine> expenseLineList = new ArrayList<ExpenseLine>(folder.getExpenseLineSet());
        ArrayList<TeamTask> teamTaskList = new ArrayList<TeamTask>(folder.getTeamTaskSet());
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        invoiceLineList.addAll(this.createSaleOrderInvoiceLines(invoice, saleOrderLineList, folder.getSaleOrderLineSetPrioritySelect()));
        invoiceLineList.addAll(this.createPurchaseOrderInvoiceLines(invoice, purchaseOrderLineList, folder.getPurchaseOrderLineSetPrioritySelect()));
        invoiceLineList.addAll(this.timesheetService.createInvoiceLines(invoice, timesheetLineList, folder.getLogTimesSetPrioritySelect().intValue()));
        invoiceLineList.addAll(this.expenseService.createInvoiceLines(invoice, expenseLineList, folder.getExpenseLineSetPrioritySelect().intValue()));
        invoiceLineList.addAll(this.teamTaskBusinessProjectService.createInvoiceLines(invoice, teamTaskList, folder.getTeamTaskSetPrioritySelect()));
        Collections.sort(invoiceLineList, new InvoiceLineComparator());
        for (InvoiceLine invoiceLine : invoiceLineList) {
            invoiceLine.setSequence(this.sequence);
            ++this.sequence;
        }
        return invoiceLineList;
    }

    public List<InvoiceLine> createSaleOrderInvoiceLines(Invoice invoice, List<SaleOrderLine> saleOrderLineList, int priority) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        int count = 1;
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            invoiceLineList.addAll(this.createInvoiceLine(invoice, saleOrderLine, priority * 100 + count));
            ++count;
        }
        return invoiceLineList;
    }

    public List<InvoiceLine> createInvoiceLine(Invoice invoice, SaleOrderLine saleOrderLine, int priority) throws AxelorException {
        Product product = saleOrderLine.getProduct();
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, saleOrderLine.getProductName(), saleOrderLine.getDescription(), saleOrderLine.getQty(), saleOrderLine.getUnit(), priority, false, saleOrderLine, null, null, false, 0){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                invoiceLine.setProject(this.saleOrderLine.getProject());
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }

    public List<InvoiceLine> createPurchaseOrderInvoiceLines(Invoice invoice, List<PurchaseOrderLine> purchaseOrderLineList, int priority) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
            invoiceLineList.addAll(((PurchaseOrderInvoiceProjectServiceImpl)((Object)Beans.get(PurchaseOrderInvoiceProjectServiceImpl.class))).createInvoiceLine(invoice, purchaseOrderLine));
        }
        return invoiceLineList;
    }

    public List<InvoiceLine> createInvoiceLine(Invoice invoice, PurchaseOrderLine purchaseOrderLine, int priority) throws AxelorException {
        Product product = purchaseOrderLine.getProduct();
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, purchaseOrderLine.getProductName(), purchaseOrderLine.getDescription(), purchaseOrderLine.getQty(), purchaseOrderLine.getUnit(), priority, false, null, purchaseOrderLine, null, false, 0){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }

    public void setLines(InvoicingProject invoicingProject, Project project, int counter) {
        if (counter > 10) {
            return;
        }
        ++counter;
        this.fillLines(invoicingProject, project);
        if (!invoicingProject.getConsolidatePhaseWhenInvoicing().booleanValue()) {
            return;
        }
        List projectChildrenList = ((ProjectRepository)((Object)Beans.get(ProjectRepository.class))).all().filter("self.parentProject = ?1", new Object[]{project}).fetch();
        for (Project projectChild : projectChildrenList) {
            this.setLines(invoicingProject, projectChild, counter);
        }
    }

    public void fillLines(InvoicingProject invoicingProject, Project project) {
        String commonQuery = "self.project = :project AND self.toInvoice = true AND self.invoiced = false";
        StringBuilder solQueryBuilder = new StringBuilder(commonQuery);
        solQueryBuilder.append(" AND (self.saleOrder.statusSelect = :statusConfirmed OR self.saleOrder.statusSelect = :statusCompleted)");
        HashMap<String, Object> solQueryMap = new HashMap<String, Object>();
        solQueryMap.put("project", (Object)project);
        solQueryMap.put("statusConfirmed", 3);
        solQueryMap.put("statusCompleted", 4);
        StringBuilder polQueryBuilder = new StringBuilder(commonQuery);
        polQueryBuilder.append(" AND (self.purchaseOrder.statusSelect = 3 OR self.purchaseOrder.statusSelect = 4)");
        HashMap<String, Object> polQueryMap = new HashMap<String, Object>();
        polQueryMap.put("project", (Object)project);
        StringBuilder logTimesQueryBuilder = new StringBuilder(commonQuery);
        HashMap<String, Object> logTimesQueryMap = new HashMap<String, Object>();
        logTimesQueryMap.put("project", (Object)project);
        StringBuilder expenseLineQueryBuilder = new StringBuilder(commonQuery);
        expenseLineQueryBuilder.append(" AND (self.expense.statusSelect = :statusValidated OR self.expense.statusSelect = :statusReimbursed)");
        HashMap<String, Object> expenseLineQueryMap = new HashMap<String, Object>();
        expenseLineQueryMap.put("project", (Object)project);
        expenseLineQueryMap.put("statusValidated", 3);
        expenseLineQueryMap.put("statusReimbursed", 4);
        StringBuilder taskQueryBuilder = new StringBuilder(commonQuery);
        taskQueryBuilder.append(" AND self.invoicingType = :invoicingTypePackage");
        HashMap<String, Object> taskQueryMap = new HashMap<String, Object>();
        taskQueryMap.put("project", (Object)project);
        taskQueryMap.put("invoicingTypePackage", TeamTaskRepository.INVOICING_TYPE_PACKAGE);
        if (invoicingProject.getDeadlineDate() != null) {
            solQueryBuilder.append(" AND self.saleOrder.creationDate <= :deadlineDate");
            solQueryMap.put("deadlineDate", invoicingProject.getDeadlineDate());
            polQueryBuilder.append(" AND self.purchaseOrder.orderDate <= :deadlineDate");
            polQueryMap.put("deadlineDate", invoicingProject.getDeadlineDate());
            logTimesQueryBuilder.append(" AND self.date <= :deadlineDate");
            logTimesQueryMap.put("deadlineDate", invoicingProject.getDeadlineDate());
            expenseLineQueryBuilder.append(" AND self.expenseDate <= :deadlineDate");
            expenseLineQueryMap.put("deadlineDate", invoicingProject.getDeadlineDate());
            taskQueryBuilder.append(" AND self.taskDeadline <= :deadlineDate");
            taskQueryMap.put("deadlineDate", invoicingProject.getDeadlineDate());
        }
        invoicingProject.getSaleOrderLineSet().addAll(((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).all().filter(solQueryBuilder.toString()).bind(solQueryMap).fetch());
        invoicingProject.getPurchaseOrderLineSet().addAll(((PurchaseOrderLineRepository)((Object)Beans.get(PurchaseOrderLineRepository.class))).all().filter(polQueryBuilder.toString()).bind(polQueryMap).fetch());
        invoicingProject.getLogTimesSet().addAll(((TimesheetLineRepository)Beans.get(TimesheetLineRepository.class)).all().filter(logTimesQueryBuilder.toString()).bind(logTimesQueryMap).fetch());
        invoicingProject.getExpenseLineSet().addAll(((ExpenseLineRepository)Beans.get(ExpenseLineRepository.class)).all().filter(expenseLineQueryBuilder.toString()).bind(expenseLineQueryMap).fetch());
        invoicingProject.getTeamTaskSet().addAll(((TeamTaskRepository)((Object)Beans.get(TeamTaskRepository.class))).all().filter(taskQueryBuilder.toString()).bind(taskQueryMap).fetch());
    }

    public void clearLines(InvoicingProject invoicingProject) {
        invoicingProject.setSaleOrderLineSet(new HashSet<SaleOrderLine>());
        invoicingProject.setPurchaseOrderLineSet(new HashSet<PurchaseOrderLine>());
        invoicingProject.setLogTimesSet(new HashSet<TimesheetLine>());
        invoicingProject.setExpenseLineSet(new HashSet<ExpenseLine>());
        invoicingProject.setProjectSet(new HashSet<Project>());
        invoicingProject.setTeamTaskSet(new HashSet<TeamTask>());
    }

    public Company getRootCompany(Project project) {
        if (project.getParentProject() == null) {
            return project.getCompany();
        }
        return this.getRootCompany(project.getParentProject());
    }

    public int countToInvoice(Project project) {
        int toInvoiceCount = 0;
        String query = "self.project = ?1";
        if (project.getIsShowPhasesElements().booleanValue()) {
            query = "(self.project = ?1 OR self.project.parentProject = ?1)";
        }
        query = query + " AND self.toInvoice = true AND self.invoiced = false";
        toInvoiceCount = (int)((long)toInvoiceCount + ((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).all().filter(query, new Object[]{project}).count());
        toInvoiceCount = (int)((long)toInvoiceCount + ((PurchaseOrderLineRepository)((Object)Beans.get(PurchaseOrderLineRepository.class))).all().filter(query, new Object[]{project}).count());
        toInvoiceCount = (int)((long)toInvoiceCount + ((ExpenseLineRepository)Beans.get(ExpenseLineRepository.class)).all().filter(query, new Object[]{project}).count());
        toInvoiceCount = (int)((long)toInvoiceCount + ((TimesheetLineRepository)Beans.get(TimesheetLineRepository.class)).all().filter(query, new Object[]{project}).count());
        toInvoiceCount = (int)((long)toInvoiceCount + ((TeamTaskRepository)((Object)Beans.get(TeamTaskRepository.class))).all().filter(query, new Object[]{project}).count());
        return toInvoiceCount;
    }

    public void generateAnnex(InvoicingProject invoicingProject) throws AxelorException, IOException {
        String title = I18n.get((String)"InvoicingProjectAnnex") + "-" + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDDHHMM));
        ReportSettings reportSettings = ReportFactory.createReport((String)"InvoicingProjectAnnex.rptdesign", (String)title).addParam("InvProjectId", (Object)invoicingProject.getId()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null));
        if (invoicingProject.getAttachAnnexToInvoice().booleanValue()) {
            ArrayList<File> fileList = new ArrayList<File>();
            MetaFiles metaFiles = (MetaFiles)Beans.get(MetaFiles.class);
            fileList.add(((InvoicePrintServiceImpl)Beans.get(InvoicePrintServiceImpl.class)).print(invoicingProject.getInvoice(), null, "pdf", null));
            fileList.add(reportSettings.generate().getFile());
            MetaFile metaFile = metaFiles.upload(PdfTool.mergePdf(fileList));
            metaFile.setFileName(title + ".pdf");
            metaFiles.attach(metaFile, null, (Model)((Object)invoicingProject));
            return;
        }
        reportSettings.toAttach((Model)((Object)invoicingProject)).generate();
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public InvoicingProject generateInvoicingProject(Project project, int consolidatePhaseSelect) {
        if (project == null) {
            return null;
        }
        InvoicingProject invoicingProject = new InvoicingProject();
        invoicingProject.setProject(project);
        if (consolidatePhaseSelect == 1) {
            invoicingProject.setConsolidatePhaseWhenInvoicing(true);
        } else if (consolidatePhaseSelect == 2) {
            invoicingProject.setConsolidatePhaseWhenInvoicing(false);
        } else if (consolidatePhaseSelect == 3) {
            invoicingProject.setConsolidatePhaseWhenInvoicing(invoicingProject.getProject().getConsolidatePhaseWhenInvoicing());
        }
        this.clearLines(invoicingProject);
        this.setLines(invoicingProject, project, 0);
        if (invoicingProject.getSaleOrderLineSet().isEmpty() && invoicingProject.getPurchaseOrderLineSet().isEmpty() && invoicingProject.getLogTimesSet().isEmpty() && invoicingProject.getExpenseLineSet().isEmpty() && invoicingProject.getProjectSet().isEmpty() && invoicingProject.getTeamTaskSet().isEmpty()) {
            return invoicingProject;
        }
        return (InvoicingProject)((Object)this.invoicingProjectRepo.save((Model)((Object)invoicingProject)));
    }
}

