/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.businessproject.service.ProjectFolderService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectFolder;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.tool.ModelTool;
import com.axelor.apps.tool.ThrowConsumer;
import com.axelor.apps.tool.file.PdfTool;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

public class ProjectFolderServiceImpl
implements ProjectFolderService {
    @Override
    public String printProjectsPlanificationAndCost(ProjectFolder projectFolder) throws IOException, AxelorException {
        final ArrayList printedProjects = new ArrayList();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Project project : projectFolder.getProjectSet()) {
            ids.add(project.getId());
        }
        ModelTool.apply(Project.class, ids, (ThrowConsumer)new ThrowConsumer<Project>(){

            public void accept(Project project) throws Exception {
                String name = I18n.get((String)"Project planification and costs");
                if (project.getCode() != null) {
                    name = name + " (" + project.getCode() + ")";
                }
                printedProjects.add(ProjectFolderServiceImpl.this.printCopiesToFile(project, name, "PlannificationAndCost.rptdesign"));
            }
        });
        String fileName = this.getProjectFilesName(I18n.get((String)"Project planification and costs"));
        return PdfTool.mergePdfToFileLink(printedProjects, (String)fileName);
    }

    @Override
    public String printProjectFinancialReport(ProjectFolder projectFolder) throws IOException, AxelorException {
        final ArrayList printedProjects = new ArrayList();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Project project : projectFolder.getProjectSet()) {
            ids.add(project.getId());
        }
        ModelTool.apply(Project.class, ids, (ThrowConsumer)new ThrowConsumer<Project>(){

            public void accept(Project project) throws Exception {
                String name = I18n.get((String)"Projects financial report") + " " + project.getCode();
                printedProjects.add(ProjectFolderServiceImpl.this.printCopiesToFile(project, name, "Project.rptdesign"));
            }
        });
        String fileName = this.getProjectFilesName(I18n.get((String)"Projects financial report"));
        return PdfTool.mergePdfToFileLink(printedProjects, (String)fileName);
    }

    public File printCopiesToFile(Project project, String name, String reportDesignName) throws AxelorException, IOException {
        File file = this.print(project, name, reportDesignName);
        return PdfTool.printCopiesToFile((File)file, (int)1);
    }

    public File print(Project project, String name, String reportDesignName) throws AxelorException {
        ReportSettings reportSettings = this.prepareReportSettings(project, name, reportDesignName);
        return reportSettings.generate().getFile();
    }

    private ReportSettings prepareReportSettings(Project project, String name, String reportDesignName) {
        ReportSettings reportSetting = ReportFactory.createReport((String)reportDesignName, (String)name);
        return reportSetting.addParam("ProjectId", (Object)project.getId()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addFormat("pdf");
    }

    protected String getProjectFilesName(String fileName) {
        return fileName + " - " + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate().format(DateTimeFormatter.BASIC_ISO_DATE) + "." + "pdf";
    }
}

