/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.InvoiceLineRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.businessproject.service.app.AppBusinessProjectService;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.StockMoveInvoiceServiceImpl;
import com.axelor.apps.supplychain.service.StockMoveLineServiceSupplychain;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.List;

public class ProjectStockMoveInvoiceServiceImpl
extends StockMoveInvoiceServiceImpl {
    @Inject
    public ProjectStockMoveInvoiceServiceImpl(SaleOrderInvoiceService saleOrderInvoiceService, PurchaseOrderInvoiceService purchaseOrderInvoiceService, StockMoveLineServiceSupplychain stockMoveLineServiceSupplychain, InvoiceRepository invoiceRepository, SaleOrderRepository saleOrderRepo, PurchaseOrderRepository purchaseOrderRepo, StockMoveLineRepository stockMoveLineRepository, InvoiceLineRepository invoiceLineRepository) {
        super(saleOrderInvoiceService, purchaseOrderInvoiceService, stockMoveLineServiceSupplychain, invoiceRepository, saleOrderRepo, purchaseOrderRepo, stockMoveLineRepository, invoiceLineRepository);
    }

    public List<InvoiceLine> createInvoiceLine(Invoice invoice, StockMoveLine stockMoveLine, BigDecimal qty) throws AxelorException {
        List invoiceLines = super.createInvoiceLine(invoice, stockMoveLine, qty);
        if (!((AppBusinessProjectService)Beans.get(AppBusinessProjectService.class)).isApp("business-project")) {
            return invoiceLines;
        }
        for (InvoiceLine invoiceLine : invoiceLines) {
            PurchaseOrderLine purchaseOrderLine;
            SaleOrderLine saleOrderLine = invoiceLine.getSaleOrderLine();
            if (saleOrderLine != null) {
                invoiceLine.setProject(saleOrderLine.getProject());
            }
            if ((purchaseOrderLine = invoiceLine.getPurchaseOrderLine()) == null) continue;
            invoiceLine.setProject(purchaseOrderLine.getProject());
        }
        return invoiceLines;
    }
}

