/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.businessproject.service.app.AppBusinessProjectService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.saleorder.SaleOrderLineService;
import com.axelor.apps.sale.service.saleorder.SaleOrderWorkflowServiceImpl;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceServiceImpl;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.List;

public class SaleOrderInvoiceProjectServiceImpl
extends SaleOrderInvoiceServiceImpl {
    private AppBusinessProjectService appBusinessProjectService;

    @Inject
    public SaleOrderInvoiceProjectServiceImpl(AppSupplychainService appSupplychainService, SaleOrderRepository saleOrderRepo, InvoiceRepository invoiceRepo, InvoiceService invoiceService, AppBusinessProjectService appBusinessProjectService, StockMoveRepository stockMoveRepository, SaleOrderLineService saleOrderLineService, SaleOrderWorkflowServiceImpl saleOrderWorkflowServiceImpl) {
        super(appSupplychainService, saleOrderRepo, invoiceRepo, invoiceService, saleOrderLineService, stockMoveRepository, saleOrderWorkflowServiceImpl);
        this.appBusinessProjectService = appBusinessProjectService;
    }

    @Transactional(rollbackOn={Exception.class})
    public Invoice mergeInvoice(List<Invoice> invoiceList, Company company, Currency currency, Partner partner, Partner contactPartner, PriceList priceList, PaymentMode paymentMode, PaymentCondition paymentCondition, SaleOrder saleOrder, Project project) throws AxelorException {
        Invoice invoiceMerged = super.mergeInvoice(invoiceList, company, currency, partner, contactPartner, priceList, paymentMode, paymentCondition, saleOrder);
        if (project != null && !this.appBusinessProjectService.getAppBusinessProject().getProjectInvoiceLines().booleanValue()) {
            invoiceMerged.setProject(project);
            for (InvoiceLine invoiceLine : invoiceMerged.getInvoiceLineList()) {
                invoiceLine.setProject(project);
            }
        }
        return invoiceMerged;
    }

    public List<InvoiceLine> createInvoiceLine(Invoice invoice, SaleOrderLine saleOrderLine, BigDecimal qtyToInvoice) throws AxelorException {
        List invoiceLines = super.createInvoiceLine(invoice, saleOrderLine, qtyToInvoice);
        if (!((AppBusinessProjectService)Beans.get(AppBusinessProjectService.class)).isApp("business-project")) {
            return invoiceLines;
        }
        for (InvoiceLine invoiceLine : invoiceLines) {
            if (saleOrderLine == null) continue;
            invoiceLine.setProject(saleOrderLine.getProject());
        }
        return invoiceLines;
    }
}

