/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.businessproject.service.SaleOrderLineProjectService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.supplychain.service.SaleOrderLineServiceSupplyChainImpl;
import com.axelor.db.Model;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.List;

public class SaleOrderLineProjectServiceImpl
extends SaleOrderLineServiceSupplyChainImpl
implements SaleOrderLineProjectService {
    @Inject
    private SaleOrderLineRepository saleOrderLineRepo;

    @Override
    @Transactional
    public void setProject(List<Long> saleOrderLineIds, Project project) {
        if (saleOrderLineIds != null) {
            List saleOrderLineList = this.saleOrderLineRepo.all().filter("self.id in ?1", new Object[]{saleOrderLineIds}).fetch();
            for (SaleOrderLine line : saleOrderLineList) {
                line.setProject(project);
                this.saleOrderLineRepo.save((Model)((Object)line));
            }
        }
    }

    public SaleOrderLine createAnalyticDistributionWithTemplate(SaleOrderLine saleOrderLine) {
        SaleOrderLine soLine = super.createAnalyticDistributionWithTemplate(saleOrderLine);
        List<AnalyticMoveLine> analyticMoveLineList = soLine.getAnalyticMoveLineList();
        if (soLine.getProject() != null && analyticMoveLineList != null) {
            analyticMoveLineList.forEach(analyticLine -> analyticLine.setProject(soLine.getProject()));
        }
        return soLine;
    }
}

