/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.service.invoice.generator.InvoiceLineGenerator;
import com.axelor.apps.base.db.AppBusinessProject;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PriceListLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.PriceListLineRepository;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.PriceListService;
import com.axelor.apps.businessproject.service.TeamTaskBusinessProjectService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.TaskTemplate;
import com.axelor.apps.project.db.TeamTaskCategory;
import com.axelor.apps.project.service.TeamTaskProjectServiceImpl;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TeamTaskBusinessProjectServiceImpl
extends TeamTaskProjectServiceImpl
implements TeamTaskBusinessProjectService {
    private PriceListLineRepository priceListLineRepository;
    private PriceListService priceListService;

    @Inject
    public TeamTaskBusinessProjectServiceImpl(TeamTaskRepository teamTaskRepo, PriceListLineRepository priceListLineRepository, PriceListService priceListService) {
        super(teamTaskRepo);
        this.priceListLineRepository = priceListLineRepository;
        this.priceListService = priceListService;
    }

    @Override
    public TeamTask create(SaleOrderLine saleOrderLine, Project project, User assignedTo) {
        PriceListLine line;
        TeamTask task = this.create(saleOrderLine.getFullName() + "_task", project, assignedTo);
        task.setProduct(saleOrderLine.getProduct());
        task.setUnit(saleOrderLine.getUnit());
        task.setCurrency(project.getClientPartner().getCurrency());
        if (project.getPriceList() != null && (line = this.priceListLineRepository.findByPriceListAndProduct(project.getPriceList(), saleOrderLine.getProduct())) != null) {
            task.setUnitPrice(line.getAmount());
        }
        if (task.getUnitPrice() == null) {
            task.setUnitPrice(saleOrderLine.getProduct().getSalePrice());
        }
        task.setQuantity(saleOrderLine.getQty());
        task.setSaleOrderLine(saleOrderLine);
        task.setToInvoice(saleOrderLine.getSaleOrder() != null ? saleOrderLine.getSaleOrder().getToInvoiceViaTask() : false);
        return task;
    }

    @Override
    public TeamTask create(TaskTemplate template, Project project, LocalDateTime date, BigDecimal qty) {
        TeamTask task = this.create(template.getName(), project, template.getAssignedTo());
        task.setTaskDate(date.toLocalDate());
        task.setTaskEndDate(date.plusHours(template.getDuration().longValue()).toLocalDate());
        BigDecimal plannedHrs = template.getTotalPlannedHrs();
        if (template.getIsUniqueTaskForMultipleQuantity().booleanValue() && qty.compareTo(BigDecimal.ONE) > 0) {
            plannedHrs = plannedHrs.multiply(qty);
            task.setName(task.getName() + " x" + qty.intValue());
        }
        task.setTotalPlannedHrs(plannedHrs);
        return task;
    }

    @Override
    public TeamTask updateDiscount(TeamTask teamTask) {
        PriceList priceList = teamTask.getProject().getPriceList();
        if (priceList == null) {
            this.emptyDiscounts(teamTask);
            return teamTask;
        }
        PriceListLine priceListLine = this.getPriceListLine(teamTask, priceList, teamTask.getUnitPrice());
        Map discounts = this.priceListService.getReplacedPriceAndDiscounts(priceList, priceListLine, teamTask.getUnitPrice());
        if (discounts == null) {
            this.emptyDiscounts(teamTask);
        } else {
            teamTask.setDiscountTypeSelect((Integer)discounts.get("discountTypeSelect"));
            teamTask.setDiscountAmount((BigDecimal)discounts.get("discountAmount"));
            if (discounts.get("price") != null) {
                teamTask.setPriceDiscounted((BigDecimal)discounts.get("price"));
            }
        }
        return teamTask;
    }

    private void emptyDiscounts(TeamTask teamTask) {
        teamTask.setDiscountTypeSelect(0);
        teamTask.setDiscountAmount(BigDecimal.ZERO);
        teamTask.setPriceDiscounted(BigDecimal.ZERO);
    }

    private PriceListLine getPriceListLine(TeamTask teamTask, PriceList priceList, BigDecimal price) {
        return this.priceListService.getPriceListLine(teamTask.getProduct(), teamTask.getQuantity(), priceList, price);
    }

    @Override
    public TeamTask compute(TeamTask teamTask) {
        if (teamTask.getProduct() == null && teamTask.getProject() == null || teamTask.getUnitPrice() == null || teamTask.getQuantity() == null) {
            return teamTask;
        }
        BigDecimal priceDiscounted = this.computeDiscount(teamTask);
        BigDecimal exTaxTotal = this.computeAmount(teamTask.getQuantity(), priceDiscounted);
        teamTask.setPriceDiscounted(priceDiscounted);
        teamTask.setExTaxTotal(exTaxTotal);
        return teamTask;
    }

    private BigDecimal computeDiscount(TeamTask teamTask) {
        return this.priceListService.computeDiscount(teamTask.getUnitPrice(), teamTask.getDiscountTypeSelect().intValue(), teamTask.getDiscountAmount());
    }

    private BigDecimal computeAmount(BigDecimal quantity, BigDecimal price) {
        BigDecimal amount = price.multiply(quantity).setScale(2, RoundingMode.HALF_EVEN);
        return amount;
    }

    @Override
    public List<InvoiceLine> createInvoiceLines(Invoice invoice, List<TeamTask> teamTaskList, int priority) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        int count = 0;
        for (TeamTask teamTask : teamTaskList) {
            invoiceLineList.addAll(this.createInvoiceLine(invoice, teamTask, priority * 100 + count));
            ++count;
        }
        return invoiceLineList;
    }

    @Override
    public List<InvoiceLine> createInvoiceLine(Invoice invoice, final TeamTask teamTask, int priority) throws AxelorException {
        InvoiceLineGenerator invoiceLineGenerator = new InvoiceLineGenerator(invoice, teamTask.getProduct(), teamTask.getName(), teamTask.getUnitPrice(), BigDecimal.ZERO, teamTask.getPriceDiscounted(), teamTask.getDescription(), teamTask.getQuantity(), teamTask.getUnit(), null, priority, teamTask.getDiscountAmount(), teamTask.getDiscountTypeSelect(), teamTask.getExTaxTotal(), BigDecimal.ZERO, false, false, 0){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                invoiceLine.setProject(teamTask.getProject());
                invoiceLine.setSaleOrderLine(teamTask.getSaleOrderLine());
                teamTask.setInvoiceLine(invoiceLine);
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }

    protected void setModuleFields(TeamTask teamTask, LocalDate date, TeamTask newTeamTask) {
        super.setModuleFields(teamTask, date, newTeamTask);
    }

    protected void updateModuleFields(TeamTask teamTask, TeamTask nextTeamTask) {
        super.updateModuleFields(teamTask, nextTeamTask);
        nextTeamTask.setToInvoice(teamTask.getToInvoice());
        nextTeamTask.setExTaxTotal(teamTask.getExTaxTotal());
        nextTeamTask.setDiscountTypeSelect(teamTask.getDiscountTypeSelect());
        nextTeamTask.setDiscountAmount(teamTask.getDiscountAmount());
        nextTeamTask.setPriceDiscounted(teamTask.getPriceDiscounted());
        nextTeamTask.setInvoicingType(teamTask.getInvoicingType());
        nextTeamTask.setCustomerReferral(teamTask.getCustomerReferral());
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public TeamTask updateTask(TeamTask teamTask, AppBusinessProject appBusinessProject) {
        if ((teamTask = this.computeDefaultInformation(teamTask)).getInvoicingType() == TeamTaskRepository.INVOICING_TYPE_PACKAGE && !teamTask.getIsTaskRefused().booleanValue()) {
            switch (teamTask.getProject().getInvoicingSequenceSelect()) {
                case 1: {
                    teamTask.setToInvoice(!Strings.isNullOrEmpty((String)appBusinessProject.getPreTaskStatusSet()) && Arrays.asList(appBusinessProject.getPreTaskStatusSet().split(",")).contains(teamTask.getStatus()));
                    break;
                }
                case 2: {
                    teamTask.setToInvoice(!Strings.isNullOrEmpty((String)appBusinessProject.getPostTaskStatusSet()) && Arrays.asList(appBusinessProject.getPostTaskStatusSet().split(",")).contains(teamTask.getStatus()));
                }
            }
        } else {
            teamTask.setToInvoice(teamTask.getInvoicingType() == TeamTaskRepository.INVOICING_TYPE_TIME_SPENT);
        }
        return (TeamTask)((Object)this.teamTaskRepo.save((Model)((Object)teamTask)));
    }

    @Override
    public TeamTask computeDefaultInformation(TeamTask teamTask) {
        Product product = teamTask.getProduct();
        if (product != null) {
            teamTask.setInvoicingType(TeamTaskRepository.INVOICING_TYPE_PACKAGE);
            if (teamTask.getUnitPrice() == null || teamTask.getUnitPrice().compareTo(BigDecimal.ZERO) == 0) {
                teamTask.setUnitPrice(this.computeUnitPrice(teamTask));
            }
        } else {
            TeamTaskCategory teamTaskCategory = teamTask.getTeamTaskCategory();
            if (teamTaskCategory == null) {
                return teamTask;
            }
            teamTask.setInvoicingType(teamTaskCategory.getDefaultInvoicingType());
            teamTask.setProduct(teamTaskCategory.getDefaultProduct());
            product = teamTask.getProduct();
            if (product == null) {
                return teamTask;
            }
            teamTask.setUnitPrice(this.computeUnitPrice(teamTask));
        }
        teamTask.setUnit(product.getSalesUnit() == null ? product.getUnit() : product.getSalesUnit());
        teamTask.setCurrency(product.getSaleCurrency());
        teamTask.setQuantity(teamTask.getBudgetedTime());
        teamTask = this.updateDiscount(teamTask);
        teamTask = this.compute(teamTask);
        return teamTask;
    }

    private BigDecimal computeUnitPrice(TeamTask teamTask) {
        Product product = teamTask.getProduct();
        BigDecimal unitPrice = product.getSalePrice();
        PriceList priceList = ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(teamTask.getProject().getClientPartner(), 1);
        if (priceList == null) {
            return unitPrice;
        }
        PriceListLine priceListLine = this.getPriceListLine(teamTask, priceList, unitPrice);
        Map discounts = this.priceListService.getReplacedPriceAndDiscounts(priceList, priceListLine, unitPrice);
        if (discounts == null) {
            return unitPrice;
        }
        unitPrice = this.priceListService.computeDiscount(unitPrice, ((Integer)discounts.get("discountTypeSelect")).intValue(), (BigDecimal)discounts.get("discountAmount"));
        return unitPrice;
    }

    @Override
    public TeamTask resetTeamTaskValues(TeamTask teamTask) {
        teamTask.setProduct(null);
        teamTask.setInvoicingType(null);
        teamTask.setToInvoice(null);
        teamTask.setQuantity(null);
        teamTask.setUnit(null);
        teamTask.setUnitPrice(null);
        teamTask.setCurrency(null);
        teamTask.setExTaxTotal(null);
        return teamTask;
    }
}

