/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.businessproject.service.TimesheetLineBusinessService;
import com.axelor.apps.businessproject.service.app.AppBusinessProjectService;
import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.db.repo.TimesheetLineRepository;
import com.axelor.apps.hr.service.timesheet.TimesheetLineServiceImpl;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;

public class TimesheetLineProjectServiceImpl
extends TimesheetLineServiceImpl
implements TimesheetLineBusinessService {
    @Inject
    private ProjectRepository projectRepo;
    @Inject
    private TeamTaskRepository teamTaskaRepo;
    @Inject
    private TimesheetLineRepository timesheetLineRepo;

    public TimesheetLine createTimesheetLine(Project project, Product product, User user, LocalDate date, Timesheet timesheet, BigDecimal hours, String comments) {
        TimesheetLine timesheetLine = super.createTimesheetLine(project, product, user, date, timesheet, hours, comments);
        if (((AppBusinessProjectService)Beans.get(AppBusinessProjectService.class)).isApp("business-project") && project != null && (project.getIsInvoicingTimesheet().booleanValue() || project.getParentProject() != null && project.getParentProject().getIsInvoicingTimesheet().booleanValue())) {
            timesheetLine.setToInvoice(Boolean.valueOf(true));
        }
        return timesheetLine;
    }

    @Override
    public TimesheetLine getDefaultToInvoice(TimesheetLine timesheetLine) {
        Project project = timesheetLine.getProject() != null ? (Project)((Object)this.projectRepo.find(timesheetLine.getProject().getId())) : null;
        TeamTask teamTask = timesheetLine.getTeamTask() != null ? (TeamTask)((Object)this.teamTaskaRepo.find(timesheetLine.getTeamTask().getId())) : null;
        Boolean toInvoice = false;
        if (teamTask != null) {
            toInvoice = teamTask.getInvoicingType() == TeamTaskRepository.INVOICING_TYPE_TIME_SPENT;
        } else if (project != null) {
            toInvoice = project.getIsInvoicingTimesheet();
        }
        timesheetLine.setToInvoice(toInvoice);
        return timesheetLine;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public TimesheetLine updateTimesheetLines(TimesheetLine timesheetLine) {
        timesheetLine = this.getDefaultToInvoice(timesheetLine);
        return (TimesheetLine)this.timesheetLineRepo.save((Model)timesheetLine);
    }
}

