/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.PriceListService;
import com.axelor.apps.businessproject.service.TimesheetProjectService;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.service.app.AppHumanResourceService;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.timesheet.TimesheetLineService;
import com.axelor.apps.hr.service.timesheet.TimesheetServiceImpl;
import com.axelor.apps.hr.service.user.UserHrService;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectPlanningTimeRepository;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TimesheetProjectServiceImpl
extends TimesheetServiceImpl
implements TimesheetProjectService {
    @Inject
    public TimesheetProjectServiceImpl(PriceListService priceListService, AppHumanResourceService appHumanResourceService, HRConfigService hrConfigService, TemplateMessageService templateMessageService, ProjectRepository projectRepo, UserRepository userRepo, UserHrService userHrService, TimesheetLineService timesheetLineService, ProjectPlanningTimeRepository projectPlanningTimeRepository, TeamTaskRepository teamTaskRepository) {
        super(priceListService, appHumanResourceService, hrConfigService, templateMessageService, projectRepo, userRepo, userHrService, timesheetLineService, projectPlanningTimeRepository, teamTaskRepository);
    }

    public List<InvoiceLine> createInvoiceLines(Invoice invoice, List<TimesheetLine> timesheetLineList, int priority) throws AxelorException {
        if (!((AppHumanResourceService)Beans.get(AppHumanResourceService.class)).isApp("business-project")) {
            return super.createInvoiceLines(invoice, timesheetLineList, priority);
        }
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        int count = 0;
        DateTimeFormatter ddmmFormat = DateTimeFormatter.ofPattern("dd/MM");
        HashMap<String, Object[]> timeSheetInformationsMap = new HashMap<String, Object[]>();
        boolean consolidate = this.appHumanResourceService.getAppTimesheet().getConsolidateTSLine();
        for (TimesheetLine timesheetLine : timesheetLineList) {
            Object[] tabInformations = new Object[]{timesheetLine.getProduct(), timesheetLine.getUser(), timesheetLine.getDate(), timesheetLine.getDate(), timesheetLine.getDurationForCustomer() != null ? this.computeDurationForCustomer(timesheetLine) : timesheetLine.getHoursDuration(), timesheetLine.getProject()};
            String key = null;
            if (consolidate) {
                key = timesheetLine.getProduct().getId() + "|" + timesheetLine.getUser().getId() + "|" + timesheetLine.getProject().getId();
                if (timeSheetInformationsMap.containsKey(key)) {
                    tabInformations = (Object[])timeSheetInformationsMap.get(key);
                    if (timesheetLine.getDate().compareTo((LocalDate)tabInformations[2]) < 0) {
                        tabInformations[2] = timesheetLine.getDate();
                    } else if (timesheetLine.getDate().compareTo((LocalDate)tabInformations[3]) > 0) {
                        tabInformations[3] = timesheetLine.getDate();
                    }
                    tabInformations[4] = ((BigDecimal)tabInformations[4]).add(timesheetLine.getDurationForCustomer() != null ? this.computeDurationForCustomer(timesheetLine) : timesheetLine.getHoursDuration());
                    continue;
                }
                timeSheetInformationsMap.put(key, tabInformations);
                continue;
            }
            key = String.valueOf(timesheetLine.getId());
            timeSheetInformationsMap.put(key, tabInformations);
        }
        for (Object[] timesheetInformations : timeSheetInformationsMap.values()) {
            String strDate = null;
            Product product = (Product)((Object)timesheetInformations[0]);
            User user = (User)((Object)timesheetInformations[1]);
            LocalDate startDate = (LocalDate)timesheetInformations[2];
            LocalDate endDate = (LocalDate)timesheetInformations[3];
            BigDecimal hoursDuration = (BigDecimal)timesheetInformations[4];
            Project project = (Project)((Object)timesheetInformations[5]);
            PriceList priceList = project.getPriceList();
            if (consolidate) {
                if (startDate != null && endDate != null) {
                    strDate = startDate.format(ddmmFormat) + " - " + endDate.format(ddmmFormat);
                }
            } else if (startDate != null) {
                strDate = startDate.format(ddmmFormat);
            }
            invoiceLineList.addAll(this.createInvoiceLine(invoice, product, user, strDate, hoursDuration, priority * 100 + count, priceList));
            ((InvoiceLine)((Object)invoiceLineList.get(invoiceLineList.size() - 1))).setProject(project);
            ++count;
        }
        return invoiceLineList;
    }

    @Override
    public BigDecimal computeDurationForCustomer(TimesheetLine timesheetLine) throws AxelorException {
        return this.timesheetLineService.computeHoursDuration(timesheetLine.getTimesheet(), timesheetLine.getDurationForCustomer(), true);
    }
}

