/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.businessproject.db.InvoicingProject;
import com.axelor.apps.businessproject.db.repo.InvoicingProjectRepository;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.workflow.WorkflowCancelServiceSupplychainImpl;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;

public class WorkflowCancelServiceProjectImpl
extends WorkflowCancelServiceSupplychainImpl {
    @Inject
    InvoicingProjectRepository invoicingProjectRepo;

    @Inject
    public WorkflowCancelServiceProjectImpl(SaleOrderInvoiceService saleOrderInvoiceService, PurchaseOrderInvoiceService purchaseOrderInvoiceService, SaleOrderRepository saleOrderRepository, PurchaseOrderRepository purchaseOrderRepository) {
        super(saleOrderInvoiceService, purchaseOrderInvoiceService, saleOrderRepository, purchaseOrderRepository);
    }

    @Transactional(rollbackOn={Exception.class})
    public void afterCancel(Invoice invoice) throws AxelorException {
        super.afterCancel(invoice);
        InvoicingProject invoicingProject = (InvoicingProject)((Object)this.invoicingProjectRepo.all().filter("self.invoice = ?", new Object[]{invoice.getId()}).fetchOne());
        if (invoicingProject != null) {
            invoicingProject.setStatusSelect(5);
            this.invoicingProjectRepo.save((Model)((Object)invoicingProject));
        }
    }
}

