/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.businessproject.db.InvoicingProject;
import com.axelor.apps.businessproject.db.repo.InvoicingProjectRepository;
import com.axelor.apps.supplychain.service.IntercoService;
import com.axelor.apps.supplychain.service.workflow.WorkflowValidationServiceSupplychainImpl;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;

public class WorkflowValidationServiceProjectImpl
extends WorkflowValidationServiceSupplychainImpl {
    @Inject
    InvoicingProjectRepository invoicingProjectRepo;

    @Inject
    public WorkflowValidationServiceProjectImpl(IntercoService intercoService) {
        super(intercoService);
    }

    @Transactional(rollbackOn={Exception.class})
    public void afterValidation(Invoice invoice) throws AxelorException {
        super.afterValidation(invoice);
        InvoicingProject invoicingProject = (InvoicingProject)((Object)this.invoicingProjectRepo.all().filter("self.invoice = ?", new Object[]{invoice.getId()}).fetchOne());
        if (invoicingProject != null) {
            invoicingProject.setStatusSelect(3);
            this.invoicingProjectRepo.save((Model)((Object)invoicingProject));
        }
    }
}

