/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service.batch;

import com.axelor.apps.base.db.AppBusinessProject;
import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.apps.businessproject.service.TeamTaskBusinessProjectService;
import com.axelor.apps.businessproject.service.TimesheetLineBusinessService;
import com.axelor.apps.businessproject.service.app.AppBusinessProjectService;
import com.axelor.apps.businessproject.service.batch.ProjectInvoicingAssistantBatchService;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.db.repo.TimesheetLineRepository;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchUpdateTaskService
extends AbstractBatch {
    protected AppBusinessProjectService appBusinessProjectService;
    protected TeamTaskBusinessProjectService teamTaskBusinessProjectService;
    protected TimesheetLineBusinessService timesheetLineBusinessService;
    protected TeamTaskRepository teamTaskRepo;
    protected TimesheetLineRepository timesheetLineRepo;

    @Inject
    public BatchUpdateTaskService(TeamTaskBusinessProjectService teamTaskBusinessProjectService, AppBusinessProjectService appBusinessProjectService, TimesheetLineBusinessService timesheetLineBusinessService, TeamTaskRepository teamTaskRepo, TimesheetLineRepository timesheetLineRepo) {
        this.teamTaskBusinessProjectService = teamTaskBusinessProjectService;
        this.appBusinessProjectService = appBusinessProjectService;
        this.timesheetLineBusinessService = timesheetLineBusinessService;
        this.teamTaskRepo = teamTaskRepo;
        this.timesheetLineRepo = timesheetLineRepo;
    }

    protected void process() {
        List taskList;
        AppBusinessProject appBusinessProject = this.appBusinessProjectService.getAppBusinessProject();
        Map<String, Object> contextValues = null;
        try {
            contextValues = ProjectInvoicingAssistantBatchService.createJsonContext(this.batch);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        ArrayList<Object> updatedTaskList = new ArrayList<Object>();
        String filter = !Strings.isNullOrEmpty((String)appBusinessProject.getExculdeTaskInvoicing()) ? "self.id NOT IN (SELECT id FROM TeamTask WHERE " + appBusinessProject.getExculdeTaskInvoicing() + ")" : "self.id NOT IN (0)";
        Query query = this.teamTaskRepo.all().filter(filter + " AND self.project.isBusinessProject = :isBusinessProject  AND self.project.toInvoice = :invoiceable AND self.toInvoice = :toInvoice").bind("isBusinessProject", (Object)true).bind("invoiceable", (Object)true).bind("toInvoice", (Object)false).order("id");
        int offset = 0;
        while (!(taskList = query.fetch(10, offset)).isEmpty()) {
            this.findBatch();
            offset += taskList.size();
            for (TeamTask teamTask : taskList) {
                try {
                    teamTask = this.teamTaskBusinessProjectService.updateTask(teamTask, appBusinessProject);
                    if (teamTask.getToInvoice().booleanValue()) {
                        --offset;
                        HashMap<String, Long> map = new HashMap<String, Long>();
                        map.put("id", teamTask.getId());
                        updatedTaskList.add(map);
                    }
                    this.updateTimesheetLines(teamTask, contextValues);
                }
                catch (Exception e) {
                    this.incrementAnomaly();
                    TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Task %s"), teamTask.getId()), e), (String)"invoice", (long)this.batch.getId());
                }
            }
            JPA.clear();
        }
        this.findBatch();
        ProjectInvoicingAssistantBatchService.updateJsonObject(this.batch, updatedTaskList, "updatedTaskSet", contextValues);
    }

    private void updateTimesheetLines(TeamTask teamTask, Map<String, Object> contextValues) {
        if (!teamTask.getToInvoice().booleanValue() || teamTask.getInvoicingType() != TeamTaskRepository.INVOICING_TYPE_TIME_SPENT) {
            return;
        }
        ArrayList<Object> updatedTimesheetLineList = new ArrayList<Object>();
        List timesheetLineList = this.timesheetLineRepo.all().filter("self.teamTask.id = :taskId AND self.toInvoice = :toInvoice").bind("taskId", (Object)teamTask.getId()).bind("toInvoice", (Object)false).order("id").fetch();
        for (TimesheetLine timesheetLine : timesheetLineList) {
            try {
                if (!(timesheetLine = this.timesheetLineBusinessService.updateTimesheetLines(timesheetLine)).getToInvoice().booleanValue()) continue;
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put("id", timesheetLine.getId());
                updatedTimesheetLineList.add(map);
            }
            catch (Exception e) {
                this.incrementAnomaly();
                TraceBackService.trace((Throwable)e, (String)"invoice", (long)this.batch.getId());
            }
        }
        ProjectInvoicingAssistantBatchService.updateJsonObject(this.batch, updatedTimesheetLineList, "updatedTimesheetLineSet", contextValues);
    }

    protected void stop() {
        String comment = I18n.get((String)"Tasks updation completed : ");
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }
}

