/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service.projectgenerator;

import com.axelor.apps.businessproject.service.projectgenerator.factory.ProjectGeneratorFactoryAlone;
import com.axelor.apps.businessproject.service.projectgenerator.factory.ProjectGeneratorFactoryPhase;
import com.axelor.apps.businessproject.service.projectgenerator.factory.ProjectGeneratorFactoryTask;
import com.axelor.apps.businessproject.service.projectgenerator.factory.ProjectGeneratorFactoryTaskTemplate;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectGeneratorType;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import java.time.LocalDateTime;

public interface ProjectGeneratorFactory {
    default public Project generate(SaleOrder saleOrder, LocalDateTime localDateTime) throws AxelorException {
        Project project = this.create(saleOrder);
        this.fill(project, saleOrder, localDateTime);
        return project;
    }

    public static ProjectGeneratorFactory getFactory(ProjectGeneratorType type) throws AxelorException {
        switch (type) {
            case PROJECT_ALONE: {
                return (ProjectGeneratorFactory)Beans.get(ProjectGeneratorFactoryAlone.class);
            }
            case TASK_BY_LINE: {
                return (ProjectGeneratorFactory)Beans.get(ProjectGeneratorFactoryTask.class);
            }
            case PHASE_BY_LINE: {
                return (ProjectGeneratorFactory)Beans.get(ProjectGeneratorFactoryPhase.class);
            }
            case TASK_TEMPLATE: {
                return (ProjectGeneratorFactory)Beans.get(ProjectGeneratorFactoryTaskTemplate.class);
            }
        }
        throw new AxelorException(4, I18n.get((String)"Factory not found this type of generator"));
    }

    public Project create(SaleOrder var1) throws AxelorException;

    public ActionView.ActionViewBuilder fill(Project var1, SaleOrder var2, LocalDateTime var3) throws AxelorException;
}

