/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.web;

import com.axelor.apps.businessproject.service.ProjectFolderService;
import com.axelor.apps.project.db.ProjectFolder;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class ProjectFolderController {
    public void printProjectsPlanificationAndCost(ActionRequest request, ActionResponse response) throws AxelorException {
        ProjectFolder projectFolder = (ProjectFolder)request.getContext().asType(ProjectFolder.class);
        try {
            String fileLink = ((ProjectFolderService)Beans.get(ProjectFolderService.class)).printProjectsPlanificationAndCost(projectFolder);
            String title = I18n.get((String)"Project planification and costs");
            response.setView(ActionView.define((String)title).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void printProjectsFinancialReport(ActionRequest request, ActionResponse response) throws AxelorException {
        ProjectFolder projectFolder = (ProjectFolder)request.getContext().asType(ProjectFolder.class);
        try {
            String fileLink = ((ProjectFolderService)Beans.get(ProjectFolderService.class)).printProjectFinancialReport(projectFolder);
            String title = I18n.get((String)"Projects financial report");
            response.setView(ActionView.define((String)title).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }
}

