/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.web;

import com.axelor.apps.businessproject.service.PurchaseOrderLineProjectService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderLineRepository;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.persist.Transactional;
import java.util.List;
import java.util.stream.Collectors;

public class PurchaseOrderLineProjectController {
    public void setProject(ActionRequest request, ActionResponse response) {
        try {
            Project project = (Project)((Object)request.getContext().asType(Project.class));
            project = (Project)((Object)((ProjectRepository)((Object)Beans.get(ProjectRepository.class))).find(project.getId()));
            this.setProject(request, response, project);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    private void setProject(ActionRequest request, ActionResponse response, Project project) {
        List purchaseOrderLineSet = (List)request.getContext().get((Object)"purchaseOrderLineSet");
        if (purchaseOrderLineSet == null || purchaseOrderLineSet.isEmpty()) {
            response.setFlash("Please select lines");
        } else {
            List<Long> lineIds = purchaseOrderLineSet.stream().map(it -> Long.parseLong(it.get("id").toString())).collect(Collectors.toList());
            ((PurchaseOrderLineProjectService)Beans.get(PurchaseOrderLineProjectService.class)).setProject(lineIds, project);
            response.setAttr("$purchaseOrderLineSet", "hidden", (Object)true);
            response.setAttr("addSelectedPOLinesBtn", "hidden", (Object)true);
            response.setAttr("unlinkSelectedPOLinesBtn", "hidden", (Object)true);
            response.setAttr("cancelManagePOLinesBtn", "hidden", (Object)true);
            response.setAttr("purchaseOrderLinePanel", "refresh", (Object)true);
            response.setAttr("purchaseOrderPanel", "refresh", (Object)true);
            response.setAttr("selectNewPOLinesBtn", "readonly", (Object)false);
            response.setAttr("managePOLinesBtn", "readonly", (Object)false);
        }
    }

    public void unsetProject(ActionRequest request, ActionResponse response) {
        try {
            this.setProject(request, response, null);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    @Transactional
    public void updateToInvoice(ActionRequest request, ActionResponse response) {
        PurchaseOrderLineRepository purchaseOrderLineRepository = (PurchaseOrderLineRepository)((Object)Beans.get(PurchaseOrderLineRepository.class));
        try {
            PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)request.getContext().asType(PurchaseOrderLine.class));
            purchaseOrderLine = (PurchaseOrderLine)((Object)purchaseOrderLineRepository.find(purchaseOrderLine.getId()));
            purchaseOrderLine.setToInvoice(purchaseOrderLine.getToInvoice() == false);
            purchaseOrderLineRepository.save((Model)((Object)purchaseOrderLine));
            response.setValue("toInvoice", (Object)purchaseOrderLine.getToInvoice());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

