/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.web;

import com.axelor.apps.businessproject.service.TeamTaskBusinessProjectService;
import com.axelor.apps.project.db.TeamTaskCategory;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;

public class TeamTaskController {
    @Inject
    private TeamTaskBusinessProjectService businessProjectService;

    public void updateDiscount(ActionRequest request, ActionResponse response) {
        TeamTask teamTask = (TeamTask)((Object)request.getContext().asType(TeamTask.class));
        if (teamTask.getProduct() == null || teamTask.getProject() == null) {
            return;
        }
        try {
            teamTask = ((TeamTaskBusinessProjectService)Beans.get(TeamTaskBusinessProjectService.class)).updateDiscount(teamTask);
            response.setValue("discountTypeSelect", (Object)teamTask.getDiscountTypeSelect());
            response.setValue("discountAmount", (Object)teamTask.getDiscountAmount());
            response.setValue("priceDiscounted", (Object)teamTask.getPriceDiscounted());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void compute(ActionRequest request, ActionResponse response) {
        TeamTask teamTask = (TeamTask)((Object)request.getContext().asType(TeamTask.class));
        try {
            teamTask = ((TeamTaskBusinessProjectService)Beans.get(TeamTaskBusinessProjectService.class)).compute(teamTask);
            response.setValue("priceDiscounted", (Object)teamTask.getPriceDiscounted());
            response.setValue("exTaxTotal", (Object)teamTask.getExTaxTotal());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    @Transactional
    public void updateToInvoice(ActionRequest request, ActionResponse response) {
        TeamTaskRepository teamTaskRepository = (TeamTaskRepository)((Object)Beans.get(TeamTaskRepository.class));
        try {
            TeamTask teamTask = (TeamTask)((Object)request.getContext().asType(TeamTask.class));
            teamTask = (TeamTask)((Object)teamTaskRepository.find(teamTask.getId()));
            teamTask.setToInvoice(teamTask.getToInvoice() == false);
            teamTaskRepository.save((Model)((Object)teamTask));
            response.setValue("toInvoice", (Object)teamTask.getToInvoice());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void onChangeCategory(ActionRequest request, ActionResponse response) {
        TeamTask task = (TeamTask)((Object)request.getContext().asType(TeamTask.class));
        TeamTaskCategory teamTaskCategory = task.getTeamTaskCategory();
        task = this.businessProjectService.resetTeamTaskValues(task);
        if (teamTaskCategory != null) {
            task = this.businessProjectService.computeDefaultInformation(task);
        }
        if (task.getInvoicingType() == TeamTaskRepository.INVOICING_TYPE_TIME_SPENT) {
            task.setToInvoice(true);
        }
        response.setValues((Object)task);
    }
}

