/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseRequestLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="PURCHASE_PURCHASE_REQUEST", uniqueConstraints={@UniqueConstraint(columnNames={"purchaseRequestSeq"})}, indexes={@Index(columnList="company"), @Index(columnList="supplier_user"), @Index(columnList="purchase_order"), @Index(columnList="stock_location")})
@Track(fields={@TrackField(name="supplierUser"), @TrackField(name="stockLocation")})
public class PurchaseRequest
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PURCHASE_PURCHASE_REQUEST_SEQ")
    @SequenceGenerator(name="PURCHASE_PURCHASE_REQUEST_SEQ", sequenceName="PURCHASE_PURCHASE_REQUEST_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Supplier")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner supplierUser;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Purchase order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseOrder purchaseOrder;
    @Widget(title="Status", selection="purchase.request.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Purchase orders")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<PurchaseOrder> purchaseOrderSet;
    @Widget(title="Ref.")
    private String purchaseRequestSeq;
    @Widget(title="Purchase Request Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="purchaseRequest", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PurchaseRequestLine> purchaseRequestLineList;
    @Widget(title="Stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Partner getSupplierUser() {
        return this.supplierUser;
    }

    public void setSupplierUser(Partner supplierUser) {
        this.supplierUser = supplierUser;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PurchaseOrder getPurchaseOrder() {
        return this.purchaseOrder;
    }

    public void setPurchaseOrder(PurchaseOrder purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Set<PurchaseOrder> getPurchaseOrderSet() {
        return this.purchaseOrderSet;
    }

    public void setPurchaseOrderSet(Set<PurchaseOrder> purchaseOrderSet) {
        this.purchaseOrderSet = purchaseOrderSet;
    }

    public void addPurchaseOrderSetItem(PurchaseOrder item) {
        if (this.getPurchaseOrderSet() == null) {
            this.setPurchaseOrderSet(new HashSet<PurchaseOrder>());
        }
        this.getPurchaseOrderSet().add(item);
    }

    public void removePurchaseOrderSetItem(PurchaseOrder item) {
        if (this.getPurchaseOrderSet() == null) {
            return;
        }
        this.getPurchaseOrderSet().remove((Object)item);
    }

    public void clearPurchaseOrderSet() {
        if (this.getPurchaseOrderSet() != null) {
            this.getPurchaseOrderSet().clear();
        }
    }

    public String getPurchaseRequestSeq() {
        return this.purchaseRequestSeq;
    }

    public void setPurchaseRequestSeq(String purchaseRequestSeq) {
        this.purchaseRequestSeq = purchaseRequestSeq;
    }

    public List<PurchaseRequestLine> getPurchaseRequestLineList() {
        return this.purchaseRequestLineList;
    }

    public void setPurchaseRequestLineList(List<PurchaseRequestLine> purchaseRequestLineList) {
        this.purchaseRequestLineList = purchaseRequestLineList;
    }

    public void addPurchaseRequestLineListItem(PurchaseRequestLine item) {
        if (this.getPurchaseRequestLineList() == null) {
            this.setPurchaseRequestLineList(new ArrayList<PurchaseRequestLine>());
        }
        this.getPurchaseRequestLineList().add(item);
        item.setPurchaseRequest(this);
    }

    public void removePurchaseRequestLineListItem(PurchaseRequestLine item) {
        if (this.getPurchaseRequestLineList() == null) {
            return;
        }
        this.getPurchaseRequestLineList().remove(item);
    }

    public void clearPurchaseRequestLineList() {
        if (this.getPurchaseRequestLineList() != null) {
            this.getPurchaseRequestLineList().clear();
        }
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PurchaseRequest)) {
            return false;
        }
        PurchaseRequest other = (PurchaseRequest)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("purchaseRequestSeq", (Object)this.getPurchaseRequestSeq()).omitNullValues().toString();
    }
}

