/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.SequenceLettersTypeSelect;
import com.axelor.apps.base.db.SequenceTypeSelect;
import com.axelor.apps.base.db.SequenceVersion;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_SEQUENCE", uniqueConstraints={@UniqueConstraint(columnNames={"company", "code", "prefixe", "suffixe"})}, indexes={@Index(columnList="company"), @Index(columnList="name"), @Index(columnList="code"), @Index(columnList="fullName"), @Index(name="idx_sequence_code_company", columnList="code,company")})
public class Sequence
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_SEQUENCE_SEQ")
    @SequenceGenerator(name="BASE_SEQUENCE_SEQ", sequenceName="BASE_SEQUENCE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Document concerned", selection="sequence.generic.code.select")
    @NotNull
    private String code;
    @Widget(title="Sequence type")
    @Basic
    @Type(type="com.axelor.db.hibernate.type.ValueEnumType")
    @NotNull
    private SequenceTypeSelect sequenceTypeSelect = SequenceTypeSelect.NUMBERS;
    @Widget(title="Uppercase / lowercase")
    @Basic
    @Type(type="com.axelor.db.hibernate.type.ValueEnumType")
    private SequenceLettersTypeSelect sequenceLettersTypeSelect = SequenceLettersTypeSelect.UPPERCASE;
    @Widget(title="Prefix")
    private String prefixe;
    @Widget(title="Suffix")
    private String suffixe;
    @Widget(title="Padding")
    @NotNull
    private Integer padding = 0;
    @Widget(title="Increment")
    @NotNull
    @Min(value=1L)
    private Integer toBeAdded = 0;
    @Widget(title="Yearly reset")
    private Boolean yearlyResetOk = Boolean.FALSE;
    @Widget(title="Monthly reset")
    private Boolean monthlyResetOk = Boolean.FALSE;
    @Widget(title="Versions")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="sequence", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SequenceVersion> sequenceVersionList;
    @Widget(title="Full name")
    @NameColumn
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Sequence() {
    }

    public Sequence(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public SequenceTypeSelect getSequenceTypeSelect() {
        return this.sequenceTypeSelect;
    }

    public void setSequenceTypeSelect(SequenceTypeSelect sequenceTypeSelect) {
        this.sequenceTypeSelect = sequenceTypeSelect;
    }

    public SequenceLettersTypeSelect getSequenceLettersTypeSelect() {
        return this.sequenceLettersTypeSelect;
    }

    public void setSequenceLettersTypeSelect(SequenceLettersTypeSelect sequenceLettersTypeSelect) {
        this.sequenceLettersTypeSelect = sequenceLettersTypeSelect;
    }

    public String getPrefixe() {
        return this.prefixe;
    }

    public void setPrefixe(String prefixe) {
        this.prefixe = prefixe;
    }

    public String getSuffixe() {
        return this.suffixe;
    }

    public void setSuffixe(String suffixe) {
        this.suffixe = suffixe;
    }

    public Integer getPadding() {
        return this.padding == null ? 0 : this.padding;
    }

    public void setPadding(Integer padding) {
        this.padding = padding;
    }

    public Integer getToBeAdded() {
        return this.toBeAdded == null ? 0 : this.toBeAdded;
    }

    public void setToBeAdded(Integer toBeAdded) {
        this.toBeAdded = toBeAdded;
    }

    public Boolean getYearlyResetOk() {
        return this.yearlyResetOk == null ? Boolean.FALSE : this.yearlyResetOk;
    }

    public void setYearlyResetOk(Boolean yearlyResetOk) {
        this.yearlyResetOk = yearlyResetOk;
    }

    public Boolean getMonthlyResetOk() {
        return this.monthlyResetOk == null ? Boolean.FALSE : this.monthlyResetOk;
    }

    public void setMonthlyResetOk(Boolean monthlyResetOk) {
        this.monthlyResetOk = monthlyResetOk;
    }

    public List<SequenceVersion> getSequenceVersionList() {
        return this.sequenceVersionList;
    }

    public void setSequenceVersionList(List<SequenceVersion> sequenceVersionList) {
        this.sequenceVersionList = sequenceVersionList;
    }

    public void addSequenceVersionListItem(SequenceVersion item) {
        if (this.getSequenceVersionList() == null) {
            this.setSequenceVersionList(new ArrayList<SequenceVersion>());
        }
        this.getSequenceVersionList().add(item);
        item.setSequence(this);
    }

    public void removeSequenceVersionListItem(SequenceVersion item) {
        if (this.getSequenceVersionList() == null) {
            return;
        }
        this.getSequenceVersionList().remove(item);
    }

    public void clearSequenceVersionList() {
        if (this.getSequenceVersionList() != null) {
            this.getSequenceVersionList().clear();
        }
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sequence)) {
            return false;
        }
        Sequence other = (Sequence)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("sequenceTypeSelect", (Object)this.getSequenceTypeSelect()).add("sequenceLettersTypeSelect", (Object)this.getSequenceLettersTypeSelect()).add("prefixe", (Object)this.getPrefixe()).add("suffixe", (Object)this.getSuffixe()).add("padding", (Object)this.getPadding()).add("toBeAdded", (Object)this.getToBeAdded()).add("yearlyResetOk", (Object)this.getYearlyResetOk()).add("monthlyResetOk", (Object)this.getMonthlyResetOk()).add("fullName", (Object)this.getFullName()).omitNullValues().toString();
    }
}

