/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SUPPLYCHAIN_MRP_FORECAST", indexes={@Index(columnList="unit"), @Index(columnList="product"), @Index(columnList="stock_location"), @Index(columnList="partner")})
@Track(on={TrackEvent.UPDATE}, fields={@TrackField(name="forecastDate"), @TrackField(name="qty"), @TrackField(name="unit"), @TrackField(name="product"), @TrackField(name="stockLocation"), @TrackField(name="note"), @TrackField(name="partner"), @TrackField(name="statusSelect")})
public class MrpForecast
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_MRP_FORECAST_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_MRP_FORECAST_SEQ", sequenceName="SUPPLYCHAIN_MRP_FORECAST_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Forecast date")
    @NotNull
    private LocalDate forecastDate;
    @Widget(title="Qty")
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Product")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Stock location")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Note", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String note;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Status", readonly=true, selection="supplychain.mrp.forecast.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getForecastDate() {
        return this.forecastDate;
    }

    public void setForecastDate(LocalDate forecastDate) {
        this.forecastDate = forecastDate;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MrpForecast)) {
            return false;
        }
        MrpForecast other = (MrpForecast)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("forecastDate", (Object)this.getForecastDate()).add("qty", (Object)this.getQty()).add("statusSelect", (Object)this.getStatusSelect()).omitNullValues().toString();
    }
}

