/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.supplychain.db.Mrp;
import com.axelor.apps.supplychain.db.MrpLineOrigin;
import com.axelor.apps.supplychain.db.MrpLineType;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SUPPLYCHAIN_MRP_LINE", indexes={@Index(columnList="mrp"), @Index(columnList="stock_location"), @Index(columnList="product"), @Index(columnList="mrp_line_type"), @Index(columnList="partner")})
public class MrpLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_MRP_LINE_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_MRP_LINE_SEQ", sequenceName="SUPPLYCHAIN_MRP_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Mrp")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Mrp mrp;
    @Widget(title="Stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Qty")
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Cumulative qty")
    private BigDecimal cumulativeQty = BigDecimal.ZERO;
    @Widget(title="Type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MrpLineType mrpLineType;
    @Widget(title="Maturity")
    private LocalDate maturityDate;
    @Widget(title="Maximum level")
    private Integer maxLevel = 0;
    @Widget(title="Min qty")
    private BigDecimal minQty = BigDecimal.ZERO;
    @Widget(title="Related to")
    private String relatedToSelectName;
    @Widget(title="Origins")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="mrpLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MrpLineOrigin> mrpLineOriginList;
    @Widget(readonly=true)
    @NotNull
    private Boolean proposalGenerated = Boolean.FALSE;
    @Widget(readonly=true, selection="mrp.line.proposal.ref.select")
    private String proposalSelect;
    @Widget(readonly=true)
    private Long proposalSelectId = 0L;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Company")
    @Transient
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Unit")
    @Transient
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Mrp getMrp() {
        return this.mrp;
    }

    public void setMrp(Mrp mrp) {
        this.mrp = mrp;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public BigDecimal getCumulativeQty() {
        return this.cumulativeQty == null ? BigDecimal.ZERO : this.cumulativeQty;
    }

    public void setCumulativeQty(BigDecimal cumulativeQty) {
        this.cumulativeQty = cumulativeQty;
    }

    public MrpLineType getMrpLineType() {
        return this.mrpLineType;
    }

    public void setMrpLineType(MrpLineType mrpLineType) {
        this.mrpLineType = mrpLineType;
    }

    public LocalDate getMaturityDate() {
        return this.maturityDate;
    }

    public void setMaturityDate(LocalDate maturityDate) {
        this.maturityDate = maturityDate;
    }

    public Integer getMaxLevel() {
        return this.maxLevel == null ? 0 : this.maxLevel;
    }

    public void setMaxLevel(Integer maxLevel) {
        this.maxLevel = maxLevel;
    }

    public BigDecimal getMinQty() {
        return this.minQty == null ? BigDecimal.ZERO : this.minQty;
    }

    public void setMinQty(BigDecimal minQty) {
        this.minQty = minQty;
    }

    public String getRelatedToSelectName() {
        return this.relatedToSelectName;
    }

    public void setRelatedToSelectName(String relatedToSelectName) {
        this.relatedToSelectName = relatedToSelectName;
    }

    public List<MrpLineOrigin> getMrpLineOriginList() {
        return this.mrpLineOriginList;
    }

    public void setMrpLineOriginList(List<MrpLineOrigin> mrpLineOriginList) {
        this.mrpLineOriginList = mrpLineOriginList;
    }

    public void addMrpLineOriginListItem(MrpLineOrigin item) {
        if (this.getMrpLineOriginList() == null) {
            this.setMrpLineOriginList(new ArrayList<MrpLineOrigin>());
        }
        this.getMrpLineOriginList().add(item);
        item.setMrpLine(this);
    }

    public void removeMrpLineOriginListItem(MrpLineOrigin item) {
        if (this.getMrpLineOriginList() == null) {
            return;
        }
        this.getMrpLineOriginList().remove((Object)item);
    }

    public void clearMrpLineOriginList() {
        if (this.getMrpLineOriginList() != null) {
            this.getMrpLineOriginList().clear();
        }
    }

    public Boolean getProposalGenerated() {
        return this.proposalGenerated == null ? Boolean.FALSE : this.proposalGenerated;
    }

    public void setProposalGenerated(Boolean proposalGenerated) {
        this.proposalGenerated = proposalGenerated;
    }

    public String getProposalSelect() {
        return this.proposalSelect;
    }

    public void setProposalSelect(String proposalSelect) {
        this.proposalSelect = proposalSelect;
    }

    public Long getProposalSelectId() {
        return this.proposalSelectId == null ? 0L : this.proposalSelectId;
    }

    public void setProposalSelectId(Long proposalSelectId) {
        this.proposalSelectId = proposalSelectId;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MrpLine)) {
            return false;
        }
        MrpLine other = (MrpLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("qty", (Object)this.getQty()).add("cumulativeQty", (Object)this.getCumulativeQty()).add("maturityDate", (Object)this.getMaturityDate()).add("maxLevel", (Object)this.getMaxLevel()).add("minQty", (Object)this.getMinQty()).add("relatedToSelectName", (Object)this.getRelatedToSelectName()).add("proposalGenerated", (Object)this.getProposalGenerated()).add("proposalSelect", (Object)this.getProposalSelect()).add("proposalSelectId", (Object)this.getProposalSelectId()).omitNullValues().toString();
    }
}

