/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db.repo;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.app.AppService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderManagementRepository;
import com.axelor.apps.supplychain.service.AccountingSituationSupplychainService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import java.math.BigDecimal;

public class SaleOrderSupplychainRepository
extends SaleOrderManagementRepository {
    public SaleOrder copy(SaleOrder entity, boolean deep) {
        SaleOrder copy = super.copy(entity, deep);
        if (!((AppService)Beans.get(AppService.class)).isApp("supplychain")) {
            return copy;
        }
        copy.setShipmentDate(null);
        copy.setDeliveryState(1);
        copy.setAmountInvoiced(null);
        copy.setStockMoveList(null);
        if (copy.getSaleOrderLineList() != null) {
            for (SaleOrderLine saleOrderLine : copy.getSaleOrderLineList()) {
                saleOrderLine.setDeliveryState(null);
                saleOrderLine.setDeliveredQty(null);
                saleOrderLine.setAmountInvoiced(null);
                saleOrderLine.setInvoiced(null);
                saleOrderLine.setInvoicingDate(null);
                saleOrderLine.setIsInvoiceControlled(null);
                saleOrderLine.setReservedQty(BigDecimal.ZERO);
            }
        }
        return copy;
    }

    public void remove(SaleOrder order) {
        Partner partner = order.getClientPartner();
        super.remove((Model)((Object)order));
        try {
            ((AccountingSituationSupplychainService)Beans.get(AccountingSituationSupplychainService.class)).updateUsedCredit(partner);
        }
        catch (AxelorException e) {
            e.printStackTrace();
        }
    }
}

