/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.FixedAsset;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.service.FixedAssetServiceImpl;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class FixedAssetServiceSupplyChainImpl
extends FixedAssetServiceImpl {
    @Inject
    public FixedAssetServiceSupplyChainImpl(MoveLineService moveLineService) {
        super(moveLineService);
    }

    @Transactional
    public List<FixedAsset> createFixedAssets(Invoice invoice) throws AxelorException {
        List fixedAssetList = super.createFixedAssets(invoice);
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return fixedAssetList;
        }
        if (CollectionUtils.isEmpty((Collection)fixedAssetList)) {
            return null;
        }
        StockLocation stockLocation = invoice.getPurchaseOrder() != null ? invoice.getPurchaseOrder().getStockLocation() : null;
        for (FixedAsset fixedAsset : fixedAssetList) {
            PurchaseOrderLine pol = fixedAsset.getInvoiceLine().getPurchaseOrderLine();
            fixedAsset.setStockLocation(stockLocation);
            if (fixedAsset.getInvoiceLine().getIncomingStockMove() == null || !CollectionUtils.isNotEmpty(fixedAsset.getInvoiceLine().getIncomingStockMove().getStockMoveLineList())) continue;
            fixedAsset.setTrackingNumber(fixedAsset.getInvoiceLine().getIncomingStockMove().getStockMoveLineList().stream().filter(l -> pol.equals((Object)l.getPurchaseOrderLine())).findFirst().map(StockMoveLine::getTrackingNumber).orElse(null));
            fixedAsset.setStockLocation(fixedAsset.getInvoiceLine().getIncomingStockMove().getToStockLocation());
        }
        return fixedAssetList;
    }
}

