/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.AccountManagementAccountService;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.invoice.InvoiceLineService;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.TradingNameService;
import com.axelor.apps.base.service.tax.FiscalPositionService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.purchase.service.PurchaseOrderService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.saleorder.SaleOrderComputeService;
import com.axelor.apps.sale.service.saleorder.SaleOrderCreateService;
import com.axelor.apps.sale.service.saleorder.SaleOrderLineService;
import com.axelor.apps.sale.service.saleorder.SaleOrderWorkflowService;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.supplychain.service.IntercoService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class IntercoServiceImpl
implements IntercoService {
    @Override
    @Transactional(rollbackOn={Exception.class})
    public SaleOrder generateIntercoSaleFromPurchase(PurchaseOrder purchaseOrder) throws AxelorException {
        SaleOrderCreateService saleOrderCreateService = (SaleOrderCreateService)Beans.get(SaleOrderCreateService.class);
        SaleOrderComputeService saleOrderComputeService = (SaleOrderComputeService)Beans.get(SaleOrderComputeService.class);
        Company intercoCompany = this.findIntercoCompany(purchaseOrder.getSupplierPartner());
        SaleOrder saleOrder = saleOrderCreateService.createSaleOrder(null, intercoCompany, purchaseOrder.getContactPartner(), purchaseOrder.getCurrency(), purchaseOrder.getDeliveryDate(), null, null, purchaseOrder.getOrderDate(), purchaseOrder.getPriceList(), purchaseOrder.getCompany().getPartner(), null);
        saleOrder.setInAti(purchaseOrder.getInAti());
        saleOrder.setOrderDate(purchaseOrder.getOrderDate());
        PaymentMode intercoPaymentMode = ((PaymentModeService)Beans.get(PaymentModeService.class)).reverseInOut(purchaseOrder.getPaymentMode());
        saleOrder.setPaymentMode(intercoPaymentMode);
        saleOrder.setPaymentCondition(purchaseOrder.getPaymentCondition());
        saleOrder.setDeliveryDate(purchaseOrder.getDeliveryDate());
        saleOrder.setShipmentMode(purchaseOrder.getShipmentMode());
        saleOrder.setFreightCarrierMode(purchaseOrder.getFreightCarrierMode());
        saleOrder.setStockLocation(((StockLocationService)Beans.get(StockLocationService.class)).getPickupDefaultStockLocation(intercoCompany));
        saleOrder.setExpectedRealisationDate(purchaseOrder.getExpectedRealisationDate());
        saleOrder.setAmountToBeSpreadOverTheTimetable(purchaseOrder.getAmountToBeSpreadOverTheTimetable());
        List<PurchaseOrderLine> purchaseOrderLineList = purchaseOrder.getPurchaseOrderLineList();
        if (purchaseOrderLineList != null) {
            for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
                this.createIntercoSaleLineFromPurchaseLine(purchaseOrderLine, saleOrder);
            }
        }
        saleOrder.setPrintingSettings(intercoCompany.getPrintingSettings());
        saleOrderComputeService.computeSaleOrder(saleOrder);
        saleOrder.setCreatedByInterco(true);
        ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).save((Model)((Object)saleOrder));
        if (((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getIntercoSaleOrderCreateFinalized().booleanValue()) {
            ((SaleOrderWorkflowService)Beans.get(SaleOrderWorkflowService.class)).finalizeQuotation(saleOrder);
        }
        purchaseOrder.setExternalReference(saleOrder.getSaleOrderSeq());
        saleOrder.setExternalReference(purchaseOrder.getPurchaseOrderSeq());
        return saleOrder;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public PurchaseOrder generateIntercoPurchaseFromSale(SaleOrder saleOrder) throws AxelorException {
        PurchaseOrderService purchaseOrderService = (PurchaseOrderService)Beans.get(PurchaseOrderService.class);
        Company intercoCompany = this.findIntercoCompany(saleOrder.getClientPartner());
        PurchaseOrder purchaseOrder = new PurchaseOrder();
        purchaseOrder.setCompany(intercoCompany);
        purchaseOrder.setContactPartner(saleOrder.getContactPartner());
        purchaseOrder.setCurrency(saleOrder.getCurrency());
        purchaseOrder.setDeliveryDate(saleOrder.getDeliveryDate());
        purchaseOrder.setOrderDate(saleOrder.getCreationDate());
        purchaseOrder.setPriceList(saleOrder.getPriceList());
        purchaseOrder.setTradingName(saleOrder.getTradingName());
        purchaseOrder.setPurchaseOrderLineList(new ArrayList<PurchaseOrderLine>());
        purchaseOrder.setPrintingSettings(((TradingNameService)Beans.get(TradingNameService.class)).getDefaultPrintingSettings(null, intercoCompany));
        purchaseOrder.setStatusSelect(1);
        purchaseOrder.setSupplierPartner(saleOrder.getCompany().getPartner());
        purchaseOrder.setTradingName(saleOrder.getTradingName());
        purchaseOrder.setInAti(saleOrder.getInAti());
        PaymentMode intercoPaymentMode = ((PaymentModeService)Beans.get(PaymentModeService.class)).reverseInOut(saleOrder.getPaymentMode());
        purchaseOrder.setPaymentMode(intercoPaymentMode);
        purchaseOrder.setPaymentCondition(saleOrder.getPaymentCondition());
        purchaseOrder.setDeliveryDate(saleOrder.getDeliveryDate());
        purchaseOrder.setStockLocation(((StockLocationService)Beans.get(StockLocationService.class)).getDefaultReceiptStockLocation(intercoCompany));
        purchaseOrder.setShipmentMode(saleOrder.getShipmentMode());
        purchaseOrder.setFreightCarrierMode(saleOrder.getFreightCarrierMode());
        purchaseOrder.setExpectedRealisationDate(saleOrder.getExpectedRealisationDate());
        purchaseOrder.setAmountToBeSpreadOverTheTimetable(saleOrder.getAmountToBeSpreadOverTheTimetable());
        List<SaleOrderLine> saleOrderLineList = saleOrder.getSaleOrderLineList();
        if (saleOrderLineList != null) {
            for (SaleOrderLine saleOrderLine : saleOrderLineList) {
                this.createIntercoPurchaseLineFromSaleLine(saleOrderLine, purchaseOrder);
            }
        }
        purchaseOrder.setPrintingSettings(intercoCompany.getPrintingSettings());
        purchaseOrderService.computePurchaseOrder(purchaseOrder);
        purchaseOrder.setCreatedByInterco(true);
        ((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).save((Model)((Object)purchaseOrder));
        if (((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getIntercoPurchaseOrderCreateRequested().booleanValue()) {
            ((PurchaseOrderService)Beans.get(PurchaseOrderService.class)).requestPurchaseOrder(purchaseOrder);
        }
        saleOrder.setExternalReference(purchaseOrder.getPurchaseOrderSeq());
        purchaseOrder.setExternalReference(saleOrder.getSaleOrderSeq());
        return purchaseOrder;
    }

    protected PurchaseOrderLine createIntercoPurchaseLineFromSaleLine(SaleOrderLine saleOrderLine, PurchaseOrder purchaseOrder) throws AxelorException {
        PurchaseOrderLine purchaseOrderLine = ((PurchaseOrderLineService)Beans.get(PurchaseOrderLineService.class)).createPurchaseOrderLine(purchaseOrder, saleOrderLine.getProduct(), saleOrderLine.getProductName(), saleOrderLine.getDescription(), saleOrderLine.getQty(), saleOrderLine.getUnit());
        purchaseOrderLine.setPrice(saleOrderLine.getPrice());
        purchaseOrderLine.setInTaxPrice(saleOrderLine.getInTaxPrice());
        purchaseOrderLine.setExTaxTotal(saleOrderLine.getExTaxTotal());
        purchaseOrderLine.setDiscountTypeSelect(saleOrderLine.getDiscountTypeSelect());
        purchaseOrderLine.setDiscountAmount(saleOrderLine.getDiscountAmount());
        purchaseOrderLine.setEstimatedDelivDate(saleOrderLine.getEstimatedDelivDate());
        BigDecimal priceDiscounted = ((PurchaseOrderLineService)Beans.get(PurchaseOrderLineService.class)).computeDiscount(purchaseOrderLine, purchaseOrder.getInAti());
        purchaseOrderLine.setPriceDiscounted(priceDiscounted);
        purchaseOrderLine.setTaxLine(saleOrderLine.getTaxLine());
        purchaseOrder.addPurchaseOrderLineListItem(purchaseOrderLine);
        return purchaseOrderLine;
    }

    protected SaleOrderLine createIntercoSaleLineFromPurchaseLine(PurchaseOrderLine purchaseOrderLine, SaleOrder saleOrder) {
        SaleOrderLine saleOrderLine = new SaleOrderLine();
        saleOrderLine.setSaleOrder(saleOrder);
        saleOrderLine.setProduct(purchaseOrderLine.getProduct());
        saleOrderLine.setProductName(purchaseOrderLine.getProductName());
        saleOrderLine.setDescription(purchaseOrderLine.getDescription());
        saleOrderLine.setQty(purchaseOrderLine.getQty());
        saleOrderLine.setUnit(purchaseOrderLine.getUnit());
        saleOrderLine.setPrice(purchaseOrderLine.getPrice());
        saleOrderLine.setInTaxPrice(purchaseOrderLine.getInTaxPrice());
        saleOrderLine.setExTaxTotal(purchaseOrderLine.getExTaxTotal());
        saleOrderLine.setDiscountTypeSelect(purchaseOrderLine.getDiscountTypeSelect());
        saleOrderLine.setDiscountAmount(purchaseOrderLine.getDiscountAmount());
        BigDecimal priceDiscounted = ((SaleOrderLineService)Beans.get(SaleOrderLineService.class)).computeDiscount(saleOrderLine, saleOrder.getInAti());
        saleOrderLine.setPriceDiscounted(priceDiscounted);
        saleOrderLine.setEstimatedDelivDate(purchaseOrderLine.getEstimatedDelivDate());
        saleOrderLine.setTaxLine(purchaseOrderLine.getTaxLine());
        saleOrder.addSaleOrderLineListItem(saleOrderLine);
        return saleOrderLine;
    }

    @Override
    public Invoice generateIntercoInvoice(Invoice invoice) throws AxelorException {
        boolean isPurchase;
        int priceListRepositoryType;
        int generatedOperationTypeSelect;
        PartnerService partnerService = (PartnerService)Beans.get(PartnerService.class);
        InvoiceRepository invoiceRepository = (InvoiceRepository)((Object)Beans.get(InvoiceRepository.class));
        InvoiceService invoiceService = (InvoiceService)Beans.get(InvoiceService.class);
        switch (invoice.getOperationTypeSelect()) {
            case 1: {
                generatedOperationTypeSelect = 3;
                priceListRepositoryType = 1;
                isPurchase = false;
                break;
            }
            case 2: {
                generatedOperationTypeSelect = 4;
                priceListRepositoryType = 1;
                isPurchase = false;
                break;
            }
            case 3: {
                generatedOperationTypeSelect = 1;
                priceListRepositoryType = 2;
                isPurchase = true;
                break;
            }
            case 4: {
                generatedOperationTypeSelect = 2;
                priceListRepositoryType = 2;
                isPurchase = true;
                break;
            }
            default: {
                throw new AxelorException(1, I18n.get((String)"Invoice %s type is not filled."), new Object[]{invoice});
            }
        }
        Company intercoCompany = this.findIntercoCompany(invoice.getPartner());
        Partner intercoPartner = invoice.getCompany().getPartner();
        PaymentMode intercoPaymentMode = ((PaymentModeService)Beans.get(PaymentModeService.class)).reverseInOut(invoice.getPaymentMode());
        Address intercoAddress = partnerService.getInvoicingAddress(intercoPartner);
        BankDetails intercoBankDetails = partnerService.getDefaultBankDetails(intercoPartner);
        AccountingSituation accountingSituation = ((AccountingSituationService)Beans.get(AccountingSituationService.class)).getAccountingSituation(intercoPartner, intercoCompany);
        PriceList intercoPriceList = ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(intercoPartner, priceListRepositoryType);
        Invoice intercoInvoice = (Invoice)((Object)invoiceRepository.copy((Model)((Object)invoice), true));
        intercoInvoice.setOperationTypeSelect(generatedOperationTypeSelect);
        intercoInvoice.setCompany(intercoCompany);
        intercoInvoice.setPartner(intercoPartner);
        intercoInvoice.setAddress(intercoAddress);
        intercoInvoice.setAddressStr(((AddressService)Beans.get(AddressService.class)).computeAddressStr(intercoAddress));
        intercoInvoice.setPaymentMode(intercoPaymentMode);
        intercoInvoice.setBankDetails(intercoBankDetails);
        Set invoices = invoiceService.getDefaultAdvancePaymentInvoice(intercoInvoice);
        intercoInvoice.setAdvancePaymentInvoiceSet(invoices);
        if (accountingSituation != null) {
            intercoInvoice.setInvoiceAutomaticMail(accountingSituation.getInvoiceAutomaticMail());
            intercoInvoice.setInvoiceMessageTemplate(accountingSituation.getInvoiceMessageTemplate());
            intercoInvoice.setPfpValidatorUser(accountingSituation.getPfpValidatorUser());
        }
        intercoInvoice.setPriceList(intercoPriceList);
        intercoInvoice.setInvoicesCopySelect(intercoPartner.getInvoicesCopySelect());
        intercoInvoice.setCreatedByInterco(true);
        intercoInvoice.setInterco(false);
        intercoInvoice.setPrintingSettings(intercoCompany.getPrintingSettings());
        if (intercoInvoice.getInvoiceLineList() != null) {
            for (InvoiceLine invoiceLine : intercoInvoice.getInvoiceLineList()) {
                invoiceLine.setInvoice(intercoInvoice);
                this.createIntercoInvoiceLine(invoiceLine, isPurchase);
            }
        }
        invoiceService.compute(intercoInvoice);
        intercoInvoice.setExternalReference(invoice.getInvoiceId());
        intercoInvoice = (Invoice)((Object)invoiceRepository.save((Model)((Object)intercoInvoice)));
        if (((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getIntercoInvoiceCreateValidated().booleanValue()) {
            ((InvoiceService)Beans.get(InvoiceService.class)).validate(intercoInvoice);
        }
        invoice.setExternalReference(intercoInvoice.getInvoiceId());
        return intercoInvoice;
    }

    protected InvoiceLine createIntercoInvoiceLine(InvoiceLine invoiceLine, boolean isPurchase) throws AxelorException {
        AccountManagementAccountService accountManagementAccountService = (AccountManagementAccountService)Beans.get(AccountManagementAccountService.class);
        InvoiceLineService invoiceLineService = (InvoiceLineService)Beans.get(InvoiceLineService.class);
        Invoice intercoInvoice = invoiceLine.getInvoice();
        Partner partner = intercoInvoice.getPartner();
        if (intercoInvoice.getCompany() != null) {
            Account account = accountManagementAccountService.getProductAccount(invoiceLine.getProduct(), intercoInvoice.getCompany(), partner.getFiscalPosition(), isPurchase, false);
            invoiceLine.setAccount(account);
            TaxLine taxLine = invoiceLineService.getTaxLine(intercoInvoice, invoiceLine, isPurchase);
            invoiceLine.setTaxLine(taxLine);
            invoiceLine.setTaxRate(taxLine.getValue());
            invoiceLine.setTaxCode(taxLine.getTax().getCode());
            Tax tax = accountManagementAccountService.getProductTax(invoiceLine.getProduct(), intercoInvoice.getCompany(), null, isPurchase);
            TaxEquiv taxEquiv = ((FiscalPositionService)Beans.get(FiscalPositionService.class)).getTaxEquiv(intercoInvoice.getPartner().getFiscalPosition(), tax);
            invoiceLine.setTaxEquiv(taxEquiv);
            invoiceLine.setCompanyExTaxTotal(invoiceLineService.getCompanyExTaxTotal(invoiceLine.getExTaxTotal(), intercoInvoice));
            invoiceLine.setCompanyInTaxTotal(invoiceLineService.getCompanyExTaxTotal(invoiceLine.getInTaxTotal(), intercoInvoice));
        }
        return invoiceLine;
    }

    @Override
    public Company findIntercoCompany(Partner partner) {
        return (Company)((Object)((CompanyRepository)((Object)Beans.get(CompanyRepository.class))).all().filter("self.partner = ?", new Object[]{partner}).fetchOne());
    }
}

