/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.service.AccountManagementAccountService;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.invoice.InvoiceLineServiceImpl;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.PriceListService;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.service.PurchaseProductService;
import com.axelor.apps.purchase.service.SupplierCatalogService;
import com.axelor.apps.sale.db.PackLine;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.supplychain.service.BudgetSupplychainService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceLineGeneratorSupplyChain;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvoiceLineSupplychainService
extends InvoiceLineServiceImpl {
    protected PurchaseProductService purchaseProductService;
    @Inject
    private AppSupplychainService appSupplychainService;
    @Inject
    private AppSaleService appSaleService;
    @Inject
    protected SupplierCatalogService supplierCatalogService;

    @Inject
    public InvoiceLineSupplychainService(CurrencyService currencyService, PriceListService priceListService, AppAccountService appAccountService, AnalyticMoveLineService analyticMoveLineService, AccountManagementAccountService accountManagementAccountService, PurchaseProductService purchaseProductService) {
        super(currencyService, priceListService, appAccountService, analyticMoveLineService, accountManagementAccountService);
        this.purchaseProductService = purchaseProductService;
    }

    public Unit getUnit(Product product, boolean isPurchase) {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.getUnit(product, isPurchase);
        }
        if (isPurchase) {
            if (product.getPurchasesUnit() != null) {
                return product.getPurchasesUnit();
            }
            return product.getUnit();
        }
        if (product.getSalesUnit() != null) {
            return product.getPurchasesUnit();
        }
        return product.getUnit();
    }

    public Map<String, Object> getDiscount(Invoice invoice, InvoiceLine invoiceLine, BigDecimal price) throws AxelorException {
        Map<String, Object> catalogInfo;
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.getDiscount(invoice, invoiceLine, price);
        }
        HashMap<String, Object> discounts = new HashMap<String, Object>();
        if (invoice.getOperationTypeSelect() < 3 && (catalogInfo = this.updateInfoFromCatalog(invoice, invoiceLine)) != null) {
            if (catalogInfo.get("price") != null) {
                price = (BigDecimal)catalogInfo.get("price");
            }
            discounts.put("productName", catalogInfo.get("productName"));
        }
        discounts.putAll(super.getDiscount(invoice, invoiceLine, price));
        return discounts;
    }

    private Map<String, Object> updateInfoFromCatalog(Invoice invoice, InvoiceLine invoiceLine) throws AxelorException {
        return this.supplierCatalogService.updateInfoFromCatalog(invoiceLine.getProduct(), invoiceLine.getQty(), invoice.getPartner(), invoice.getCurrency(), invoice.getInvoiceDate());
    }

    public Map<String, Object> fillPriceAndAccount(Invoice invoice, InvoiceLine invoiceLine, boolean isPurchase) throws AxelorException {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.fillPriceAndAccount(invoice, invoiceLine, isPurchase);
        }
        try {
            return super.fillPriceAndAccount(invoice, invoiceLine, isPurchase);
        }
        catch (AxelorException e) {
            if (this.checkTaxRequired(invoiceLine, invoiceLine.getPackPriceSelect())) {
                throw e;
            }
            HashMap<String, Object> productInformation = new HashMap<String, Object>();
            productInformation.put("taxLine", null);
            productInformation.put("taxRate", BigDecimal.ZERO);
            productInformation.put("taxCode", null);
            productInformation.put("taxEquiv", null);
            productInformation.put("account", null);
            productInformation.put("discountAmount", BigDecimal.ZERO);
            productInformation.put("discountTypeSelect", 0);
            productInformation.put("price", BigDecimal.ZERO);
            return productInformation;
        }
    }

    public boolean checkTaxRequired(InvoiceLine invoiceLine, Integer packPriceSelect) {
        if (this.appSupplychainService.getAppSupplychain().getActive().booleanValue() && this.appSaleService.getAppSale().getProductPackMgt().booleanValue()) {
            if (invoiceLine.getIsSubLine().booleanValue() && packPriceSelect == 0) {
                return false;
            }
            if (invoiceLine.getTypeSelect() == 2 && packPriceSelect == 1) {
                return false;
            }
        }
        return true;
    }

    public Map<String, Object> fillProductInformation(Invoice invoice, InvoiceLine invoiceLine) throws AxelorException {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.fillProductInformation(invoice, invoiceLine);
        }
        HashMap<String, Object> productInformation = new HashMap<String, Object>();
        boolean isPurchase = InvoiceToolService.isPurchase((Invoice)invoice);
        Integer sequence = invoiceLine.getSequence();
        if (sequence == null) {
            sequence = 0;
        }
        if (sequence == 0 && invoice.getInvoiceLineList() != null) {
            sequence = invoice.getInvoiceLineList().size();
            invoiceLine.setSequence(sequence);
        }
        if (this.appSupplychainService.getAppSupplychain().getActive().booleanValue() && this.appSaleService.getAppSale().getProductPackMgt().booleanValue() && invoiceLine.getProduct() != null && invoiceLine.getProduct().getProductTypeSelect().equals("pack") && invoiceLine.getProduct().getPackLines() != null) {
            ArrayList subLineList = new ArrayList();
            Integer packPriceSelect = invoiceLine.getProduct().getPackPriceSelect();
            invoiceLine.setTypeSelect(2);
            invoiceLine.setPackPriceSelect(packPriceSelect);
            for (PackLine packLine : invoiceLine.getProduct().getPackLines()) {
                InvoiceLine subLine = new InvoiceLine();
                subLine.setProduct(packLine.getProduct());
                subLine.setUnit(this.getUnit(packLine.getProduct(), isPurchase));
                subLine.setProductName(packLine.getProduct().getName());
                subLine.setQty(new BigDecimal(packLine.getQuantity()));
                subLine.setIsSubLine(true);
                subLine.setPackPriceSelect(packPriceSelect);
                String description = null;
                if (isPurchase && this.appAccountService.getAppInvoice().getIsEnabledProductDescriptionCopyForCustomers().booleanValue() || !isPurchase && this.appAccountService.getAppInvoice().getIsEnabledProductDescriptionCopyForSuppliers().booleanValue()) {
                    description = invoiceLine.getProduct().getDescription();
                }
                Map accountInfo = super.fillPriceAndAccount(invoice, subLine, isPurchase);
                subLine.setAccount((Account)accountInfo.get("account"));
                if (packPriceSelect != 0) {
                    subLine.setPrice((BigDecimal)accountInfo.get("price"));
                    subLine.setInTaxPrice((BigDecimal)accountInfo.get("inTaxPrice"));
                    subLine.setPriceDiscounted(this.computeDiscount(subLine, invoice.getInAti()));
                }
                int discountTypeSelect = 0;
                if (accountInfo.get("discountTypeSelect") != null) {
                    discountTypeSelect = (Integer)accountInfo.get("discountTypeSelect");
                }
                BigDecimal qty = new BigDecimal(packLine.getQuantity());
                if (invoiceLine.getQty() != null) {
                    qty = qty.multiply(invoiceLine.getQty()).setScale(2, RoundingMode.HALF_EVEN);
                }
                sequence = sequence + 1;
                InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, subLine.getProduct(), subLine.getProductName(), subLine.getPrice(), subLine.getInTaxPrice(), subLine.getPriceDiscounted(), description, qty, subLine.getUnit(), (TaxLine)accountInfo.get("taxLine"), sequence, (BigDecimal)accountInfo.get("discountAmount"), discountTypeSelect, null, null, false, null, null, null, true, packPriceSelect){

                    public List<InvoiceLine> creates() throws AxelorException {
                        InvoiceLine invoiceLine = this.createInvoiceLine();
                        invoiceLine.setInvoice(null);
                        ArrayList<InvoiceLine> lines = new ArrayList<InvoiceLine>();
                        lines.add(invoiceLine);
                        return lines;
                    }
                };
                subLineList.addAll(invoiceLineGenerator.creates());
            }
            productInformation.put("typeSelect", 2);
            productInformation.put("packPriceSelect", packPriceSelect);
            productInformation.put("subLineList", subLineList);
        } else {
            productInformation.put("typeSelect", 0);
            productInformation.put("packPriceSelect", 0);
            productInformation.put("subLineList", null);
            productInformation.put("totalPack", BigDecimal.ZERO);
            invoiceLine.setTypeSelect(0);
        }
        productInformation.putAll(super.fillProductInformation(invoice, invoiceLine));
        return productInformation;
    }

    public boolean isAccountRequired(InvoiceLine invoiceLine) {
        if (this.appSaleService.getAppSale().getProductPackMgt().booleanValue()) {
            if (invoiceLine.getIsSubLine().booleanValue() && invoiceLine.getPackPriceSelect() == 0) {
                return false;
            }
            if (invoiceLine.getTypeSelect() == 2 && invoiceLine.getPackPriceSelect() == 1) {
                return false;
            }
        }
        return true;
    }

    public void computeBudgetDistributionSumAmount(InvoiceLine invoiceLine, Invoice invoice) {
        List<BudgetDistribution> budgetDistributionList = invoiceLine.getBudgetDistributionList();
        PurchaseOrderLine purchaseOrderLine = invoiceLine.getPurchaseOrderLine();
        BigDecimal budgetDistributionSumAmount = BigDecimal.ZERO;
        LocalDate computeDate = invoice.getInvoiceDate();
        if (purchaseOrderLine != null && purchaseOrderLine.getPurchaseOrder().getOrderDate() != null) {
            computeDate = purchaseOrderLine.getPurchaseOrder().getOrderDate();
        }
        if (budgetDistributionList != null && !budgetDistributionList.isEmpty()) {
            for (BudgetDistribution budgetDistribution : budgetDistributionList) {
                budgetDistributionSumAmount = budgetDistributionSumAmount.add(budgetDistribution.getAmount());
                ((BudgetSupplychainService)((Object)Beans.get(BudgetSupplychainService.class))).computeBudgetDistributionSumAmount(budgetDistribution, computeDate);
            }
        }
        invoiceLine.setBudgetDistributionSumAmount(budgetDistributionSumAmount);
    }
}

