/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.move.MoveToolService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentToolServiceImpl;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.service.saleorder.SaleOrderComputeService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;

public class InvoicePaymentToolServiceSupplychainImpl
extends InvoicePaymentToolServiceImpl {
    @Inject
    public InvoicePaymentToolServiceSupplychainImpl(InvoiceRepository invoiceRepo, MoveToolService moveToolService) {
        super(invoiceRepo, moveToolService);
    }

    @Transactional(rollbackOn={Exception.class})
    public void updateAmountPaid(Invoice invoice) throws AxelorException {
        super.updateAmountPaid(invoice);
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return;
        }
        SaleOrder saleOrder = invoice.getSaleOrder();
        if (saleOrder != null) {
            ((SaleOrderComputeService)Beans.get(SaleOrderComputeService.class))._computeSaleOrder(saleOrder);
        }
    }
}

