/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.SupplierCatalog;
import com.axelor.apps.purchase.db.repo.PurchaseOrderLineRepository;
import com.axelor.apps.purchase.service.app.AppPurchaseService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockRules;
import com.axelor.apps.stock.db.repo.StockLocationLineRepository;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.stock.service.StockRulesService;
import com.axelor.apps.supplychain.db.Mrp;
import com.axelor.apps.supplychain.db.MrpFamily;
import com.axelor.apps.supplychain.db.MrpForecast;
import com.axelor.apps.supplychain.db.MrpLine;
import com.axelor.apps.supplychain.db.MrpLineOrigin;
import com.axelor.apps.supplychain.db.MrpLineType;
import com.axelor.apps.supplychain.db.repo.MrpForecastRepository;
import com.axelor.apps.supplychain.db.repo.MrpLineRepository;
import com.axelor.apps.supplychain.db.repo.MrpLineTypeRepository;
import com.axelor.apps.supplychain.db.repo.MrpRepository;
import com.axelor.apps.supplychain.service.MrpLineService;
import com.axelor.apps.supplychain.service.MrpService;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaStore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrpServiceImpl
implements MrpService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MrpRepository mrpRepository;
    protected StockLocationRepository stockLocationRepository;
    protected ProductRepository productRepository;
    protected StockLocationLineRepository stockLocationLineRepository;
    protected MrpLineTypeRepository mrpLineTypeRepository;
    protected PurchaseOrderLineRepository purchaseOrderLineRepository;
    protected SaleOrderLineRepository saleOrderLineRepository;
    protected MrpLineRepository mrpLineRepository;
    protected StockRulesService stockRulesService;
    protected MrpLineService mrpLineService;
    protected MrpForecastRepository mrpForecastRepository;
    protected StockLocationService stockLocationService;
    protected AppBaseService appBaseService;
    protected List<StockLocation> stockLocationList;
    protected Map<Long, Integer> productMap;
    protected Mrp mrp;
    protected LocalDate today;

    @Inject
    public MrpServiceImpl(AppBaseService appBaseService, MrpRepository mrpRepository, StockLocationRepository stockLocationRepository, ProductRepository productRepository, StockLocationLineRepository stockLocationLineRepository, MrpLineTypeRepository mrpLineTypeRepository, PurchaseOrderLineRepository purchaseOrderLineRepository, SaleOrderLineRepository saleOrderLineRepository, MrpLineRepository mrpLineRepository, StockRulesService stockRulesService, MrpLineService mrpLineService, MrpForecastRepository mrpForecastRepository, StockLocationService stockLocationService) {
        this.mrpRepository = mrpRepository;
        this.stockLocationRepository = stockLocationRepository;
        this.productRepository = productRepository;
        this.stockLocationLineRepository = stockLocationLineRepository;
        this.mrpLineTypeRepository = mrpLineTypeRepository;
        this.purchaseOrderLineRepository = purchaseOrderLineRepository;
        this.saleOrderLineRepository = saleOrderLineRepository;
        this.mrpLineRepository = mrpLineRepository;
        this.stockRulesService = stockRulesService;
        this.mrpLineService = mrpLineService;
        this.mrpForecastRepository = mrpForecastRepository;
        this.appBaseService = appBaseService;
        this.stockLocationService = stockLocationService;
    }

    @Override
    public void runCalculation(Mrp mrp) throws AxelorException {
        this.reset(mrp);
        this.startMrp((Mrp)((Object)this.mrpRepository.find(mrp.getId())));
        this.completeMrp((Mrp)((Object)this.mrpRepository.find(mrp.getId())));
        this.doCalulation((Mrp)((Object)this.mrpRepository.find(mrp.getId())));
        this.finish((Mrp)((Object)this.mrpRepository.find(mrp.getId())));
    }

    @Transactional
    protected void startMrp(Mrp mrp) {
        mrp.setStartDateTime(this.appBaseService.getTodayDateTime().toLocalDateTime());
        this.log.debug("Start MRP");
        mrp.setStatusSelect(1);
        this.today = this.appBaseService.getTodayDate();
        this.mrpRepository.save((Model)((Object)mrp));
    }

    @Override
    @Transactional
    public void reset(Mrp mrp) {
        this.mrpLineRepository.all().filter("self.mrp.id = ?1", new Object[]{mrp.getId()}).remove();
        mrp.setStatusSelect(0);
        this.mrpRepository.save((Model)((Object)mrp));
    }

    protected void completeMrp(Mrp mrp) throws AxelorException {
        this.log.debug("Complete MRP");
        this.mrp = mrp;
        List slList = this.stockLocationService.getAllLocationAndSubLocation(mrp.getStockLocation(), false).stream().filter(x -> x.getIsNotInMrp() == false).collect(Collectors.toList());
        this.stockLocationList = slList;
        this.assignProductAndLevel(this.getProductList());
        if (this.stockLocationList.isEmpty()) {
            throw new AxelorException(Mrp.class, 3, I18n.get((String)"No stock location valid. Please uncheck the chosen stock location 'is not in MRP'."));
        }
        this.createAvailableStockMrpLines();
        this.createPurchaseMrpLines();
        this.createSaleOrderMrpLines();
        this.createSaleForecastMrpLines();
    }

    protected void doCalulation(Mrp mrp) throws AxelorException {
        this.log.debug("Do calculation");
        this.mrp = mrp;
        this.checkInsufficientCumulativeQty();
    }

    @Transactional
    protected void finish(Mrp mrp) {
        this.log.debug("Finish MRP");
        mrp.setStatusSelect(2);
        mrp.setEndDateTime(this.appBaseService.getTodayDateTime().toLocalDateTime());
        this.mrpRepository.save((Model)((Object)mrp));
    }

    protected void checkInsufficientCumulativeQty() throws AxelorException {
        for (int level = 0; level <= this.getMaxLevel(); ++level) {
            for (Product product : this.getProductList(level)) {
                this.checkInsufficientCumulativeQty(product, true);
            }
        }
    }

    protected List<Product> getProductList(int level) {
        ArrayList productList = Lists.newArrayList();
        for (Long productId : this.productMap.keySet()) {
            if (this.productMap.get(productId) != level) continue;
            productList.add(this.productRepository.find(productId));
        }
        return productList;
    }

    protected int getMaxLevel() {
        int maxLevel = 0;
        for (int level : this.productMap.values()) {
            if (level <= maxLevel) continue;
            maxLevel = level;
        }
        return maxLevel;
    }

    protected void checkInsufficientCumulativeQty(Product product, boolean firstPass) throws AxelorException {
        boolean doASecondPass = false;
        this.computeCumulativeQty((Product)((Object)this.productRepository.find(product.getId())));
        JPA.clear();
        List mrpLineList = this.mrpLineRepository.all().filter("self.mrp.id = ?1 AND self.product.id = ?2", new Object[]{this.mrp.getId(), product.getId()}).order("maturityDate").order("mrpLineType.typeSelect").order("mrpLineType.sequence").order("id").fetch();
        for (MrpLine mrpLine : mrpLineList) {
            doASecondPass = this.checkInsufficientCumulativeQty((MrpLine)((Object)this.mrpLineRepository.find(mrpLine.getId())), (Product)((Object)this.productRepository.find(product.getId())), firstPass);
            JPA.clear();
            if (!doASecondPass) continue;
            break;
        }
        if (doASecondPass) {
            this.checkInsufficientCumulativeQty(product, false);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected boolean checkInsufficientCumulativeQty(MrpLine mrpLine, Product product, boolean firstPass) throws AxelorException {
        BigDecimal cumulativeQty = mrpLine.getCumulativeQty();
        MrpLineType mrpLineType = mrpLine.getMrpLineType();
        boolean isProposalElement = this.isProposalElement(mrpLineType);
        BigDecimal minQty = mrpLine.getMinQty();
        if ((mrpLine.getMrpLineType().getElementSelect() != 1 && (!isProposalElement || mrpLineType.getTypeSelect() == 2) || mrpLine.getMrpLineType().getElementSelect() == 1 && firstPass) && cumulativeQty.compareTo(mrpLine.getMinQty()) < 0) {
            this.log.debug("Cumulative qty ({} < {}) is insufficient for product ({}) at the maturity date ({})", new Object[]{cumulativeQty, minQty, product.getFullName(), mrpLine.getMaturityDate()});
            BigDecimal reorderQty = minQty.subtract(cumulativeQty);
            StockRules stockRules = this.stockRulesService.getStockRules(product, mrpLine.getStockLocation(), 2, 1);
            if (stockRules != null) {
                reorderQty = reorderQty.max(stockRules.getReOrderQty());
            }
            MrpLineType mrpLineTypeProposal = this.getMrpLineTypeForProposal(stockRules, product);
            this.createProposalMrpLine(mrpLine.getMrp(), product, mrpLineTypeProposal, reorderQty, mrpLine.getStockLocation(), mrpLine.getMaturityDate(), mrpLine.getMrpLineOriginList(), mrpLine.getRelatedToSelectName());
            return true;
        }
        return false;
    }

    public MrpLine getPreviousProposalMrpLine(Product product, MrpLineType mrpLineType, StockLocation stockLocation, LocalDate maturityDate) {
        LocalDate startPeriodDate = maturityDate;
        MrpFamily mrpFamily = product.getMrpFamily();
        if (mrpFamily != null) {
            if (mrpFamily.getDayNb() == 0) {
                return null;
            }
            startPeriodDate = maturityDate.minusDays(mrpFamily.getDayNb().intValue());
        }
        return (MrpLine)((Object)this.mrpLineRepository.all().filter("self.mrp.id = ?1 AND self.product = ?2 AND self.mrpLineType = ?3 AND self.stockLocation = ?4 AND self.maturityDate > ?5 AND self.maturityDate <= ?6", new Object[]{this.mrp.getId(), product, mrpLineType, stockLocation, startPeriodDate, maturityDate}).fetchOne());
    }

    @Transactional(rollbackOn={Exception.class})
    protected void createProposalMrpLine(Mrp mrp, Product product, MrpLineType mrpLineType, BigDecimal reorderQty, StockLocation stockLocation, LocalDate maturityDate, List<MrpLineOrigin> mrpLineOriginList, String relatedToSelectName) throws AxelorException {
        MrpLine mrpLine;
        if (mrpLineType.getElementSelect() == 5) {
            maturityDate = maturityDate.minusDays(product.getSupplierDeliveryTime().intValue());
            reorderQty = reorderQty.max(this.getSupplierCatalogMinQty(product));
        }
        if (maturityDate.isBefore(this.today)) {
            maturityDate = this.today;
        }
        if ((mrpLine = this.getPreviousProposalMrpLine(product, mrpLineType, stockLocation, maturityDate)) != null) {
            if (mrpLineType.getTypeSelect() == 2) {
                reorderQty = reorderQty.negate();
            }
            mrpLine.setQty(mrpLine.getQty().add(reorderQty));
            mrpLine.setRelatedToSelectName(null);
        } else {
            MrpLine createdmrpLine = this.createMrpLine(mrp, product, mrpLineType, reorderQty, maturityDate, BigDecimal.ZERO, stockLocation, null);
            if (createdmrpLine != null) {
                mrpLine = (MrpLine)((Object)this.mrpLineRepository.save((Model)((Object)createdmrpLine)));
            }
            mrpLine.setRelatedToSelectName(relatedToSelectName);
        }
        this.copyMrpLineOrigins(mrpLine, mrpLineOriginList);
    }

    protected BigDecimal getSupplierCatalogMinQty(Product product) {
        Partner supplierPartner = product.getDefaultSupplierPartner();
        if (supplierPartner != null && ((AppPurchaseService)Beans.get(AppPurchaseService.class)).getAppPurchase().getManageSupplierCatalog().booleanValue()) {
            for (SupplierCatalog supplierCatalog : product.getSupplierCatalogList()) {
                if (!supplierCatalog.getSupplierPartner().equals((Object)supplierPartner)) continue;
                return supplierCatalog.getMinQty();
            }
        }
        return BigDecimal.ZERO;
    }

    protected MrpLineType getMrpLineTypeForProposal(StockRules stockRules, Product product) throws AxelorException {
        return this.getMrpLineType(5);
    }

    protected void consolidateMrp() {
        List mrpLineList = this.mrpLineRepository.all().filter("self.mrp.id = ?1", new Object[]{this.mrp.getId()}).order("product.code").order("maturityDate").order("mrpLineType.typeSelect").order("mrpLineType.sequence").order("id").fetch();
        HashMap map = Maps.newHashMap();
        MrpLine consolidateMrpLine = null;
        ArrayList<Object> keys = new ArrayList<Object>();
        for (MrpLine mrpLine : mrpLineList) {
            MrpLineType mrpLineType = mrpLine.getMrpLineType();
            keys.clear();
            keys.add((Object)mrpLineType);
            keys.add((Object)mrpLine.getProduct());
            keys.add(mrpLine.getMaturityDate());
            keys.add((Object)mrpLine.getStockLocation());
            if (map.containsKey(keys)) {
                consolidateMrpLine = (MrpLine)((Object)map.get(keys));
                consolidateMrpLine.setQty(consolidateMrpLine.getQty().add(mrpLine.getQty()));
                consolidateMrpLine.setCumulativeQty(consolidateMrpLine.getCumulativeQty().add(mrpLine.getCumulativeQty()));
                this.mrpLineRepository.remove((Model)((Object)mrpLine));
                continue;
            }
            map.put(keys, mrpLine);
        }
    }

    protected boolean isProposalElement(MrpLineType mrpLineType) {
        return mrpLineType.getElementSelect() == 5;
    }

    protected void computeCumulativeQty() {
        for (Long productId : this.productMap.keySet()) {
            this.computeCumulativeQty((Product)((Object)this.productRepository.find(productId)));
        }
    }

    @Transactional
    protected void computeCumulativeQty(Product product) {
        List mrpLineList = this.mrpLineRepository.all().filter("self.mrp.id = ?1 AND self.product.id = ?2", new Object[]{this.mrp.getId(), product.getId()}).order("maturityDate").order("mrpLineType.typeSelect").order("mrpLineType.sequence").order("id").fetch();
        BigDecimal previousCumulativeQty = BigDecimal.ZERO;
        for (MrpLine mrpLine : mrpLineList) {
            mrpLine.setCumulativeQty(previousCumulativeQty.add(mrpLine.getQty()));
            previousCumulativeQty = mrpLine.getCumulativeQty();
            this.log.debug("Cumulative qty is ({}) for product ({}) and move ({}) at the maturity date ({})", new Object[]{previousCumulativeQty, mrpLine.getProduct().getFullName(), mrpLine.getMrpLineType().getName(), mrpLine.getMaturityDate()});
        }
    }

    protected void createPurchaseMrpLines() throws AxelorException {
        MrpLineType purchaseOrderMrpLineType = this.getMrpLineType(2);
        String statusSelect = purchaseOrderMrpLineType.getStatusSelect();
        List statusList = StringTool.getIntegerList((String)statusSelect);
        if (statusList.isEmpty()) {
            statusList.add(3);
        }
        List purchaseOrderLineList = this.purchaseOrderLineRepository.all().filter("self.product.id in (?1) AND self.purchaseOrder.stockLocation in (?2) AND self.receiptState != ?3 AND self.purchaseOrder.statusSelect IN (?4)", new Object[]{this.productMap.keySet(), this.stockLocationList, 3, statusList}).fetch();
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
            this.createPurchaseMrpLines((Mrp)((Object)this.mrpRepository.find(this.mrp.getId())), (PurchaseOrderLine)((Object)this.purchaseOrderLineRepository.find(purchaseOrderLine.getId())), (MrpLineType)((Object)this.mrpLineTypeRepository.find(purchaseOrderMrpLineType.getId())));
            JPA.clear();
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected void createPurchaseMrpLines(Mrp mrp, PurchaseOrderLine purchaseOrderLine, MrpLineType purchaseOrderMrpLineType) throws AxelorException {
        PurchaseOrder purchaseOrder = purchaseOrderLine.getPurchaseOrder();
        LocalDate maturityDate = purchaseOrderLine.getEstimatedDelivDate();
        if (maturityDate == null) {
            maturityDate = purchaseOrder.getDeliveryDate();
        }
        if (this.isBeforeEndDate(maturityDate = this.computeMaturityDate(maturityDate, purchaseOrderMrpLineType))) {
            MrpLine mrpLine;
            Unit unit = purchaseOrderLine.getProduct().getUnit();
            BigDecimal qty = purchaseOrderLine.getQty().subtract(purchaseOrderLine.getReceivedQty());
            if (!unit.equals((Object)purchaseOrderLine.getUnit())) {
                qty = ((UnitConversionService)Beans.get(UnitConversionService.class)).convert(purchaseOrderLine.getUnit(), unit, qty, qty.scale(), purchaseOrderLine.getProduct());
            }
            if ((mrpLine = this.createMrpLine(mrp, purchaseOrderLine.getProduct(), purchaseOrderMrpLineType, qty, maturityDate, BigDecimal.ZERO, purchaseOrder.getStockLocation(), (Model)((Object)purchaseOrderLine))) != null) {
                this.mrpLineRepository.save((Model)((Object)mrpLine));
            }
        }
    }

    protected void createSaleOrderMrpLines() throws AxelorException {
        MrpLineType saleOrderMrpLineType = this.getMrpLineType(3);
        String statusSelect = saleOrderMrpLineType.getStatusSelect();
        List statusList = StringTool.getIntegerList((String)statusSelect);
        ArrayList<SaleOrderLine> saleOrderLineList = new ArrayList<SaleOrderLine>();
        this.mrp = (Mrp)((Object)this.mrpRepository.find(this.mrp.getId()));
        if (this.mrp.getSaleOrderLineSet().isEmpty()) {
            saleOrderLineList.addAll(this.saleOrderLineRepository.all().filter("self.product.id in (?1) AND self.saleOrder.stockLocation in (?2) AND self.deliveryState != ?3 AND self.saleOrder.statusSelect IN (?4)", new Object[]{this.productMap.keySet(), this.stockLocationList, 3, statusList}).fetch());
        } else {
            saleOrderLineList.addAll(this.mrp.getSaleOrderLineSet());
        }
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            this.createSaleOrderMrpLines((Mrp)((Object)this.mrpRepository.find(this.mrp.getId())), (SaleOrderLine)((Object)this.saleOrderLineRepository.find(saleOrderLine.getId())), (MrpLineType)((Object)this.mrpLineTypeRepository.find(saleOrderMrpLineType.getId())), statusList);
            JPA.clear();
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected void createSaleOrderMrpLines(Mrp mrp, SaleOrderLine saleOrderLine, MrpLineType saleOrderMrpLineType, List<Integer> statusList) throws AxelorException {
        SaleOrder saleOrder = saleOrderLine.getSaleOrder();
        if (!this.stockLocationList.contains((Object)saleOrder.getStockLocation())) {
            return;
        }
        if (!statusList.contains(saleOrder.getStatusSelect())) {
            return;
        }
        if (saleOrderLine.getDeliveryState() == 3) {
            return;
        }
        LocalDate maturityDate = saleOrderLine.getEstimatedDelivDate();
        if (maturityDate == null) {
            maturityDate = saleOrder.getDeliveryDate();
        }
        if (this.isBeforeEndDate(maturityDate = this.computeMaturityDate(maturityDate, saleOrderMrpLineType))) {
            MrpLine mrpLine;
            Unit unit = saleOrderLine.getProduct().getUnit();
            BigDecimal qty = saleOrderLine.getQty().subtract(saleOrderLine.getDeliveredQty());
            if (!unit.equals((Object)saleOrderLine.getUnit())) {
                qty = ((UnitConversionService)Beans.get(UnitConversionService.class)).convert(saleOrderLine.getUnit(), unit, qty, saleOrderLine.getQty().scale(), saleOrderLine.getProduct());
            }
            if ((mrpLine = this.createMrpLine(mrp, saleOrderLine.getProduct(), saleOrderMrpLineType, qty, maturityDate, BigDecimal.ZERO, saleOrder.getStockLocation(), (Model)((Object)saleOrderLine))) != null) {
                this.mrpLineRepository.save((Model)((Object)mrpLine));
            }
        }
    }

    protected void createSaleForecastMrpLines() throws AxelorException {
        MrpLineType saleForecastMrpLineType = this.getMrpLineType(4);
        ArrayList<MrpForecast> mrpForecastList = new ArrayList<MrpForecast>();
        this.mrp = (Mrp)((Object)this.mrpRepository.find(this.mrp.getId()));
        if (this.mrp.getMrpForecastSet().isEmpty()) {
            mrpForecastList.addAll(this.mrpForecastRepository.all().filter("self.product.id in (?1) AND self.stockLocation in (?2) AND self.forecastDate >= ?3 AND self.statusSelect = ?4", new Object[]{this.productMap.keySet(), this.stockLocationList, this.today, 2}).fetch());
        } else {
            mrpForecastList.addAll(this.mrp.getMrpForecastSet());
        }
        for (MrpForecast mrpForecast : mrpForecastList) {
            this.createSaleForecastMrpLines((Mrp)((Object)this.mrpRepository.find(this.mrp.getId())), (MrpForecast)((Object)this.mrpForecastRepository.find(mrpForecast.getId())), (MrpLineType)((Object)this.mrpLineTypeRepository.find(saleForecastMrpLineType.getId())));
            JPA.clear();
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected void createSaleForecastMrpLines(Mrp mrp, MrpForecast mrpForecast, MrpLineType saleForecastMrpLineType) throws AxelorException {
        LocalDate maturityDate = mrpForecast.getForecastDate();
        if (maturityDate != null && !maturityDate.isBefore(this.today) && this.isBeforeEndDate(maturityDate)) {
            MrpLine mrpLine;
            Unit unit = mrpForecast.getProduct().getUnit();
            BigDecimal qty = mrpForecast.getQty();
            if (!unit.equals((Object)mrpForecast.getUnit())) {
                qty = ((UnitConversionService)Beans.get(UnitConversionService.class)).convert(mrpForecast.getUnit(), unit, qty, qty.scale(), mrpForecast.getProduct());
            }
            if ((mrpLine = this.createMrpLine(mrp, mrpForecast.getProduct(), saleForecastMrpLineType, qty, maturityDate, BigDecimal.ZERO, mrpForecast.getStockLocation(), (Model)((Object)mrpForecast))) != null) {
                this.mrpLineRepository.save((Model)((Object)mrpLine));
            }
        }
    }

    protected LocalDate computeMaturityDate(LocalDate maturityDate, MrpLineType mrpLineType) {
        if (maturityDate != null && maturityDate.isBefore(this.today) || maturityDate == null && mrpLineType.getIncludeElementWithoutDate().booleanValue()) {
            maturityDate = this.today;
        }
        return maturityDate;
    }

    public boolean isBeforeEndDate(LocalDate maturityDate) {
        return maturityDate != null && (this.mrp.getEndDate() == null || !maturityDate.isAfter(this.mrp.getEndDate()));
    }

    protected void createAvailableStockMrpLines() throws AxelorException {
        MrpLineType availableStockMrpLineType = this.getMrpLineType(1);
        for (Long productId : this.productMap.keySet()) {
            for (StockLocation stockLocation : this.stockLocationList) {
                this.createAvailableStockMrpLine((Mrp)((Object)this.mrpRepository.find(this.mrp.getId())), (Product)((Object)this.productRepository.find(productId)), (StockLocation)((Object)this.stockLocationRepository.find(stockLocation.getId())), (MrpLineType)((Object)this.mrpLineTypeRepository.find(availableStockMrpLineType.getId())));
            }
            JPA.clear();
        }
    }

    @Transactional
    protected MrpLine createAvailableStockMrpLine(Mrp mrp, Product product, StockLocation stockLocation, MrpLineType availableStockMrpLineType) {
        BigDecimal qty = BigDecimal.ZERO;
        StockLocationLine stockLocationLine = this.getStockLocationLine(product, stockLocation);
        if (stockLocationLine != null) {
            qty = stockLocationLine.getCurrentQty();
        }
        return (MrpLine)((Object)this.mrpLineRepository.save((Model)((Object)this.createMrpLine(mrp, product, availableStockMrpLineType, qty, this.today, qty, stockLocation, null))));
    }

    protected MrpLineType getMrpLineType(int elementSelect) throws AxelorException {
        MrpLineType mrpLineType = (MrpLineType)((Object)this.mrpLineTypeRepository.all().filter("self.elementSelect = ?1", new Object[]{elementSelect}).fetchOne());
        if (mrpLineType != null) {
            return mrpLineType;
        }
        throw new AxelorException(4, I18n.get((String)"No move type found for element : %s"), new Object[]{I18n.get((String)MetaStore.getSelectionItem((String)"supplychain.mrp.line.element.select", (String)Integer.toString(elementSelect)).getTitle())});
    }

    protected StockLocationLine getStockLocationLine(Product product, StockLocation stockLocation) {
        return (StockLocationLine)((Object)this.stockLocationLineRepository.all().filter("self.stockLocation.id = ?1 AND self.product.id = ?2", new Object[]{stockLocation.getId(), product.getId()}).fetchOne());
    }

    protected Set<Product> getProductList() throws AxelorException {
        HashSet productSet = Sets.newHashSet();
        if (this.mrp.getProductSet() != null && !this.mrp.getProductSet().isEmpty()) {
            productSet.addAll(this.mrp.getProductSet());
        }
        if (this.mrp.getProductCategorySet() != null && !this.mrp.getProductCategorySet().isEmpty()) {
            productSet.addAll(this.productRepository.all().filter("self.productCategory in (?1) AND self.productTypeSelect = ?2 AND self.excludeFromMrp = false AND self.stockManaged = true", new Object[]{this.mrp.getProductCategorySet(), "storable"}).fetch());
        }
        if (this.mrp.getProductFamilySet() != null && !this.mrp.getProductFamilySet().isEmpty()) {
            productSet.addAll(this.productRepository.all().filter("self.productFamily in (?1) AND self.productTypeSelect = ?2 AND self.excludeFromMrp = false AND self.stockManaged = true", new Object[]{this.mrp.getProductFamilySet(), "storable"}).fetch());
        }
        if (this.mrp.getSaleOrderLineSet() != null) {
            for (SaleOrderLine saleOrderLine : this.mrp.getSaleOrderLineSet()) {
                productSet.add(saleOrderLine.getProduct());
            }
        }
        if (this.mrp.getMrpForecastSet() != null) {
            for (MrpForecast mrpForecast : this.mrp.getMrpForecastSet()) {
                productSet.add(mrpForecast.getProduct());
            }
        }
        if (productSet.isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"Please select an element to run calculation"));
        }
        return productSet;
    }

    public boolean isMrpProduct(Product product) {
        return product != null && product.getExcludeFromMrp() == false && product.getProductTypeSelect().equals("storable");
    }

    protected void assignProductAndLevel(Set<Product> productList) {
        this.productMap = Maps.newHashMap();
        for (Product product : productList) {
            this.assignProductAndLevel(product);
        }
    }

    protected void assignProductAndLevel(Product product) {
        this.log.debug("Add of the product : {}", (Object)product.getFullName());
        this.productMap.put(product.getId(), 0);
    }

    protected MrpLine createMrpLine(Mrp mrp, Product product, MrpLineType mrpLineType, BigDecimal qty, LocalDate maturityDate, BigDecimal cumulativeQty, StockLocation stockLocation, Model model) {
        if (this.productMap != null && product != null) {
            return this.mrpLineService.createMrpLine(mrp, product, this.productMap.get(product.getId()), mrpLineType, qty, maturityDate, cumulativeQty, stockLocation, model);
        }
        return null;
    }

    protected void copyMrpLineOrigins(MrpLine mrpLine, List<MrpLineOrigin> mrpLineOriginList) {
        if (mrpLineOriginList != null) {
            for (MrpLineOrigin mrpLineOrigin : mrpLineOriginList) {
                mrpLine.addMrpLineOriginListItem(this.mrpLineService.copyMrpLineOrigin(mrpLineOrigin));
            }
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void generateProposals(Mrp mrp, boolean isProposalPerSupplier) throws AxelorException {
        HashMap<Pair<Partner, LocalDate>, PurchaseOrder> purchaseOrders = new HashMap<Pair<Partner, LocalDate>, PurchaseOrder>();
        HashMap<Partner, PurchaseOrder> purchaseOrdersPerSupplier = new HashMap<Partner, PurchaseOrder>();
        List mrpLineList = this.mrpLineRepository.all().filter("self.mrp.id = ?1", new Object[]{mrp.getId()}).order("maturityDate").fetch();
        for (MrpLine mrpLine : mrpLineList) {
            if (mrpLine.getProposalGenerated().booleanValue()) continue;
            this.mrpLineService.generateProposal(mrpLine, purchaseOrders, purchaseOrdersPerSupplier, isProposalPerSupplier);
        }
    }

    @Override
    public LocalDate findMrpEndDate(Mrp mrp) {
        if (mrp.getEndDate() != null) {
            return mrp.getEndDate();
        }
        MrpLine mrpLine = (MrpLine)((Object)this.mrpLineRepository.all().filter("self.mrp.id = ?1", new Object[]{mrp.getId()}).order("-maturityDate").fetchOne());
        if (mrpLine != null && mrpLine.getMaturityDate() != null) {
            return mrpLine.getMaturityDate();
        }
        return this.today;
    }

    @Override
    public Mrp createProjectedStock(Mrp mrp, Product product, Company company, StockLocation stockLocation) throws AxelorException {
        this.completeProjectedStock(mrp, product, company, stockLocation);
        this.computeCumulativeQty(product);
        return mrp;
    }

    protected Mrp completeProjectedStock(Mrp mrp, Product product, Company company, StockLocation stockLocation) throws AxelorException {
        this.mrp = mrp;
        mrp.addProductSetItem(product);
        this.stockLocationList = stockLocation != null ? this.stockLocationService.getAllLocationAndSubLocation(mrp.getStockLocation(), false) : (company != null ? this.stockLocationRepository.all().filter("self.company.id = ?1 AND self.typeSelect != ?2", new Object[]{company.getId(), 3}).fetch() : this.stockLocationRepository.all().filter("self.typeSelect != ?1", new Object[]{3}).fetch());
        this.startMrp((Mrp)((Object)this.mrpRepository.find(mrp.getId())));
        this.assignProductAndLevel(this.getProductList());
        this.createAvailableStockMrpLines();
        this.createPurchaseMrpLines();
        this.createSaleOrderMrpLines();
        return mrp;
    }
}

