/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderLineRepository;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.repo.StockLocationLineRepository;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.supplychain.service.ProductStockLocationService;
import com.axelor.apps.supplychain.service.PurchaseOrderStockService;
import com.axelor.apps.supplychain.service.SaleOrderLineServiceSupplyChain;
import com.axelor.apps.supplychain.service.StockLocationServiceSupplychain;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProductStockLocationServiceImpl
implements ProductStockLocationService {
    protected UnitConversionService unitConversionService;
    protected AppSupplychainService appSupplychainService;
    protected ProductRepository productRepository;
    protected CompanyRepository companyRepository;
    protected StockLocationRepository stockLocationRepository;
    protected StockLocationService stockLocationService;
    protected StockLocationLineService stockLocationLineService;
    protected StockLocationLineRepository stockLocationLineRepository;
    protected StockLocationServiceSupplychain stockLocationServiceSupplychain;

    @Inject
    public ProductStockLocationServiceImpl(UnitConversionService unitConversionService, AppSupplychainService appSupplychainService, ProductRepository productRepository, CompanyRepository companyRepository, StockLocationRepository stockLocationRepository, StockLocationService stockLocationService, StockLocationServiceSupplychain stockLocationServiceSupplychain, StockLocationLineService stockLocationLineService, StockLocationLineRepository stockLocationLineRepository) {
        this.unitConversionService = unitConversionService;
        this.appSupplychainService = appSupplychainService;
        this.productRepository = productRepository;
        this.companyRepository = companyRepository;
        this.stockLocationRepository = stockLocationRepository;
        this.stockLocationService = stockLocationService;
        this.stockLocationServiceSupplychain = stockLocationServiceSupplychain;
        this.stockLocationLineService = stockLocationLineService;
        this.stockLocationLineRepository = stockLocationLineRepository;
    }

    @Override
    public Map<String, Object> computeIndicators(Long productId, Long companyId, Long stockLocationId) throws AxelorException {
        List stockLocationList;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Product product = (Product)((Object)this.productRepository.find(productId));
        Company company = (Company)((Object)this.companyRepository.find(companyId));
        StockLocation stockLocation = (StockLocation)((Object)this.stockLocationRepository.find(stockLocationId));
        if (stockLocationId != 0L && companyId != 0L && !(stockLocationList = this.stockLocationService.getAllLocationAndSubLocation(stockLocation, false)).isEmpty()) {
            BigDecimal realQty = BigDecimal.ZERO;
            BigDecimal futureQty = BigDecimal.ZERO;
            BigDecimal reservedQty = BigDecimal.ZERO;
            BigDecimal requestedReservedQty = BigDecimal.ZERO;
            BigDecimal saleOrderQty = BigDecimal.ZERO;
            BigDecimal purchaseOrderQty = BigDecimal.ZERO;
            BigDecimal availableQty = BigDecimal.ZERO;
            saleOrderQty = this.getSaleOrderQty(product, company, stockLocation);
            purchaseOrderQty = this.getPurchaseOrderQty(product, company, stockLocation);
            availableQty = this.getAvailableQty(product, company, stockLocation);
            requestedReservedQty = this.getRequestedReservedQty(product, company, stockLocation);
            for (StockLocation sl : stockLocationList) {
                realQty = realQty.add(this.stockLocationService.getRealQty(productId, sl.getId(), companyId));
                futureQty = futureQty.add(this.stockLocationService.getFutureQty(productId, sl.getId(), companyId));
                reservedQty = reservedQty.add(this.stockLocationServiceSupplychain.getReservedQty(productId, sl.getId(), companyId));
            }
            map.put("$realQty", realQty.setScale(2));
            map.put("$futureQty", futureQty.setScale(2));
            map.put("$reservedQty", reservedQty.setScale(2));
            map.put("$requestedReservedQty", requestedReservedQty.setScale(2));
            map.put("$saleOrderQty", saleOrderQty.setScale(2));
            map.put("$purchaseOrderQty", purchaseOrderQty.setScale(2));
            map.put("$availableQty", availableQty.subtract(reservedQty).setScale(2));
            return map;
        }
        BigDecimal reservedQty = this.stockLocationServiceSupplychain.getReservedQty(productId, stockLocationId, companyId).setScale(2);
        map.put("$realQty", this.stockLocationService.getRealQty(productId, stockLocationId, companyId).setScale(2));
        map.put("$futureQty", this.stockLocationService.getFutureQty(productId, stockLocationId, companyId).setScale(2));
        map.put("$reservedQty", reservedQty);
        map.put("$requestedReservedQty", this.getRequestedReservedQty(product, company, null).setScale(2));
        map.put("$saleOrderQty", this.getSaleOrderQty(product, company, null).setScale(2));
        map.put("$purchaseOrderQty", this.getPurchaseOrderQty(product, company, null).setScale(2));
        map.put("$availableQty", this.getAvailableQty(product, company, null).subtract(reservedQty).setScale(2));
        return map;
    }

    protected BigDecimal getRequestedReservedQty(Product product, Company company, StockLocation stockLocation) throws AxelorException {
        if (product == null || product.getUnit() == null) {
            return BigDecimal.ZERO;
        }
        Long companyId = 0L;
        Long stockLocationId = 0L;
        if (company != null) {
            companyId = company.getId();
        }
        if (stockLocation != null) {
            stockLocationId = stockLocation.getId();
        }
        String query = this.stockLocationLineService.getStockLocationLineListForAProduct(product.getId(), companyId, stockLocationId);
        List stockLocationLineList = this.stockLocationLineRepository.all().filter(query).fetch();
        BigDecimal sumRequestedReservedQty = BigDecimal.ZERO;
        if (!stockLocationLineList.isEmpty()) {
            Unit unitConversion = product.getUnit();
            for (StockLocationLine stockLocationLine : stockLocationLineList) {
                BigDecimal requestedReservedQty = stockLocationLine.getRequestedReservedQty();
                requestedReservedQty = this.unitConversionService.convert(stockLocationLine.getUnit(), unitConversion, requestedReservedQty, requestedReservedQty.scale(), product);
                sumRequestedReservedQty = sumRequestedReservedQty.add(requestedReservedQty);
            }
        }
        return sumRequestedReservedQty;
    }

    protected BigDecimal getSaleOrderQty(Product product, Company company, StockLocation stockLocation) throws AxelorException {
        if (product == null || product.getUnit() == null) {
            return BigDecimal.ZERO;
        }
        Long companyId = 0L;
        Long stockLocationId = 0L;
        if (company != null) {
            companyId = company.getId();
        }
        if (stockLocation != null) {
            stockLocationId = stockLocation.getId();
        }
        String query = ((SaleOrderLineServiceSupplyChain)Beans.get(SaleOrderLineServiceSupplyChain.class)).getSaleOrderLineListForAProduct(product.getId(), companyId, stockLocationId);
        List saleOrderLineList = ((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).all().filter(query).fetch();
        BigDecimal sumSaleOrderQty = BigDecimal.ZERO;
        if (!saleOrderLineList.isEmpty()) {
            Unit unitConversion = product.getUnit();
            for (SaleOrderLine saleOrderLine : saleOrderLineList) {
                BigDecimal productSaleOrderQty = saleOrderLine.getQty();
                if (saleOrderLine.getDeliveryState() == 2) {
                    productSaleOrderQty = productSaleOrderQty.subtract(saleOrderLine.getDeliveredQty());
                }
                productSaleOrderQty = this.unitConversionService.convert(saleOrderLine.getUnit(), unitConversion, productSaleOrderQty, productSaleOrderQty.scale(), product);
                sumSaleOrderQty = sumSaleOrderQty.add(productSaleOrderQty);
            }
        }
        return sumSaleOrderQty;
    }

    protected BigDecimal getPurchaseOrderQty(Product product, Company company, StockLocation stockLocation) throws AxelorException {
        if (product == null || product.getUnit() == null) {
            return BigDecimal.ZERO;
        }
        Long companyId = 0L;
        Long stockLocationId = 0L;
        if (company != null) {
            companyId = company.getId();
        }
        if (stockLocation != null) {
            stockLocationId = stockLocation.getId();
        }
        String query = ((PurchaseOrderStockService)Beans.get(PurchaseOrderStockService.class)).getPurchaseOrderLineListForAProduct(product.getId(), companyId, stockLocationId);
        List purchaseOrderLineList = ((PurchaseOrderLineRepository)((Object)Beans.get(PurchaseOrderLineRepository.class))).all().filter(query).fetch();
        BigDecimal sumPurchaseOrderQty = BigDecimal.ZERO;
        if (!purchaseOrderLineList.isEmpty()) {
            Unit unitConversion = product.getUnit();
            for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
                BigDecimal productPurchaseOrderQty = purchaseOrderLine.getQty();
                if (purchaseOrderLine.getReceiptState() == 2) {
                    productPurchaseOrderQty = productPurchaseOrderQty.subtract(purchaseOrderLine.getReceivedQty());
                }
                productPurchaseOrderQty = this.unitConversionService.convert(purchaseOrderLine.getUnit(), unitConversion, productPurchaseOrderQty, productPurchaseOrderQty.scale(), product);
                sumPurchaseOrderQty = sumPurchaseOrderQty.add(productPurchaseOrderQty);
            }
        }
        return sumPurchaseOrderQty;
    }

    protected BigDecimal getAvailableQty(Product product, Company company, StockLocation stockLocation) throws AxelorException {
        if (product == null || product.getUnit() == null) {
            return BigDecimal.ZERO;
        }
        Long companyId = 0L;
        Long stockLocationId = 0L;
        if (company != null) {
            companyId = company.getId();
        }
        if (stockLocation != null) {
            stockLocationId = stockLocation.getId();
        }
        String query = this.stockLocationLineService.getAvailableStockForAProduct(product.getId(), companyId, stockLocationId);
        List stockLocationLineList = this.stockLocationLineRepository.all().filter(query).fetch();
        BigDecimal sumAvailableQty = BigDecimal.ZERO;
        if (!stockLocationLineList.isEmpty()) {
            Unit unitConversion = product.getUnit();
            for (StockLocationLine stockLocationLine : stockLocationLineList) {
                BigDecimal productAvailableQty = stockLocationLine.getCurrentQty();
                this.unitConversionService.convert(stockLocationLine.getUnit(), unitConversion, productAvailableQty, productAvailableQty.scale(), product);
                sumAvailableQty = sumAvailableQty.add(productAvailableQty);
            }
        }
        return sumAvailableQty;
    }
}

