/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.supplychain.db.Mrp;
import com.axelor.apps.supplychain.db.MrpLine;
import com.axelor.apps.supplychain.db.repo.MrpLineRepository;
import com.axelor.apps.supplychain.db.repo.MrpRepository;
import com.axelor.apps.supplychain.service.MrpService;
import com.axelor.apps.supplychain.service.ProjectedStockService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.rpc.Context;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProjectedStockServiceImpl
implements ProjectedStockService {
    @Inject
    StockLocationRepository stockLocationRepository;

    @Override
    @Transactional(rollbackOn={Exception.class})
    public List<MrpLine> createProjectedStock(Long productId, Long companyId, Long stockLocationId) throws AxelorException {
        Product product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(productId));
        Company company = (Company)((Object)((CompanyRepository)((Object)Beans.get(CompanyRepository.class))).find(companyId));
        StockLocation stockLocation = (StockLocation)((Object)this.stockLocationRepository.find(stockLocationId));
        Mrp mrp = new Mrp();
        mrp.setStockLocation(this.findStockLocation(company, stockLocation));
        if (mrp.getStockLocation() == null) {
            return Collections.emptyList();
        }
        mrp.addProductSetItem(product);
        mrp = (Mrp)((Object)((MrpRepository)((Object)Beans.get(MrpRepository.class))).save((Model)((Object)mrp)));
        mrp = ((MrpService)Beans.get(MrpService.class)).createProjectedStock(mrp, product, company, stockLocation);
        List mrpLineList = ((MrpLineRepository)((Object)Beans.get(MrpLineRepository.class))).all().filter("self.mrp = ?1 AND self.product = ?2 AND self.qty != 0", new Object[]{mrp, product}).order("maturityDate").order("mrpLineType.typeSelect").order("mrpLineType.sequence").order("id").fetch();
        if (mrpLineList.isEmpty()) {
            List mrpLineListToDelete = ((MrpLineRepository)((Object)Beans.get(MrpLineRepository.class))).all().filter("self.mrp = ?1", new Object[]{mrp}).fetch();
            this.removeMrpAndMrpLine(mrpLineListToDelete);
            return Collections.emptyList();
        }
        for (MrpLine mrpLine : mrpLineList) {
            mrpLine.setCompany(mrpLine.getStockLocation().getCompany());
            mrpLine.setUnit(mrpLine.getProduct().getUnit());
        }
        return mrpLineList;
    }

    protected StockLocation findStockLocation(Company company, StockLocation stockLocation) {
        if (stockLocation != null) {
            return stockLocation;
        }
        if (company != null) {
            return (StockLocation)((Object)this.stockLocationRepository.all().filter("self.company.id = ?1", new Object[]{company.getId()}).fetchOne());
        }
        return (StockLocation)((Object)this.stockLocationRepository.all().fetchOne());
    }

    @Override
    public Map<String, Long> getProductIdCompanyIdStockLocationIdFromContext(Context context) {
        Long productId = 0L;
        Long companyId = 0L;
        Long stockLocationId = 0L;
        HashMap<String, Long> mapId = new HashMap<String, Long>();
        LinkedHashMap productHashMap = (LinkedHashMap)context.get((Object)"product");
        if (productHashMap != null) {
            productId = Long.valueOf(productHashMap.get("id").toString());
        } else {
            productHashMap = (LinkedHashMap)context.get((Object)"$product");
            if (productHashMap != null) {
                productId = Long.valueOf(productHashMap.get("id").toString());
            } else {
                return null;
            }
        }
        LinkedHashMap companyHashMap = (LinkedHashMap)context.get((Object)"company");
        if (companyHashMap != null) {
            companyId = Long.valueOf(companyHashMap.get("id").toString());
        } else {
            companyHashMap = (LinkedHashMap)context.get((Object)"$company");
            if (companyHashMap != null) {
                companyId = Long.valueOf(companyHashMap.get("id").toString());
            }
        }
        LinkedHashMap stockLocationHashMap = (LinkedHashMap)context.get((Object)"stockLocation");
        if (stockLocationHashMap != null) {
            stockLocationId = Long.valueOf(stockLocationHashMap.get("id").toString());
        } else {
            stockLocationHashMap = (LinkedHashMap)context.get((Object)"$stockLocation");
            if (stockLocationHashMap != null) {
                stockLocationId = Long.valueOf(stockLocationHashMap.get("id").toString());
            }
        }
        mapId.put("productId", productId);
        mapId.put("companyId", companyId);
        mapId.put("stockLocationId", stockLocationId);
        return mapId;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void removeMrpAndMrpLine(List<MrpLine> mrpLineList) {
        if (mrpLineList != null && !mrpLineList.isEmpty()) {
            Long mrpId = mrpLineList.get(0).getMrp().getId();
            ((MrpLineRepository)((Object)Beans.get(MrpLineRepository.class))).all().filter("self.mrp.id = ?1", new Object[]{mrpId}).remove();
            ((MrpRepository)((Object)Beans.get(MrpRepository.class))).all().filter("self.id = ?1", new Object[]{mrpId}).remove();
        }
    }
}

