/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Budget;
import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.account.db.BudgetLine;
import com.axelor.apps.account.db.repo.BudgetDistributionRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.service.PurchaseOrderServiceImpl;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.apps.supplychain.service.BudgetSupplychainService;
import com.axelor.apps.supplychain.service.IntercoService;
import com.axelor.apps.supplychain.service.PurchaseOrderLineServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.PurchaseOrderStockService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderServiceSupplychainImpl
extends PurchaseOrderServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppSupplychainService appSupplychainService;
    protected AccountConfigService accountConfigService;
    protected AppAccountService appAccountService;
    protected AppBaseService appBaseService;
    protected PurchaseOrderStockService purchaseOrderStockService;
    protected BudgetSupplychainService budgetSupplychainService;

    @Inject
    public PurchaseOrderServiceSupplychainImpl(AppSupplychainService appSupplychainService, AccountConfigService accountConfigService, AppAccountService appAccountService, AppBaseService appBaseService, PurchaseOrderStockService purchaseOrderStockService, BudgetSupplychainService budgetSupplychainService) {
        this.appSupplychainService = appSupplychainService;
        this.accountConfigService = accountConfigService;
        this.appAccountService = appAccountService;
        this.appBaseService = appBaseService;
        this.purchaseOrderStockService = purchaseOrderStockService;
        this.budgetSupplychainService = budgetSupplychainService;
    }

    public PurchaseOrder createPurchaseOrder(User buyerUser, Company company, Partner contactPartner, Currency currency, LocalDate deliveryDate, String internalReference, String externalReference, StockLocation stockLocation, LocalDate orderDate, PriceList priceList, Partner supplierPartner, TradingName tradingName) throws AxelorException {
        LOG.debug("Cr\u00e9ation d'une commande fournisseur : Soci\u00e9t\u00e9 = {},  Reference externe = {}, Fournisseur = {}", new Object[]{company.getName(), externalReference, supplierPartner.getFullName()});
        PurchaseOrder purchaseOrder = super.createPurchaseOrder(buyerUser, company, contactPartner, currency, deliveryDate, internalReference, externalReference, orderDate, priceList, supplierPartner, tradingName);
        purchaseOrder.setStockLocation(stockLocation);
        purchaseOrder.setPaymentMode(supplierPartner.getInPaymentMode());
        purchaseOrder.setPaymentCondition(supplierPartner.getPaymentCondition());
        if (purchaseOrder.getPaymentMode() == null) {
            purchaseOrder.setPaymentMode(this.accountConfigService.getAccountConfig(company).getInPaymentMode());
        }
        if (purchaseOrder.getPaymentCondition() == null) {
            purchaseOrder.setPaymentCondition(this.accountConfigService.getAccountConfig(company).getDefPaymentCondition());
        }
        purchaseOrder.setTradingName(tradingName);
        return purchaseOrder;
    }

    @Transactional
    public void generateBudgetDistribution(PurchaseOrder purchaseOrder) {
        if (purchaseOrder.getPurchaseOrderLineList() != null) {
            for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
                if (purchaseOrderLine.getBudget() == null || purchaseOrderLine.getBudgetDistributionList() != null && !purchaseOrderLine.getBudgetDistributionList().isEmpty()) continue;
                BudgetDistribution budgetDistribution = new BudgetDistribution();
                budgetDistribution.setBudget(purchaseOrderLine.getBudget());
                budgetDistribution.setAmount(purchaseOrderLine.getCompanyExTaxTotal());
                purchaseOrderLine.addBudgetDistributionListItem(budgetDistribution);
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public PurchaseOrder mergePurchaseOrders(List<PurchaseOrder> purchaseOrderList, Currency currency, Partner supplierPartner, Company company, StockLocation stockLocation, Partner contactPartner, PriceList priceList, TradingName tradingName) throws AxelorException {
        String numSeq = "";
        String externalRef = "";
        for (PurchaseOrder purchaseOrderLocal : purchaseOrderList) {
            if (!numSeq.isEmpty()) {
                numSeq = numSeq + "-";
            }
            numSeq = numSeq + purchaseOrderLocal.getPurchaseOrderSeq();
            if (!externalRef.isEmpty()) {
                externalRef = externalRef + "|";
            }
            if (purchaseOrderLocal.getExternalReference() == null) continue;
            externalRef = externalRef + purchaseOrderLocal.getExternalReference();
        }
        PurchaseOrder purchaseOrderMerged = this.createPurchaseOrder(AuthUtils.getUser(), company, contactPartner, currency, null, numSeq, externalRef, stockLocation, LocalDate.now(), priceList, supplierPartner, tradingName);
        super.attachToNewPurchaseOrder(purchaseOrderList, purchaseOrderMerged);
        this.computePurchaseOrder(purchaseOrderMerged);
        this.purchaseOrderRepo.save((Model)((Object)purchaseOrderMerged));
        super.removeOldPurchaseOrders(purchaseOrderList);
        return purchaseOrderMerged;
    }

    public void updateAmountToBeSpreadOverTheTimetable(PurchaseOrder purchaseOrder) {
        List<Timetable> timetableList = purchaseOrder.getTimetableList();
        BigDecimal totalHT = purchaseOrder.getExTaxTotal();
        BigDecimal sumTimetableAmount = BigDecimal.ZERO;
        if (timetableList != null) {
            for (Timetable timetable : timetableList) {
                sumTimetableAmount = sumTimetableAmount.add(timetable.getAmount());
            }
        }
        purchaseOrder.setAmountToBeSpreadOverTheTimetable(totalHT.subtract(sumTimetableAmount));
    }

    @Transactional
    public void applyToallBudgetDistribution(PurchaseOrder purchaseOrder) {
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
            BudgetDistribution newBudgetDistribution = new BudgetDistribution();
            newBudgetDistribution.setAmount(purchaseOrderLine.getCompanyExTaxTotal());
            newBudgetDistribution.setBudget(purchaseOrder.getBudget());
            newBudgetDistribution.setPurchaseOrderLine(purchaseOrderLine);
            ((BudgetDistributionRepository)((Object)Beans.get(BudgetDistributionRepository.class))).save((Model)((Object)newBudgetDistribution));
            ((PurchaseOrderLineServiceSupplychainImpl)((Object)Beans.get(PurchaseOrderLineServiceSupplychainImpl.class))).computeBudgetDistributionSumAmount(purchaseOrderLine, purchaseOrder);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void requestPurchaseOrder(PurchaseOrder purchaseOrder) throws AxelorException {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            super.requestPurchaseOrder(purchaseOrder);
            return;
        }
        if (this.appAccountService.isApp("budget") && this.appAccountService.getAppBudget().getCheckAvailableBudget().booleanValue()) {
            List<PurchaseOrderLine> purchaseOrderLines = purchaseOrder.getPurchaseOrderLineList();
            HashMap<Budget, BigDecimal> amountPerBudget = new HashMap<Budget, BigDecimal>();
            if (this.appAccountService.getAppBudget().getManageMultiBudget().booleanValue()) {
                for (PurchaseOrderLine pol : purchaseOrderLines) {
                    for (BudgetDistribution bd : pol.getBudgetDistributionList()) {
                        Budget budget = bd.getBudget();
                        if (!amountPerBudget.containsKey((Object)budget)) {
                            amountPerBudget.put(budget, bd.getAmount());
                        } else {
                            BigDecimal oldAmount = (BigDecimal)amountPerBudget.get((Object)budget);
                            amountPerBudget.put(budget, oldAmount.add(bd.getAmount()));
                        }
                        this.isBudgetExceeded(budget, (BigDecimal)amountPerBudget.get((Object)budget));
                    }
                }
            } else {
                for (PurchaseOrderLine pol : purchaseOrderLines) {
                    Budget budget = pol.getBudget();
                    if (!amountPerBudget.containsKey((Object)budget)) {
                        amountPerBudget.put(budget, pol.getExTaxTotal());
                    } else {
                        BigDecimal oldAmount = (BigDecimal)amountPerBudget.get((Object)budget);
                        amountPerBudget.put(budget, oldAmount.add(pol.getExTaxTotal()));
                    }
                    this.isBudgetExceeded(budget, (BigDecimal)amountPerBudget.get((Object)budget));
                }
            }
        }
        super.requestPurchaseOrder(purchaseOrder);
        int intercoPurchaseCreatingStatus = ((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getIntercoPurchaseCreatingStatusSelect();
        if (purchaseOrder.getInterco().booleanValue() && intercoPurchaseCreatingStatus == 2) {
            ((IntercoService)Beans.get(IntercoService.class)).generateIntercoSaleFromPurchase(purchaseOrder);
        }
        if (purchaseOrder.getCreatedByInterco().booleanValue()) {
            this.fillIntercompanySaleOrderCounterpart(purchaseOrder);
        }
    }

    protected void fillIntercompanySaleOrderCounterpart(PurchaseOrder purchaseOrder) {
        SaleOrder saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).all().filter("self.saleOrderSeq = :saleOrderSeq").bind("saleOrderSeq", (Object)purchaseOrder.getExternalReference()).fetchOne());
        if (saleOrder != null) {
            saleOrder.setExternalReference(purchaseOrder.getPurchaseOrderSeq());
        }
    }

    public void isBudgetExceeded(Budget budget, BigDecimal amount) throws AxelorException {
        if (budget == null) {
            return;
        }
        BudgetLine bl = null;
        for (BudgetLine budgetLine : budget.getBudgetLineList()) {
            if (!DateTool.isBetween((LocalDate)budgetLine.getFromDate(), (LocalDate)budgetLine.getToDate(), (LocalDate)this.appAccountService.getTodayDate())) continue;
            bl = budgetLine;
            break;
        }
        if (bl != null && amount.add(bl.getAmountCommitted()).compareTo(bl.getAmountExpected()) > 0) {
            throw new AxelorException((Model)((Object)budget), 5, I18n.get((String)"Error : you have exceeded the budget %s for this period"), new Object[]{budget.getCode()});
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void validatePurchaseOrder(PurchaseOrder purchaseOrder) throws AxelorException {
        super.validatePurchaseOrder(purchaseOrder);
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return;
        }
        if (this.appSupplychainService.getAppSupplychain().getSupplierStockMoveGenerationAuto().booleanValue() && !this.purchaseOrderStockService.existActiveStockMoveForPurchaseOrder(purchaseOrder.getId())) {
            this.purchaseOrderStockService.createStockMoveFromPurchaseOrder(purchaseOrder);
        }
        if (this.appAccountService.getAppBudget().getActive().booleanValue() && !this.appAccountService.getAppBudget().getManageMultiBudget().booleanValue()) {
            this.generateBudgetDistribution(purchaseOrder);
        }
        int intercoPurchaseCreatingStatus = ((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getIntercoPurchaseCreatingStatusSelect();
        if (purchaseOrder.getInterco().booleanValue() && intercoPurchaseCreatingStatus == 3) {
            ((IntercoService)Beans.get(IntercoService.class)).generateIntercoSaleFromPurchase(purchaseOrder);
        }
        this.budgetSupplychainService.updateBudgetLinesFromPurchaseOrder(purchaseOrder);
    }

    @Transactional
    public void cancelPurchaseOrder(PurchaseOrder purchaseOrder) {
        super.cancelPurchaseOrder(purchaseOrder);
        if (((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            this.budgetSupplychainService.updateBudgetLinesFromPurchaseOrder(purchaseOrder);
        }
    }

    public void setPurchaseOrderLineBudget(PurchaseOrder purchaseOrder) {
        Budget budget = purchaseOrder.getBudget();
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
            purchaseOrderLine.setBudget(budget);
        }
    }
}

