/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.ShippingCoefService;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.apps.supplychain.db.SupplyChainConfig;
import com.axelor.apps.supplychain.service.PurchaseOrderLineServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.PurchaseOrderStockService;
import com.axelor.apps.supplychain.service.StockMoveLineServiceSupplychain;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.apps.supplychain.service.config.SupplyChainConfigService;
import com.axelor.apps.tool.StringTool;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderStockServiceImpl
implements PurchaseOrderStockService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected UnitConversionService unitConversionService;
    protected StockMoveLineRepository stockMoveLineRepository;
    protected PurchaseOrderLineServiceSupplychainImpl purchaseOrderLineServiceSupplychainImpl;
    protected AppBaseService appBaseService;
    protected ShippingCoefService shippingCoefService;
    protected StockMoveLineServiceSupplychain stockMoveLineServiceSupplychain;
    protected StockMoveService stockMoveService;

    @Inject
    public PurchaseOrderStockServiceImpl(UnitConversionService unitConversionService, StockMoveLineRepository stockMoveLineRepository, PurchaseOrderLineServiceSupplychainImpl purchaseOrderLineServiceSupplychainImpl, AppBaseService appBaseService, ShippingCoefService shippingCoefService, StockMoveLineServiceSupplychain stockMoveLineServiceSupplychain, StockMoveService stockMoveService) {
        this.unitConversionService = unitConversionService;
        this.stockMoveLineRepository = stockMoveLineRepository;
        this.purchaseOrderLineServiceSupplychainImpl = purchaseOrderLineServiceSupplychainImpl;
        this.appBaseService = appBaseService;
        this.shippingCoefService = shippingCoefService;
        this.stockMoveLineServiceSupplychain = stockMoveLineServiceSupplychain;
        this.stockMoveService = stockMoveService;
    }

    @Override
    public List<Long> createStockMoveFromPurchaseOrder(PurchaseOrder purchaseOrder) throws AxelorException {
        List<Long> stockMoveId;
        ArrayList<Long> stockMoveIdList = new ArrayList<Long>();
        if (purchaseOrder.getPurchaseOrderLineList() == null || purchaseOrder.getCompany() == null) {
            return stockMoveIdList;
        }
        if (purchaseOrder.getStockLocation() == null) {
            throw new AxelorException((Model)((Object)purchaseOrder), 4, I18n.get((String)"Stock location is missing for the purchase order %s."), new Object[]{purchaseOrder.getPurchaseOrderSeq()});
        }
        Map<LocalDate, List<PurchaseOrderLine>> purchaseOrderLinePerDateMap = this.getAllPurchaseOrderLinePerDate(purchaseOrder);
        for (LocalDate estimatedDeliveryDate : purchaseOrderLinePerDateMap.keySet().stream().filter(x -> x != null).sorted((x, y) -> x.compareTo((ChronoLocalDate)y)).collect(Collectors.toList())) {
            List<PurchaseOrderLine> purchaseOrderLineList;
            List<Long> stockMoveId2 = this.createStockMove(purchaseOrder, estimatedDeliveryDate, purchaseOrderLineList = purchaseOrderLinePerDateMap.get(estimatedDeliveryDate));
            if (stockMoveId2 == null || stockMoveId2.isEmpty()) continue;
            stockMoveIdList.addAll(stockMoveId2);
        }
        Optional<List<PurchaseOrderLine>> purchaseOrderLineListDeliveryDateNull = Optional.ofNullable(purchaseOrderLinePerDateMap.get(null));
        if (purchaseOrderLineListDeliveryDateNull.isPresent() && (stockMoveId = this.createStockMove(purchaseOrder, null, purchaseOrderLineListDeliveryDateNull.get())) != null && !stockMoveId.isEmpty()) {
            stockMoveIdList.addAll(stockMoveId);
        }
        return stockMoveIdList;
    }

    protected List<Long> createStockMove(PurchaseOrder purchaseOrder, LocalDate estimatedDeliveryDate, List<PurchaseOrderLine> purchaseOrderLineList) throws AxelorException {
        ArrayList<Long> stockMoveIdList = new ArrayList<Long>();
        Partner supplierPartner = purchaseOrder.getSupplierPartner();
        Company company = purchaseOrder.getCompany();
        Address address = ((PartnerService)Beans.get(PartnerService.class)).getDeliveryAddress(supplierPartner);
        StockLocation startLocation = this.getStartStockLocation(purchaseOrder);
        StockMove stockMove = this.stockMoveService.createStockMove(address, null, company, supplierPartner, startLocation, purchaseOrder.getStockLocation(), null, estimatedDeliveryDate, purchaseOrder.getNotes(), purchaseOrder.getShipmentMode(), purchaseOrder.getFreightCarrierMode(), null, null, null, 3);
        StockMove qualityStockMove = this.stockMoveService.createStockMove(address, null, company, supplierPartner, startLocation, company.getStockConfig().getQualityControlDefaultStockLocation(), null, estimatedDeliveryDate, purchaseOrder.getNotes(), purchaseOrder.getShipmentMode(), purchaseOrder.getFreightCarrierMode(), null, null, null, 3);
        stockMove.setOriginId(purchaseOrder.getId());
        stockMove.setOriginTypeSelect("com.axelor.apps.purchase.db.PurchaseOrder");
        stockMove.setOrigin(purchaseOrder.getPurchaseOrderSeq());
        stockMove.setTradingName(purchaseOrder.getTradingName());
        qualityStockMove.setOriginId(purchaseOrder.getId());
        qualityStockMove.setOriginTypeSelect("com.axelor.apps.purchase.db.PurchaseOrder");
        qualityStockMove.setOrigin(purchaseOrder.getPurchaseOrderSeq());
        qualityStockMove.setTradingName(purchaseOrder.getTradingName());
        SupplyChainConfig supplychainConfig = ((SupplyChainConfigService)Beans.get(SupplyChainConfigService.class)).getSupplyChainConfig(purchaseOrder.getCompany());
        if (supplychainConfig.getDefaultEstimatedDateForPurchaseOrder() == 0 && stockMove.getEstimatedDate() == null) {
            stockMove.setEstimatedDate(this.appBaseService.getTodayDate());
        } else if (supplychainConfig.getDefaultEstimatedDateForPurchaseOrder() == 2 && stockMove.getEstimatedDate() == null) {
            stockMove.setEstimatedDate(this.appBaseService.getTodayDate().plusDays(supplychainConfig.getNumberOfDaysForPurchaseOrder().longValue()));
        }
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
            BigDecimal qty = this.purchaseOrderLineServiceSupplychainImpl.computeUndeliveredQty(purchaseOrderLine);
            if (qty.signum() <= 0 || this.existActiveStockMoveForPurchaseOrderLine(purchaseOrderLine)) continue;
            this.createStockMoveLine(stockMove, qualityStockMove, purchaseOrderLine, qty);
        }
        if (stockMove.getStockMoveLineList() != null && !stockMove.getStockMoveLineList().isEmpty()) {
            this.stockMoveService.plan(stockMove);
            stockMoveIdList.add(stockMove.getId());
        }
        if (qualityStockMove.getStockMoveLineList() != null && !qualityStockMove.getStockMoveLineList().isEmpty()) {
            this.stockMoveService.plan(qualityStockMove);
            stockMoveIdList.add(qualityStockMove.getId());
        }
        return stockMoveIdList;
    }

    protected StockLocation getStartStockLocation(PurchaseOrder purchaseOrder) throws AxelorException {
        Company company = purchaseOrder.getCompany();
        StockLocation startLocation = ((StockLocationRepository)((Object)Beans.get(StockLocationRepository.class))).findByPartner(purchaseOrder.getSupplierPartner());
        if (startLocation == null) {
            StockConfigService stockConfigService = (StockConfigService)Beans.get(StockConfigService.class);
            StockConfig stockConfig = stockConfigService.getStockConfig(company);
            startLocation = stockConfigService.getSupplierVirtualStockLocation(stockConfig);
        }
        if (startLocation == null) {
            throw new AxelorException((Model)((Object)purchaseOrder), 4, I18n.get((String)"%s please configure a virtual supplier stock location for the company %s"), new Object[]{company.getName()});
        }
        return startLocation;
    }

    protected Map<LocalDate, List<PurchaseOrderLine>> getAllPurchaseOrderLinePerDate(PurchaseOrder purchaseOrder) {
        HashMap<LocalDate, List<PurchaseOrderLine>> purchaseOrderLinePerDateMap = new HashMap<LocalDate, List<PurchaseOrderLine>>();
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
            ArrayList<PurchaseOrderLine> purchaseOrderLineLists;
            if (this.purchaseOrderLineServiceSupplychainImpl.computeUndeliveredQty(purchaseOrderLine).signum() <= 0) continue;
            LocalDate dateKey = purchaseOrderLine.getEstimatedDelivDate();
            if (dateKey == null) {
                dateKey = purchaseOrderLine.getPurchaseOrder().getDeliveryDate();
            }
            if ((purchaseOrderLineLists = (ArrayList<PurchaseOrderLine>)purchaseOrderLinePerDateMap.get(dateKey)) == null) {
                purchaseOrderLineLists = new ArrayList<PurchaseOrderLine>();
                purchaseOrderLinePerDateMap.put(dateKey, purchaseOrderLineLists);
            }
            purchaseOrderLineLists.add(purchaseOrderLine);
        }
        return purchaseOrderLinePerDateMap;
    }

    @Override
    public StockMoveLine createStockMoveLine(StockMove stockMove, StockMove qualityStockMove, PurchaseOrderLine purchaseOrderLine, BigDecimal qty) throws AxelorException {
        StockMoveLine stockMoveLine = null;
        if (this.isStockMoveProduct(purchaseOrderLine)) {
            stockMoveLine = this.createProductStockMoveLine(purchaseOrderLine, qty, this.needControlOnReceipt(purchaseOrderLine) ? qualityStockMove : stockMove);
        } else if (purchaseOrderLine.getIsTitleLine().booleanValue()) {
            stockMoveLine = this.createTitleStockMoveLine(purchaseOrderLine, stockMove);
        }
        return stockMoveLine;
    }

    protected boolean needControlOnReceipt(PurchaseOrderLine purchaseOrderLine) {
        Product product = purchaseOrderLine.getProduct();
        PurchaseOrder purchaseOrder = purchaseOrderLine.getPurchaseOrder();
        return product.getControlOnReceipt() != false && purchaseOrder.getStockLocation().getDirectOrderLocation() == false;
    }

    protected StockMoveLine createProductStockMoveLine(PurchaseOrderLine purchaseOrderLine, BigDecimal qty, StockMove stockMove) throws AxelorException {
        PurchaseOrder purchaseOrder = purchaseOrderLine.getPurchaseOrder();
        Product product = purchaseOrderLine.getProduct();
        Unit unit = product.getUnit();
        BigDecimal priceDiscounted = purchaseOrderLine.getPriceDiscounted();
        BigDecimal companyUnitPriceUntaxed = purchaseOrderLine.getCompanyExTaxTotal();
        if (purchaseOrderLine.getQty().compareTo(BigDecimal.ZERO) != 0) {
            companyUnitPriceUntaxed = purchaseOrderLine.getCompanyExTaxTotal().divide(purchaseOrderLine.getQty(), this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_EVEN);
        }
        if (unit != null && !unit.equals((Object)purchaseOrderLine.getUnit())) {
            qty = this.unitConversionService.convert(purchaseOrderLine.getUnit(), unit, qty, qty.scale(), product);
            priceDiscounted = this.unitConversionService.convert(unit, purchaseOrderLine.getUnit(), priceDiscounted, this.appBaseService.getNbDecimalDigitForUnitPrice(), product);
            companyUnitPriceUntaxed = this.unitConversionService.convert(unit, purchaseOrderLine.getUnit(), companyUnitPriceUntaxed, this.appBaseService.getNbDecimalDigitForUnitPrice(), product);
        }
        BigDecimal shippingCoef = this.shippingCoefService.getShippingCoef(product, purchaseOrder.getSupplierPartner(), purchaseOrder.getCompany(), qty);
        priceDiscounted = priceDiscounted.multiply(shippingCoef);
        companyUnitPriceUntaxed = companyUnitPriceUntaxed.multiply(shippingCoef);
        BigDecimal taxRate = BigDecimal.ZERO;
        TaxLine taxLine = purchaseOrderLine.getTaxLine();
        if (taxLine != null) {
            taxRate = taxLine.getValue();
        }
        return this.stockMoveLineServiceSupplychain.createStockMoveLine(product, purchaseOrderLine.getProductName(), purchaseOrderLine.getDescription(), qty, BigDecimal.ZERO, priceDiscounted, companyUnitPriceUntaxed, unit, stockMove, 2, purchaseOrder.getInAti(), taxRate, null, purchaseOrderLine);
    }

    protected StockMoveLine createTitleStockMoveLine(PurchaseOrderLine purchaseOrderLine, StockMove stockMove) throws AxelorException {
        return this.stockMoveLineServiceSupplychain.createStockMoveLine(purchaseOrderLine.getProduct(), purchaseOrderLine.getProductName(), purchaseOrderLine.getDescription(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, stockMove, 2, purchaseOrderLine.getPurchaseOrder().getInAti(), null, null, purchaseOrderLine);
    }

    @Override
    public void cancelReceipt(PurchaseOrder purchaseOrder) throws AxelorException {
        List stockMoveList = ((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).all().filter("self.originTypeSelect = ? AND self.originId = ? AND self.statusSelect = 2", new Object[]{"com.axelor.apps.purchase.db.PurchaseOrder", purchaseOrder.getId()}).fetch();
        for (StockMove stockMove : stockMoveList) {
            this.stockMoveService.cancel(stockMove);
        }
    }

    @Override
    public boolean isStockMoveProduct(PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        return this.isStockMoveProduct(purchaseOrderLine, purchaseOrderLine.getPurchaseOrder());
    }

    @Override
    public boolean isStockMoveProduct(PurchaseOrderLine purchaseOrderLine, PurchaseOrder purchaseOrder) throws AxelorException {
        Company company = purchaseOrder.getCompany();
        SupplyChainConfig supplyChainConfig = ((SupplyChainConfigService)Beans.get(SupplyChainConfigService.class)).getSupplyChainConfig(company);
        Product product = purchaseOrderLine.getProduct();
        return product != null && ("service".equals(product.getProductTypeSelect()) && supplyChainConfig.getHasInSmForNonStorableProduct() != false && product.getIsShippingCostsProduct() == false || "storable".equals(product.getProductTypeSelect()) && supplyChainConfig.getHasInSmForStorableProduct() != false);
    }

    protected boolean existActiveStockMoveForPurchaseOrderLine(PurchaseOrderLine purchaseOrderLine) {
        long stockMoveLineCount = this.stockMoveLineRepository.all().filter("self.purchaseOrderLine.id = ?1 AND self.stockMove.statusSelect in (?2,?3)", new Object[]{purchaseOrderLine.getId(), 1, 2}).count();
        return stockMoveLineCount > 0L;
    }

    @Override
    public boolean existActiveStockMoveForPurchaseOrder(Long purchaseOrderId) {
        long nbStockMove = ((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).all().filter("self.originTypeSelect LIKE ? AND self.originId = ? AND self.statusSelect <> ?", new Object[]{"com.axelor.apps.purchase.db.PurchaseOrder", purchaseOrderId, 4}).count();
        return nbStockMove > 0L;
    }

    @Override
    public void updateReceiptState(PurchaseOrder purchaseOrder) throws AxelorException {
        purchaseOrder.setReceiptState(this.computeReceiptState(purchaseOrder));
    }

    private int computeReceiptState(PurchaseOrder purchaseOrder) throws AxelorException {
        if (purchaseOrder.getPurchaseOrderLineList() == null || purchaseOrder.getPurchaseOrderLineList().isEmpty()) {
            return 1;
        }
        int receiptState = -1;
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
            if (!this.isStockMoveProduct(purchaseOrderLine, purchaseOrder)) continue;
            if (purchaseOrderLine.getReceiptState() == 3) {
                if (receiptState == 1 || receiptState == 2) {
                    return 2;
                }
                receiptState = 3;
                continue;
            }
            if (purchaseOrderLine.getReceiptState() == 1) {
                if (receiptState == 3 || receiptState == 2) {
                    return 2;
                }
                receiptState = 1;
                continue;
            }
            if (purchaseOrderLine.getReceiptState() != 2) continue;
            return 2;
        }
        return receiptState;
    }

    @Override
    public String getPurchaseOrderLineListForAProduct(Long productId, Long companyId, Long stockLocationId) {
        List<Integer> statusList = new ArrayList<Integer>();
        statusList.add(3);
        String status = ((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getpOFilterOnStockDetailStatusSelect();
        if (!StringUtils.isBlank((CharSequence)status)) {
            statusList = StringTool.getIntegerList((String)status);
        }
        String statusListQuery = statusList.stream().map(String::valueOf).collect(Collectors.joining(","));
        String query = "self.product.id = " + productId + " AND self.receiptState != " + 3 + " AND self.purchaseOrder.statusSelect IN (" + statusListQuery + ")";
        if (companyId != 0L) {
            query = query + " AND self.purchaseOrder.company.id = " + companyId;
            if (stockLocationId != 0L) {
                StockLocation stockLocation = (StockLocation)((Object)((StockLocationRepository)((Object)Beans.get(StockLocationRepository.class))).find(stockLocationId));
                List stockLocationList = ((StockLocationService)Beans.get(StockLocationService.class)).getAllLocationAndSubLocation(stockLocation, false);
                if (!stockLocationList.isEmpty() && stockLocation.getCompany().getId() == companyId) {
                    query = query + " AND self.purchaseOrder.stockLocation.id IN (" + StringTool.getIdListString((Collection)stockLocationList) + ") ";
                }
            }
        }
        return query;
    }
}

